/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.Piece;
import com.gluonhq.richtextarea.model.PieceTable;
import com.gluonhq.richtextarea.model.TextBuffer;
import com.gluonhq.richtextarea.model.TextDecoration;
import com.gluonhq.richtextarea.undo.AbstractCommand;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

class InsertCmd
extends AbstractCommand<PieceTable> {
    private final String text;
    private final int insertPosition;
    private Collection<Piece> newPieces;
    private Piece oldPiece;
    private int opPieceIndex;
    private boolean execSuccess = false;

    InsertCmd(String text, int insertPosition) {
        this.text = Objects.requireNonNull(text);
        this.insertPosition = insertPosition;
    }

    @Override
    protected void doUndo(PieceTable pt) {
        if (this.execSuccess) {
            pt.pieces.add(this.opPieceIndex, this.oldPiece);
            pt.pieces.removeAll(this.newPieces);
            pt.fire(new TextBuffer.DeleteEvent(this.insertPosition, this.text.length()));
            pt.textLengthProperty.set(pt.getTextLength() - this.text.length());
        }
    }

    @Override
    protected void doRedo(PieceTable pt) {
        if (this.text.isEmpty()) {
            return;
        }
        if (this.insertPosition < 0 || this.insertPosition > pt.getTextLength()) {
            throw new IllegalArgumentException("Position is outside text bounds");
        }
        if (this.insertPosition == pt.getTextLength()) {
            pt.append(this.text);
        } else {
            pt.walkPieces((piece, pieceIndex, textPosition) -> {
                if (PieceTable.inRange(this.insertPosition, textPosition, piece.length)) {
                    int pieceOffset = this.insertPosition - textPosition;
                    Decoration decoration = pieceOffset > 0 ? (TextDecoration)piece.getDecoration() : pt.previousPieceDecoration(pieceIndex);
                    ParagraphDecoration paragraphDecoration = pt.getParagraphDecorationAtCaret(this.insertPosition) != null ? pt.getParagraphDecorationAtCaret(this.insertPosition) : pt.previousPieceParagraphDecoration(pieceIndex);
                    this.newPieces = PieceTable.normalize(List.of(piece.pieceBefore(pieceOffset), pt.appendTextInternal(this.text, pieceTable.decorationAtCaret != null ? pieceTable.decorationAtCaret : decoration, paragraphDecoration), piece.pieceFrom(pieceOffset)));
                    this.oldPiece = piece;
                    pieceTable.pieces.addAll(pieceIndex, this.newPieces);
                    pieceTable.pieces.remove(this.oldPiece);
                    this.opPieceIndex = pieceIndex;
                    pt.fire(new TextBuffer.InsertEvent(this.text, this.insertPosition));
                    this.execSuccess = true;
                    return true;
                }
                return false;
            });
        }
    }

    public String toString() {
        return "InsertCmd[\"" + this.text + "\" at " + this.insertPosition + "]";
    }
}

