/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.TableDecoration;
import java.util.Objects;
import javafx.geometry.Insets;
import javafx.scene.text.TextAlignment;

public class ParagraphDecoration
implements Decoration {
    private Double spacing;
    private TextAlignment alignment;
    private Double topInset;
    private Double rightInset;
    private Double bottomInset;
    private Double leftInset;
    private int indentationLevel = -1;
    private GraphicType graphicType;
    private TableDecoration tableDecoration;

    private ParagraphDecoration() {
    }

    public double getSpacing() {
        return this.spacing;
    }

    public TextAlignment getAlignment() {
        return this.alignment;
    }

    public double getTopInset() {
        return this.topInset;
    }

    public double getRightInset() {
        return this.rightInset;
    }

    public double getBottomInset() {
        return this.bottomInset;
    }

    public double getLeftInset() {
        return this.leftInset;
    }

    public int getIndentationLevel() {
        return this.indentationLevel;
    }

    public GraphicType getGraphicType() {
        return this.graphicType;
    }

    public boolean hasTableDecoration() {
        return this.tableDecoration != null && this.tableDecoration.getRows() > 0 && this.tableDecoration.getColumns() > 0;
    }

    public TableDecoration getTableDecoration() {
        return this.tableDecoration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ParagraphDecoration normalize(ParagraphDecoration decoration) {
        if (decoration == null) {
            return this;
        }
        ParagraphDecoration pd = new ParagraphDecoration();
        pd.spacing = Objects.requireNonNullElse(this.spacing, decoration.spacing);
        pd.alignment = Objects.requireNonNullElse(this.alignment, decoration.alignment);
        pd.topInset = Objects.requireNonNullElse(this.topInset, decoration.topInset);
        pd.rightInset = Objects.requireNonNullElse(this.rightInset, decoration.rightInset);
        pd.bottomInset = Objects.requireNonNullElse(this.bottomInset, decoration.bottomInset);
        pd.leftInset = Objects.requireNonNullElse(this.leftInset, decoration.leftInset);
        pd.indentationLevel = this.indentationLevel < 0 ? decoration.indentationLevel : this.indentationLevel;
        pd.graphicType = Objects.requireNonNullElse(this.graphicType, decoration.graphicType);
        pd.tableDecoration = Objects.requireNonNullElse(this.tableDecoration, decoration.tableDecoration);
        return pd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParagraphDecoration that = (ParagraphDecoration)o;
        return Double.compare(that.spacing, this.spacing) == 0 && Double.compare(that.topInset, this.topInset) == 0 && Double.compare(that.rightInset, this.rightInset) == 0 && Double.compare(that.bottomInset, this.bottomInset) == 0 && Double.compare(that.leftInset, this.leftInset) == 0 && that.indentationLevel == this.indentationLevel && that.graphicType == this.graphicType && that.alignment == this.alignment && that.tableDecoration == this.tableDecoration;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.spacing, this.alignment, this.topInset, this.rightInset, this.bottomInset, this.leftInset, this.indentationLevel, this.graphicType, this.tableDecoration});
    }

    public String toString() {
        return "PDec{s=" + this.spacing + ", a=" + this.alignment + ", [" + this.topInset + ", " + this.rightInset + ", " + this.bottomInset + ", " + this.leftInset + "]" + ", i=" + this.indentationLevel + ", type=" + (Object)((Object)this.graphicType) + ", " + this.tableDecoration + "}";
    }

    public static class Builder {
        private Double spacing;
        private TextAlignment alignment;
        private Double topInset;
        private Double rightInset;
        private Double bottomInset;
        private Double leftInset;
        private int indentationLevel = -1;
        private GraphicType graphicType;
        private TableDecoration tableDecoration;

        private Builder() {
        }

        public ParagraphDecoration build() {
            ParagraphDecoration decoration = new ParagraphDecoration();
            decoration.spacing = this.spacing;
            decoration.alignment = this.alignment;
            decoration.topInset = this.topInset;
            decoration.rightInset = this.rightInset;
            decoration.bottomInset = this.bottomInset;
            decoration.leftInset = this.leftInset;
            decoration.indentationLevel = this.indentationLevel;
            decoration.graphicType = this.graphicType;
            decoration.tableDecoration = this.tableDecoration;
            return decoration;
        }

        public Builder presets() {
            this.spacing = 0.0;
            this.alignment = TextAlignment.LEFT;
            this.topInset = 0.0;
            this.rightInset = 0.0;
            this.bottomInset = 0.0;
            this.leftInset = 0.0;
            this.indentationLevel = 0;
            this.graphicType = GraphicType.NONE;
            this.tableDecoration = new TableDecoration();
            return this;
        }

        public Builder fromDecoration(ParagraphDecoration decoration) {
            this.spacing = decoration.spacing;
            this.alignment = decoration.alignment;
            this.topInset = decoration.topInset;
            this.rightInset = decoration.rightInset;
            this.bottomInset = decoration.bottomInset;
            this.leftInset = decoration.leftInset;
            this.indentationLevel = decoration.indentationLevel;
            this.graphicType = decoration.graphicType;
            this.tableDecoration = decoration.tableDecoration;
            return this;
        }

        public Builder spacing(double spacing) {
            this.spacing = spacing;
            return this;
        }

        public Builder alignment(TextAlignment alignment) {
            this.alignment = Objects.requireNonNull(alignment);
            return this;
        }

        public Builder insets(double topInset, double rightInset, double bottomInset, double leftInset) {
            this.topInset = topInset;
            this.rightInset = rightInset;
            this.bottomInset = bottomInset;
            this.leftInset = leftInset;
            return this;
        }

        public Builder insets(Insets insets) {
            this.topInset = Objects.requireNonNull(insets).getTop();
            this.rightInset = insets.getRight();
            this.bottomInset = insets.getBottom();
            this.leftInset = insets.getLeft();
            return this;
        }

        public Builder topInset(double topInset) {
            this.topInset = topInset;
            return this;
        }

        public Builder rightInset(double rightInset) {
            this.rightInset = rightInset;
            return this;
        }

        public Builder bottomInset(double bottomInset) {
            this.bottomInset = bottomInset;
            return this;
        }

        public Builder leftInset(double leftInset) {
            this.leftInset = leftInset;
            return this;
        }

        public Builder indentationLevel(int indentationLevel) {
            this.indentationLevel = indentationLevel;
            this.graphicType = indentationLevel == 0 ? GraphicType.NONE : this.graphicType;
            return this;
        }

        public Builder graphicType(GraphicType graphicType) {
            this.indentationLevel = graphicType == GraphicType.NONE ? Math.max(0, this.indentationLevel - 1) : Math.max(1, this.indentationLevel);
            this.graphicType = graphicType;
            return this;
        }

        public Builder tableDecoration(TableDecoration tableDecoration) {
            this.tableDecoration = tableDecoration;
            return this;
        }
    }

    public static enum GraphicType {
        NONE,
        NUMBERED_LIST,
        BULLETED_LIST;

    }
}

