/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.Tools;
import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.PieceTable;
import com.gluonhq.richtextarea.model.TextDecoration;
import java.util.Objects;

public final class Piece {
    final PieceTable source;
    final BufferType bufferType;
    final int start;
    final int length;
    final Decoration decoration;
    final ParagraphDecoration paragraphDecoration;

    public Piece(PieceTable source, BufferType bufferType, int start, int length) {
        this(source, bufferType, start, length, null, null);
    }

    public Piece(PieceTable source, BufferType bufferType, int start, int length, Decoration decoration) {
        this(source, bufferType, start, length, decoration, null);
    }

    public Piece(PieceTable source, BufferType bufferType, int start, int length, Decoration decoration, ParagraphDecoration paragraphDecoration) {
        this.bufferType = bufferType;
        this.start = start;
        this.length = Math.max(length, 0);
        this.source = Objects.requireNonNull(source);
        this.decoration = decoration == null ? TextDecoration.builder().presets().build() : decoration;
        this.paragraphDecoration = paragraphDecoration;
    }

    public boolean isEmpty() {
        return this.length <= 0;
    }

    public void validateOffset(int offset) {
        if (offset < 0 || offset >= this.length) {
            throw new IllegalArgumentException(String.format("Piece offset (%d) is not in range (%d,%d)", offset, 0, this.length));
        }
    }

    public String getText() {
        String buffer = BufferType.ORIGINAL == this.bufferType ? this.source.originalText : this.source.additionBuffer;
        return this.length == 0 ? "" : buffer.substring(this.start, this.start + this.length);
    }

    public Decoration getDecoration() {
        return this.decoration;
    }

    public ParagraphDecoration getParagraphDecoration() {
        return this.paragraphDecoration;
    }

    Piece copy(int newStart, int newLength) {
        return new Piece(this.source, this.bufferType, newStart, newLength, this.decoration, this.paragraphDecoration);
    }

    Piece copy(int newStart, int newLength, Decoration newDecoration) {
        if (this.decoration instanceof TextDecoration) {
            return new Piece(this.source, this.bufferType, newStart, newLength, newDecoration instanceof TextDecoration ? ((TextDecoration)newDecoration).normalize((TextDecoration)this.decoration) : newDecoration, this.paragraphDecoration);
        }
        return new Piece(this.source, this.bufferType, newStart, newLength, this.decoration, this.paragraphDecoration);
    }

    Piece copy(int newStart, int newLength, Decoration decoration, ParagraphDecoration newParagraphDecoration) {
        return new Piece(this.source, this.bufferType, newStart, newLength, decoration, newParagraphDecoration.normalize(this.paragraphDecoration));
    }

    public Piece pieceBefore(int offset) {
        this.validateOffset(offset);
        return this.copy(this.start, offset);
    }

    public Piece pieceFrom(int offset) {
        this.validateOffset(offset);
        return this.copy(this.start + offset, this.length - offset);
    }

    public String toString() {
        return "Piece{type=" + Tools.getFirstLetter(this.bufferType.name()) + ", [" + this.start + ", " + this.length + "], " + this.decoration + ", " + this.paragraphDecoration + ", \"" + this.getText().replaceAll("\n", "<n>").replaceAll("\u200b", "<a>").replaceAll("\u200b", "<t>") + "\"}";
    }

    public static enum BufferType {
        ORIGINAL,
        ADDITION;

    }
}

