/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.model.PieceTable;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

class PieceCharacterIterator
implements CharacterIterator {
    private static final char LF = '\n';
    private final PieceTable pt;
    private int begin;
    private int end;
    private int pos;
    private int[] posArray;
    private List<Integer> lineFeedList;

    public PieceCharacterIterator(PieceTable pt) {
        this.pt = Objects.requireNonNull(pt);
        this.reset();
    }

    public void reset() {
        this.begin = 0;
        this.end = this.pt.getTextLength();
        this.pos = 0;
        this.posArray = new int[this.pt.pieces.size() + 1];
        this.lineFeedList = new ArrayList<Integer>();
        StringBuilder sb = new StringBuilder();
        this.pt.walkPieces((p, i, tp) -> {
            sb.append(p.getText());
            String text = sb.substring(tp);
            IntStream.iterate(text.indexOf(10), index -> index >= 0, index -> text.indexOf(10, index + 1)).boxed().forEach(index -> {
                boolean bl = this.lineFeedList.add(tp + index);
            });
            this.posArray[i] = tp;
            return false;
        });
        this.posArray[this.pt.pieces.size()] = this.end;
    }

    public char charAt(int pos) {
        if (pos < 0 || pos >= this.pt.getTextLength()) {
            throw new IllegalArgumentException("Invalid pos value");
        }
        int i = 0;
        while (i < this.posArray.length) {
            if (this.posArray[i] <= pos && pos < this.posArray[i + 1]) {
                char c = this.pt.pieces.get(i).getText().charAt(pos - this.posArray[i]);
                return c == '\u200b' ? (char)' ' : (char)c;
            }
            ++i;
        }
        return '\u0000';
    }

    public List<Integer> getLineFeedList() {
        return this.lineFeedList;
    }

    @Override
    public char first() {
        this.pos = this.begin;
        return this.current();
    }

    @Override
    public char last() {
        this.pos = this.end != this.begin ? this.end - 1 : this.end;
        return this.current();
    }

    @Override
    public char current() {
        if (this.pos >= this.begin && this.pos < this.end) {
            return this.pt.charAt(this.pos);
        }
        return '\uffff';
    }

    @Override
    public char next() {
        if (this.pos < this.end - 1) {
            ++this.pos;
            return this.pt.charAt(this.pos);
        }
        this.pos = this.end;
        return '\uffff';
    }

    @Override
    public char previous() {
        if (this.pos > this.begin) {
            --this.pos;
            return this.pt.charAt(this.pos);
        }
        return '\uffff';
    }

    @Override
    public char setIndex(int position) {
        if (position < this.begin || position > this.end) {
            throw new IllegalArgumentException("Invalid index");
        }
        this.pos = position;
        return this.current();
    }

    @Override
    public int getIndex() {
        return this.pos;
    }

    @Override
    public int getBeginIndex() {
        return this.begin;
    }

    @Override
    public int getEndIndex() {
        return this.end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PieceCharacterIterator that = (PieceCharacterIterator)o;
        return this.begin == that.begin && this.end == that.end && this.pos == that.pos && Objects.equals(this.pt, that.pt);
    }

    public int hashCode() {
        return Objects.hash(this.pt, this.begin, this.end, this.pos);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException("Clone exception");
        }
    }
}

