/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.model.AbstractTextBuffer;
import com.gluonhq.richtextarea.model.AppendCmd;
import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.DecorationModel;
import com.gluonhq.richtextarea.model.DeleteCmd;
import com.gluonhq.richtextarea.model.Document;
import com.gluonhq.richtextarea.model.ImageDecorateCmd;
import com.gluonhq.richtextarea.model.ImageDecoration;
import com.gluonhq.richtextarea.model.InsertCmd;
import com.gluonhq.richtextarea.model.NodeDecorateCmd;
import com.gluonhq.richtextarea.model.NodeDecoration;
import com.gluonhq.richtextarea.model.ParagraphDecorateCmd;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.Piece;
import com.gluonhq.richtextarea.model.PieceCharacterIterator;
import com.gluonhq.richtextarea.model.TextDecorateCmd;
import com.gluonhq.richtextarea.model.TextDecoration;
import com.gluonhq.richtextarea.undo.CommandManager;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public final class PieceTable
extends AbstractTextBuffer {
    final String originalText;
    String additionBuffer = "";
    final List<Piece> pieces = new ArrayList<Piece>();
    private final CommandManager<PieceTable> commander = new CommandManager<PieceTable>(this);
    private final PieceCharacterIterator pieceCharacterIterator;
    TextDecoration decorationAtCaret;

    public PieceTable(Document document) {
        this.originalText = Objects.requireNonNull(Objects.requireNonNull(document).getText());
        if (document.getDecorations() == null) {
            this.pieces.add(new Piece(this, Piece.BufferType.ORIGINAL, 0, this.originalText.length()));
        } else {
            document.getDecorations().forEach(d -> {
                boolean bl = this.pieces.add(new Piece(this, Piece.BufferType.ORIGINAL, d.getStart(), d.getLength(), d.getDecoration(), d.getParagraphDecoration()));
            });
        }
        this.textLengthProperty.set(this.pieces.stream().mapToInt(b -> b.length).sum());
        this.pieceCharacterIterator = new PieceCharacterIterator(this);
    }

    @Override
    public String getText() {
        return this.pieces.stream().map(Piece::getText).reduce("", (s1, s2) -> String.valueOf(s1) + s2);
    }

    @Override
    public String getText(int start, int end) {
        if (!PieceTable.inRange(start, 0, this.getTextLength())) {
            throw new IllegalArgumentException("Start index " + start + " is not in range [0, " + this.getTextLength() + ")");
        }
        if (end < 0) {
            throw new IllegalArgumentException("End index is not in range");
        }
        int realEnd = Math.min(end, this.getTextLength());
        StringBuilder sb = new StringBuilder();
        for (Piece value : this.pieces) {
            if (sb.length() > realEnd) break;
            sb.append(value.getText());
        }
        return sb.substring(start, realEnd);
    }

    @Override
    public List<DecorationModel> getDecorationModelList() {
        ArrayList<DecorationModel> mergedList = new ArrayList<DecorationModel>();
        if (!this.pieces.isEmpty()) {
            AtomicInteger start = new AtomicInteger();
            DecorationModel dm = null;
            for (Piece piece : this.pieces) {
                if (mergedList.isEmpty()) {
                    dm = new DecorationModel(start.addAndGet(piece.start), piece.length, piece.getDecoration(), piece.getParagraphDecoration());
                } else if (piece.getDecoration().equals(dm.getDecoration()) && piece.getParagraphDecoration().equals(dm.getParagraphDecoration())) {
                    mergedList.remove(mergedList.size() - 1);
                    dm = new DecorationModel(dm.getStart(), dm.getLength() + piece.length, dm.getDecoration(), dm.getParagraphDecoration());
                } else {
                    dm = new DecorationModel(start.addAndGet(dm.getLength()), piece.length, piece.getDecoration(), piece.getParagraphDecoration());
                }
                mergedList.add(dm);
            }
        }
        return mergedList;
    }

    @Override
    public CharacterIterator getCharacterIterator() {
        return this.pieceCharacterIterator;
    }

    @Override
    public char charAt(int pos) {
        return this.pieceCharacterIterator.charAt(pos);
    }

    @Override
    public List<Integer> getLineFeeds() {
        return this.pieceCharacterIterator.getLineFeedList();
    }

    @Override
    public void resetCharacterIterator() {
        this.pieceCharacterIterator.reset();
    }

    Piece appendTextInternal(String text, Decoration decoration, ParagraphDecoration paragraphDecoration) {
        int pos = this.additionBuffer.length();
        this.additionBuffer = String.valueOf(this.additionBuffer) + text;
        this.textLengthProperty.set(this.getTextLength() + text.length());
        return new Piece(this, Piece.BufferType.ADDITION, pos, text.length(), decoration, paragraphDecoration);
    }

    @Override
    public void append(String text) {
        this.commander.execute(new AppendCmd(text));
    }

    @Override
    public void decorate(int start, int end, Decoration decoration) {
        if (decoration instanceof TextDecoration) {
            this.commander.execute(new TextDecorateCmd(start, end, decoration));
        } else if (decoration instanceof ImageDecoration) {
            this.commander.execute(new ImageDecorateCmd((ImageDecoration)decoration, start));
        } else if (decoration instanceof NodeDecoration) {
            this.commander.execute(new NodeDecorateCmd((NodeDecoration)decoration, start));
        } else if (decoration instanceof ParagraphDecoration) {
            this.commander.execute(new ParagraphDecorateCmd(start, end, (ParagraphDecoration)decoration));
        } else {
            throw new IllegalArgumentException("Decoration type not supported: " + decoration);
        }
    }

    @Override
    public void walkFragments(BiConsumer<String, Decoration> onFragment, int start, int end) {
        StringBuilder sb = new StringBuilder();
        this.walkPieces((p, i, tp) -> {
            String text;
            sb.append(p.getText());
            if (start <= tp + p.length && end > tp && !p.getText().isEmpty() && !(text = sb.substring(Math.max(start, tp), Math.min(end, tp + p.length))).isEmpty()) {
                onFragment.accept(text, p.getDecoration());
            }
            return end <= tp;
        });
    }

    @Override
    public Decoration getDecorationAtCaret(int caretPosition) {
        int textPosition = 0;
        int index = 0;
        while (index < this.pieces.size()) {
            Piece piece = this.pieces.get(index);
            if (textPosition < caretPosition && caretPosition <= textPosition + piece.length) {
                return piece.getDecoration();
            }
            textPosition += piece.length;
            ++index;
        }
        return this.previousPieceDecoration(index);
    }

    @Override
    public ParagraphDecoration getParagraphDecorationAtCaret(int caretPosition) {
        int textPosition = 0;
        int index = 0;
        while (index < this.pieces.size()) {
            Piece piece = this.pieces.get(index);
            if (textPosition <= caretPosition && caretPosition < textPosition + piece.length) {
                return piece.getParagraphDecoration();
            }
            textPosition += piece.length;
            ++index;
        }
        return this.previousPieceParagraphDecoration(index);
    }

    @Override
    public void setDecorationAtCaret(TextDecoration decoration) {
        this.decorationAtCaret = decoration;
    }

    @Override
    public void insert(String text, int insertPosition) {
        this.commander.execute(new InsertCmd(text, insertPosition));
    }

    @Override
    public void delete(int deletePosition, int length) {
        this.commander.execute(new DeleteCmd(deletePosition, length));
    }

    @Override
    public void undo() {
        this.commander.undo();
    }

    @Override
    public void redo() {
        this.commander.redo();
    }

    void walkPieces(WalkStep step) {
        int textPosition = 0;
        int i = 0;
        while (i < this.pieces.size()) {
            Piece piece = this.pieces.get(i);
            if (step.process(piece, i, textPosition)) {
                return;
            }
            textPosition += piece.length;
            ++i;
        }
    }

    static Collection<Piece> normalize(Collection<Piece> pieces) {
        return Objects.requireNonNull(pieces).stream().filter(b -> b == null || !b.isEmpty()).collect(Collectors.toList());
    }

    static boolean inRange(int index, int start, int length) {
        return index >= start && index < start + length;
    }

    Decoration previousPieceDecoration(int index) {
        return this.pieces.isEmpty() || !(this.pieces.get(index > 0 ? index - 1 : 0).getDecoration() instanceof TextDecoration) ? TextDecoration.builder().presets().build() : this.pieces.get(index > 0 ? index - 1 : 0).getDecoration();
    }

    ParagraphDecoration previousPieceParagraphDecoration(int index) {
        return this.pieces.isEmpty() ? ParagraphDecoration.builder().presets().build() : this.pieces.get(index > 0 ? index - 1 : 0).getParagraphDecoration();
    }

    public String toString() {
        String p = this.pieces.stream().map(piece -> " - " + piece.toString()).collect(Collectors.joining("\n", "\n", ""));
        return "PieceTable{\n O=\"" + this.originalText.replaceAll("\n", "<n>").replaceAll("\u200b", "<a>").replaceAll("\u200b", "<t>") + "\"" + ",\n A=\"" + this.additionBuffer.replaceAll("\n", "<n>").replaceAll("\u200b", "<a>").replaceAll("\u200b", "<t>") + "\"" + ",\n L=" + this.getTextLength() + ", pieces ->" + p + "\n}";
    }

    @FunctionalInterface
    static interface WalkStep {
        public boolean process(Piece var1, int var2, int var3);
    }
}

