/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.Selection;
import com.gluonhq.richtextarea.viewmodel.RichTextAreaViewModel;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Table {
    public static final Logger LOGGER = Logger.getLogger(Table.class.getName());
    private final String text;
    private final int start;
    private final int rows;
    private final int columns;
    private final List<Integer> positions;
    private final List<String> textCells;

    public Table(String text, int start, int rows, int columns) {
        this.text = text;
        this.start = start;
        this.rows = rows;
        this.columns = columns;
        this.positions = this.getTablePositions();
        this.textCells = this.getTextForCells();
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getTableTextLength() {
        return this.text.length() - (this.text.endsWith("\n") ? 1 : 0);
    }

    public boolean isCaretAtStartOfCell(int caret) {
        return caret == this.start || this.positions.stream().anyMatch(i -> i + 1 == caret);
    }

    public boolean isCaretAtEmptyCell(int caret) {
        int currentCell = this.getCurrentCell(caret);
        return this.textCells.get(currentCell).isEmpty();
    }

    public Selection getCellSelection(int caret) {
        int currentCell = this.getCurrentCell(caret);
        if (currentCell == 0) {
            return new Selection(this.start, this.start + this.textCells.get(0).length());
        }
        return new Selection(this.positions.get(currentCell - 1) + 1, this.positions.get(currentCell));
    }

    public int getNextRow(int caret, RichTextAreaViewModel.Direction direction) {
        return this.getCurrentRow(caret) + (direction == RichTextAreaViewModel.Direction.DOWN ? 1 : 0);
    }

    public int getNextColumn(int caret, RichTextAreaViewModel.Direction direction) {
        return this.getCurrentColumn(caret) + (direction == RichTextAreaViewModel.Direction.FORWARD ? 1 : 0);
    }

    public int getCaretAt(int caret, RichTextAreaViewModel.Direction direction) {
        int currentRow = this.getCurrentRow(caret);
        if (direction == RichTextAreaViewModel.Direction.DOWN) {
            return this.positions.get((currentRow + 1) * this.columns - 1);
        }
        return currentRow == 0 ? this.start : this.positions.get(currentRow * this.columns - 1);
    }

    public int getCaretAtNextRow(int caret, RichTextAreaViewModel.Direction direction) {
        int currentRow = this.getCurrentRow(caret);
        int currentCol = this.getCurrentColumn(caret);
        if (direction == RichTextAreaViewModel.Direction.DOWN) {
            return currentRow < this.rows - 1 ? this.positions.get((currentRow + 1) * this.columns + currentCol) : this.start + this.text.length();
        }
        return currentRow == 0 ? Math.max(this.start - 1, 0) : this.positions.get((currentRow - 1) * this.columns + currentCol);
    }

    public List<Integer> selectNextCell(int caret, RichTextAreaViewModel.Direction direction) {
        int currentCell = this.getCurrentCell(caret);
        if (direction == RichTextAreaViewModel.Direction.FORWARD) {
            return currentCell < this.positions.size() - 1 ? List.of(Integer.valueOf(this.positions.get(currentCell) + 1), this.positions.get(currentCell + 1)) : List.of(Integer.valueOf(this.start + this.text.length()));
        }
        return currentCell == 0 ? List.of(Integer.valueOf(Math.max(this.start - 1, 0))) : List.of(Integer.valueOf(currentCell == 1 ? this.start : this.positions.get(currentCell - 2) + 1), this.positions.get(currentCell - 1));
    }

    public int getCaretAtColumn(int column) {
        return this.positions.get(column);
    }

    public int getRowLength(int caret) {
        int currentRow = this.getCurrentRow(caret);
        return this.getCaretAt(caret, RichTextAreaViewModel.Direction.DOWN) - this.getCaretAt(caret, RichTextAreaViewModel.Direction.UP) + (currentRow == 0 ? 1 : 0);
    }

    public int getCurrentRow(int caret) {
        return (int)this.text.substring(0, caret - this.start).codePoints().filter(c -> c == 8203).count() / this.columns;
    }

    public int getCurrentColumn(int caret) {
        return (int)this.text.substring(0, caret - this.start).codePoints().filter(c -> c == 8203).count() % this.columns;
    }

    public String addColumnAndGetTableText(int caret, RichTextAreaViewModel.Direction direction) {
        int currentCol = this.getCurrentColumn(caret);
        String newText = this.text.endsWith("\n") ? this.text.substring(0, this.text.length() - 1) : this.text;
        int i = this.rows - 1;
        while (i >= 0) {
            int pos = direction == RichTextAreaViewModel.Direction.FORWARD ? this.positions.get(i * this.columns + currentCol) - this.start : (currentCol == 0 && i == 0 ? 0 : this.positions.get(i * this.columns + currentCol - 1) - this.start);
            newText = String.valueOf(newText.substring(0, pos)) + '\u200b' + newText.substring(pos);
            --i;
        }
        return newText;
    }

    public String removeColumnAndGetText(int caret) {
        int currentCol = this.getCurrentColumn(caret);
        String newText = this.text.endsWith("\n") ? this.text.substring(0, this.text.length() - 1) : this.text;
        int i = this.rows - 1;
        while (i >= 0) {
            int posStart = currentCol == 0 && i == 0 ? 0 : this.positions.get(i * this.columns + currentCol - 1) - this.start;
            int posEnd = this.positions.get(i * this.columns + currentCol) - this.start;
            newText = String.valueOf(newText.substring(0, posStart)) + newText.substring(posEnd);
            --i;
        }
        return newText;
    }

    public void printTable() {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        String tableText = this.text.replaceAll("\u200b", "|").replaceAll("\n", "]");
        int start = 0;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.rows) {
            int end = this.positions.get((i + 1) * this.columns - 1);
            sb.append(tableText, start, end + 1);
            if (i < this.rows - 1) {
                sb.append("\n");
            }
            start = end;
            ++i;
        }
        LOGGER.fine("Table:\n" + sb);
    }

    private int getCurrentCell(int caret) {
        int currentRow = this.getCurrentRow(caret);
        int currentCol = this.getCurrentColumn(caret);
        return currentRow * this.columns + currentCol;
    }

    private List<Integer> getTablePositions() {
        List<Integer> positions = IntStream.iterate(this.text.indexOf(8203), index -> index >= 0, index -> this.text.indexOf(8203, index + 1)).boxed().map(i -> i + this.start).collect(Collectors.toList());
        positions.add(this.start + this.text.length() - 1);
        return positions;
    }

    private List<String> getTextForCells() {
        return Stream.of(this.text.split("\u200b")).map(s -> s.replace("\n", "")).collect(Collectors.toList());
    }
}

