/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.model.Decoration;
import java.util.Arrays;
import java.util.Objects;
import javafx.scene.text.TextAlignment;

public class TableDecoration
implements Decoration {
    public static final String TABLE_SEPARATOR = "table_separator";
    private final int rows;
    private final int columns;
    private final TextAlignment[][] cellAlignment;

    public TableDecoration() {
        this(0, 0, null);
    }

    public TableDecoration(int rows, int columns) {
        this(rows, columns, null);
    }

    public TableDecoration(int rows, int columns, TextAlignment[][] cellAlignment) {
        this.rows = rows;
        this.columns = columns;
        TextAlignment[][] defaultCellAlignment = new TextAlignment[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                defaultCellAlignment[i][j] = TextAlignment.LEFT;
                ++j;
            }
            ++i;
        }
        this.cellAlignment = cellAlignment != null ? cellAlignment : defaultCellAlignment;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public TextAlignment[][] getCellAlignment() {
        return this.cellAlignment;
    }

    public static TableDecoration fromTableDecorationInsertingRow(TableDecoration tableDecoration, int row) {
        int rows = tableDecoration.getRows();
        int columns = tableDecoration.getColumns();
        TextAlignment[][] newCellAlignment = new TextAlignment[rows + 1][columns];
        int i = 0;
        while (i < rows + 1) {
            int rowIndex = i > row ? i - 1 : i;
            int j = 0;
            while (j < columns) {
                newCellAlignment[i][j] = i == row ? TextAlignment.LEFT : tableDecoration.getCellAlignment()[rowIndex][j];
                ++j;
            }
            ++i;
        }
        return new TableDecoration(rows + 1, columns, newCellAlignment);
    }

    public static TableDecoration fromTableDecorationDeletingRow(TableDecoration tableDecoration, int row) {
        int rows = tableDecoration.getRows();
        int columns = tableDecoration.getColumns();
        TextAlignment[][] newCellAlignment = new TextAlignment[rows - 1][columns];
        int i = 0;
        while (i < rows) {
            int rowIndex = i;
            if (i != row) {
                if (i > row) {
                    rowIndex = i - 1;
                }
                int j = 0;
                while (j < columns) {
                    newCellAlignment[rowIndex][j] = tableDecoration.getCellAlignment()[i][j];
                    ++j;
                }
            }
            ++i;
        }
        return new TableDecoration(rows - 1, columns, newCellAlignment);
    }

    public static TableDecoration fromTableDecorationInsertingColumn(TableDecoration tableDecoration, int column) {
        int rows = tableDecoration.getRows();
        int columns = tableDecoration.getColumns();
        TextAlignment[][] newCellAlignment = new TextAlignment[rows][columns + 1];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns + 1) {
                int colIndex = j > column ? j - 1 : j;
                newCellAlignment[i][j] = j == column ? TextAlignment.LEFT : tableDecoration.getCellAlignment()[i][colIndex];
                ++j;
            }
            ++i;
        }
        return new TableDecoration(rows, columns + 1, newCellAlignment);
    }

    public static TableDecoration fromTableDecorationDeletingColumn(TableDecoration tableDecoration, int column) {
        int rows = tableDecoration.getRows();
        int columns = tableDecoration.getColumns();
        TextAlignment[][] newCellAlignment = new TextAlignment[rows][columns - 1];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                int colIndex = j;
                if (j != column) {
                    if (j > column) {
                        colIndex = j - 1;
                    }
                    newCellAlignment[i][colIndex] = tableDecoration.getCellAlignment()[i][j];
                }
                ++j;
            }
            ++i;
        }
        return new TableDecoration(rows, columns - 1, newCellAlignment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableDecoration that = (TableDecoration)o;
        return this.rows == that.rows && this.columns == that.columns && Arrays.deepEquals((Object[])this.cellAlignment, (Object[])that.cellAlignment);
    }

    public int hashCode() {
        int result = Objects.hash(this.rows, this.columns);
        result = 31 * result + Arrays.deepHashCode((Object[])this.cellAlignment);
        return result;
    }

    public String toString() {
        return "TabDec[" + this.rows + " x " + this.columns + "] - " + Arrays.deepToString((Object[])this.cellAlignment);
    }
}

