/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.DecorationModel;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.TextDecoration;
import java.text.CharacterIterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.property.ReadOnlyIntegerProperty;

public interface TextBuffer {
    public static final String ZERO_WIDTH_TEXT = "\u200b";
    public static final char ZERO_WIDTH_TABLE_SEPARATOR = '\u200b';

    public int getTextLength();

    public ReadOnlyIntegerProperty textLengthProperty();

    public String getText();

    public String getText(int var1, int var2);

    public List<DecorationModel> getDecorationModelList();

    public CharacterIterator getCharacterIterator();

    public char charAt(int var1);

    public List<Integer> getLineFeeds();

    public void resetCharacterIterator();

    public void insert(String var1, int var2);

    public void append(String var1);

    public void delete(int var1, int var2);

    public void decorate(int var1, int var2, Decoration var3);

    public void undo();

    public void redo();

    public void walkFragments(BiConsumer<String, Decoration> var1, int var2, int var3);

    public void addChangeListener(Consumer<Event> var1);

    public void removeChangeListener(Consumer<Event> var1);

    public Decoration getDecorationAtCaret(int var1);

    public void setDecorationAtCaret(TextDecoration var1);

    public ParagraphDecoration getParagraphDecorationAtCaret(int var1);

    public static class DecorateEvent
    implements Event {
        private final int start;
        private final int end;
        private final Decoration decoration;

        DecorateEvent(int start, int end, Decoration decoration) {
            this.start = start;
            this.end = end;
            this.decoration = decoration;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public Decoration getDecoration() {
            return this.decoration;
        }
    }

    public static class DeleteEvent
    implements Event {
        private final int position;
        private final int length;

        DeleteEvent(int position, int length) {
            this.position = position;
            this.length = length;
        }

        public int getPosition() {
            return this.position;
        }

        public int getLength() {
            return this.length;
        }
    }

    public static interface Event {
    }

    public static class InsertEvent
    implements Event {
        private final String text;
        private final int position;

        InsertEvent(String text, int position) {
            this.text = text;
            this.position = position;
        }

        public String getText() {
            return this.text;
        }

        public int getPosition() {
            return this.position;
        }
    }
}

