/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.Piece;
import com.gluonhq.richtextarea.model.PieceTable;
import com.gluonhq.richtextarea.model.TextBuffer;
import com.gluonhq.richtextarea.undo.AbstractCommand;
import java.util.ArrayList;
import java.util.Collection;

class TextDecorateCmd
extends AbstractCommand<PieceTable> {
    private int start;
    private int end;
    private final Decoration decoration;
    private boolean execSuccess = false;
    private int pieceIndex = -1;
    private Collection<Piece> newPieces = new ArrayList<Piece>();
    private Collection<Piece> oldPieces = new ArrayList<Piece>();

    TextDecorateCmd(int start, int end, Decoration decoration) {
        this.start = start;
        this.end = end;
        this.decoration = decoration;
    }

    @Override
    protected void doUndo(PieceTable pt) {
        if (this.execSuccess) {
            pt.pieces.addAll(this.pieceIndex, this.oldPieces);
            pt.pieces.removeAll(this.newPieces);
            this.oldPieces.forEach(piece -> pt.fire(new TextBuffer.DecorateEvent(piece.start, piece.start + piece.length, piece.decoration)));
        }
    }

    @Override
    protected void doRedo(PieceTable pt) {
        if (!PieceTable.inRange(this.start, 0, pt.getTextLength())) {
            throw new IllegalArgumentException("Position " + this.start + " is outside of text bounds [0, " + pt.getTextLength() + ")");
        }
        if (this.end >= pt.getTextLength()) {
            this.end = pt.getTextLength();
        }
        int[] startPieceIndex = new int[1];
        ArrayList<Piece> additions = new ArrayList<Piece>();
        ArrayList<Piece> removals = new ArrayList<Piece>();
        pt.walkPieces((piece, pieceIndex, textPosition) -> {
            if (this.isPieceInSelection(piece, textPosition)) {
                nArray[0] = pieceIndex;
                if (textPosition <= this.start) {
                    int offset = this.start - textPosition;
                    int length = textPosition + piece.length > this.end ? Math.min(this.end - this.start, piece.length) : piece.length - offset;
                    if (offset > 0) {
                        additions.add(piece.pieceBefore(offset));
                    }
                    additions.add(piece.copy(piece.start + offset, length, this.decoration));
                    if (this.end < textPosition + piece.length) {
                        additions.add(piece.pieceFrom(this.end - textPosition));
                    }
                    removals.add(piece);
                } else if (textPosition + piece.length <= this.end) {
                    additions.add(piece.copy(piece.start, piece.length, this.decoration));
                    removals.add(piece);
                } else if (textPosition < this.end) {
                    int offset = this.end - textPosition;
                    additions.add(piece.copy(piece.start, offset, this.decoration));
                    additions.add(piece.pieceFrom(offset));
                    removals.add(piece);
                }
            }
            return false;
        });
        this.newPieces = PieceTable.normalize(additions);
        this.oldPieces = removals;
        if (this.newPieces.size() > 0 || this.oldPieces.size() > 0) {
            this.pieceIndex = startPieceIndex[0];
            pt.pieces.addAll(this.pieceIndex, this.newPieces);
            pt.pieces.removeAll(this.oldPieces);
            pt.fire(new TextBuffer.DecorateEvent(this.start, this.end, this.decoration));
            this.execSuccess = true;
        }
    }

    private boolean isPieceInSelection(Piece piece, int textPosition) {
        int pieceEndPosition = textPosition + piece.length - 1;
        return this.start <= pieceEndPosition && (this.end >= pieceEndPosition || this.end >= textPosition);
    }

    public String toString() {
        return "TextDecorateCmd[" + this.start + " x " + this.end + "]";
    }
}

