/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.Tools;
import com.gluonhq.richtextarea.model.Decoration;
import java.util.Objects;
import javafx.scene.paint.Color;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public class TextDecoration
implements Decoration {
    private Color foreground;
    private Color background;
    private String fontFamily;
    private double fontSize;
    private FontPosture fontPosture;
    private FontWeight fontWeight;
    private Boolean strikethrough;
    private Boolean underline;
    private String url;

    private TextDecoration() {
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public FontPosture getFontPosture() {
        return this.fontPosture;
    }

    public FontWeight getFontWeight() {
        return this.fontWeight;
    }

    public Boolean isStrikethrough() {
        if (this.strikethrough != null && this.strikethrough.booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean isUnderline() {
        if (this.underline != null && this.underline.booleanValue()) {
            return true;
        }
        return false;
    }

    public String getURL() {
        return this.url;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TextDecoration normalize(TextDecoration decoration) {
        if (decoration == null) {
            return this;
        }
        TextDecoration td = new TextDecoration();
        td.foreground = Objects.requireNonNullElse(this.foreground, decoration.foreground);
        td.background = Objects.requireNonNullElse(this.background, decoration.background);
        td.fontFamily = Objects.requireNonNullElse(this.fontFamily, decoration.fontFamily);
        td.fontSize = this.fontSize < 1.0 ? decoration.fontSize : this.fontSize;
        td.fontWeight = Objects.requireNonNullElse(this.fontWeight, decoration.fontWeight);
        td.fontPosture = Objects.requireNonNullElse(this.fontPosture, decoration.fontPosture);
        td.strikethrough = Objects.requireNonNullElse(this.strikethrough, decoration.strikethrough);
        td.underline = Objects.requireNonNullElse(this.underline, decoration.underline);
        td.url = this.url == null ? decoration.url : this.url;
        return td;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextDecoration that = (TextDecoration)o;
        return Double.compare(that.fontSize, this.fontSize) == 0 && Objects.equals(this.foreground, that.foreground) && Objects.equals(this.background, that.background) && Objects.equals(this.fontFamily, that.fontFamily) && this.fontPosture == that.fontPosture && this.fontWeight == that.fontWeight && Objects.equals(this.strikethrough, that.strikethrough) && Objects.equals(this.underline, that.underline) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.foreground, this.background, this.fontFamily, this.fontSize, this.fontPosture, this.fontWeight, this.strikethrough, this.underline, this.url);
    }

    public String toString() {
        return "TDec{fcolor=" + this.foreground + ", bcolor=" + this.background + ", font['" + this.fontFamily + '\'' + ", " + this.fontSize + ", " + (this.fontPosture != null ? Tools.getFirstLetter(this.fontPosture.name()) : "-") + ", " + (this.fontWeight != null ? Tools.getFirstLetter(this.fontWeight.name()) : "-") + "]" + ", S:" + this.strikethrough + ", U:" + this.underline + ", URL:" + this.url + "}";
    }

    public static class Builder {
        private Color foreground;
        private Color background;
        private String fontFamily;
        private double fontSize;
        private FontPosture fontPosture;
        private FontWeight fontWeight;
        private Boolean strikethrough;
        private Boolean underline;
        private String url;

        private Builder() {
        }

        public TextDecoration build() {
            TextDecoration decoration = new TextDecoration();
            decoration.foreground = this.foreground;
            decoration.background = this.background;
            decoration.fontFamily = this.fontFamily;
            decoration.fontSize = this.fontSize;
            decoration.fontWeight = this.fontWeight;
            decoration.fontPosture = this.fontPosture;
            decoration.strikethrough = this.strikethrough;
            decoration.underline = this.underline;
            decoration.url = this.url;
            return decoration;
        }

        public Builder presets() {
            this.foreground = Color.BLACK;
            this.background = Color.TRANSPARENT;
            this.fontFamily = "System";
            this.fontSize = 12.0;
            this.fontPosture = FontPosture.REGULAR;
            this.fontWeight = FontWeight.NORMAL;
            this.strikethrough = false;
            this.underline = false;
            this.url = null;
            return this;
        }

        public Builder fromDecoration(TextDecoration decoration) {
            this.foreground = decoration.foreground;
            this.background = decoration.background;
            this.fontFamily = decoration.fontFamily;
            this.fontSize = decoration.fontSize;
            this.fontPosture = decoration.fontPosture;
            this.fontWeight = decoration.fontWeight;
            this.strikethrough = decoration.strikethrough;
            this.underline = decoration.underline;
            this.url = decoration.url;
            return this;
        }

        public Builder foreground(Color color) {
            this.foreground = Objects.requireNonNull(color);
            return this;
        }

        public Builder background(Color color) {
            this.background = Objects.requireNonNull(color);
            return this;
        }

        public Builder fontFamily(String fontFamily) {
            this.fontFamily = Objects.requireNonNull(fontFamily);
            return this;
        }

        public Builder fontSize(double fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public Builder fontWeight(FontWeight fontWeight) {
            this.fontWeight = Objects.requireNonNull(fontWeight);
            return this;
        }

        public Builder fontPosture(FontPosture fontPosture) {
            this.fontPosture = Objects.requireNonNull(fontPosture);
            return this;
        }

        public Builder strikethrough(Boolean strikethrough) {
            this.strikethrough = strikethrough;
            return this;
        }

        public Builder underline(Boolean underline) {
            this.underline = underline;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }
    }
}

