/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.undo;

import com.gluonhq.richtextarea.undo.AbstractCommand;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandManager<T> {
    public static final Logger LOGGER = Logger.getLogger(CommandManager.class.getName());
    final Deque<AbstractCommand<T>> undoStack = new ArrayDeque<AbstractCommand<T>>();
    final Deque<AbstractCommand<T>> redoStack = new ArrayDeque<AbstractCommand<T>>();
    final T context;
    private final Runnable runnable;

    public CommandManager(T context) {
        this(context, null);
    }

    public CommandManager(T context, Runnable runnable) {
        this.context = context;
        this.runnable = runnable;
    }

    public void execute(AbstractCommand<T> cmd) {
        Objects.requireNonNull(cmd).execute(this.context);
        this.undoStack.push(cmd);
        this.redoStack.clear();
        this.end();
        LOGGER.log(Level.FINE, "Execute: " + this);
    }

    public void undo() {
        if (!this.undoStack.isEmpty()) {
            AbstractCommand<T> cmd = this.undoStack.pop();
            cmd.undo(this.context);
            this.redoStack.push(cmd);
            this.end();
            LOGGER.log(Level.FINE, "Undo: " + this);
        }
    }

    public void redo() {
        if (!this.redoStack.isEmpty()) {
            AbstractCommand<T> cmd = this.redoStack.pop();
            cmd.redo(this.context);
            this.undoStack.push(cmd);
            this.end();
            LOGGER.log(Level.FINE, "Redo: " + this);
        }
    }

    public int getUndoStackSize() {
        return this.undoStack.size();
    }

    public int getRedoStackSize() {
        return this.redoStack.size();
    }

    public void clearStacks() {
        this.undoStack.clear();
        this.redoStack.clear();
    }

    private void end() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public String toString() {
        return "CommandManager<" + this.context.getClass().getSimpleName() + ">{\n" + " - undoStack=" + this.undoStack + "\n - redoStack=" + this.redoStack + "\n}";
    }
}

