/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.viewmodel;

import com.gluonhq.richtextarea.Selection;
import com.gluonhq.richtextarea.model.Paragraph;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.Table;
import com.gluonhq.richtextarea.model.TableDecoration;
import com.gluonhq.richtextarea.undo.CommandManager;
import com.gluonhq.richtextarea.viewmodel.ActionCmd;
import com.gluonhq.richtextarea.viewmodel.DecorateCmd;
import com.gluonhq.richtextarea.viewmodel.InsertAndDecorateTableCmd;
import com.gluonhq.richtextarea.viewmodel.RemoveAndDecorateTableCmd;
import com.gluonhq.richtextarea.viewmodel.RemoveTextCmd;
import com.gluonhq.richtextarea.viewmodel.ReplaceAndDecorateTableCmd;
import com.gluonhq.richtextarea.viewmodel.RichTextAreaViewModel;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.scene.text.TextAlignment;

class ActionCmdTable
implements ActionCmd {
    private final TableDecoration tableDecoration;
    private final TableOperation tableOperation;
    private final TextAlignment textAlignment;
    private String text;

    public ActionCmdTable(TableDecoration tableDecoration) {
        this(tableDecoration, TableOperation.CREATE_TABLE, null);
    }

    public ActionCmdTable(TableOperation tableOperation) {
        this(null, tableOperation, null);
    }

    public ActionCmdTable(TextAlignment textAlignment) {
        this(null, TableOperation.ALIGN_CELL_CONTENT, textAlignment);
    }

    ActionCmdTable(TableDecoration tableDecoration, TableOperation tableOperation, TextAlignment textAlignment) {
        this.tableDecoration = tableDecoration;
        this.tableOperation = tableOperation;
        this.textAlignment = textAlignment;
    }

    @Override
    public void apply(RichTextAreaViewModel viewModel) {
        if (!viewModel.isEditable() || this.tableOperation == TableOperation.CREATE_TABLE && this.tableDecoration == null) {
            return;
        }
        CommandManager<RichTextAreaViewModel> commandManager = viewModel.getCommandManager();
        if (!(this.tableOperation != TableOperation.CREATE_TABLE || viewModel.getDecorationAtParagraph() != null && viewModel.getDecorationAtParagraph().hasTableDecoration())) {
            viewModel.clearSelection();
            int length = this.tableDecoration.getRows() * this.tableDecoration.getColumns() - 1;
            this.text = length <= 0 ? "" : "\u200b".repeat(length);
            viewModel.getParagraphWithCaret().ifPresent(p -> {
                if (p.getEnd() - p.getStart() > 1) {
                    this.text = "\n" + this.text;
                }
                if (viewModel.getCaretPosition() != p.getEnd() - 1) {
                    this.text = String.valueOf(this.text) + "\n";
                }
            });
            commandManager.execute(new InsertAndDecorateTableCmd(this.text, ParagraphDecoration.builder().tableDecoration(this.tableDecoration).build()));
        } else if (this.tableOperation != TableOperation.CREATE_TABLE && viewModel.getDecorationAtParagraph() != null && viewModel.getDecorationAtParagraph().hasTableDecoration()) {
            viewModel.clearSelection();
            TableDecoration oldTableDecoration = viewModel.getDecorationAtParagraph().getTableDecoration();
            int caret = viewModel.getCaretPosition();
            int oldColumns = oldTableDecoration.getColumns();
            int oldRows = oldTableDecoration.getRows();
            viewModel.getParagraphWithCaret().ifPresent(p -> {
                this.text = viewModel.getTextBuffer().getText(p.getStart(), p.getEnd());
                Table table = new Table(this.text, p.getStart(), oldRows, oldColumns);
                int currentRow = table.getCurrentRow(caret);
                int currentCol = table.getCurrentColumn(caret);
                switch (this.tableOperation) {
                    case ADD_ROW_ABOVE: 
                    case ADD_ROW_BELOW: {
                        RichTextAreaViewModel.Direction direction = this.tableOperation == TableOperation.ADD_ROW_BELOW ? RichTextAreaViewModel.Direction.DOWN : RichTextAreaViewModel.Direction.UP;
                        int newRow = table.getNextRow(caret, direction);
                        TableDecoration newTableDecoration = TableDecoration.fromTableDecorationInsertingRow(oldTableDecoration, newRow);
                        int newCaret = table.getCaretAt(caret, direction);
                        viewModel.setCaretPosition(newCaret);
                        commandManager.execute(new InsertAndDecorateTableCmd("\u200b".repeat(oldColumns), ParagraphDecoration.builder().tableDecoration(newTableDecoration).build()));
                        viewModel.setCaretPosition(newCaret + (this.tableOperation == TableOperation.ADD_ROW_BELOW ? 1 : 0));
                        break;
                    }
                    case DELETE_ROW: {
                        if (oldRows <= 1) break;
                        TableDecoration newTableDecoration = TableDecoration.fromTableDecorationDeletingRow(oldTableDecoration, currentRow);
                        int newCaret = table.getCaretAt(caret, RichTextAreaViewModel.Direction.UP);
                        viewModel.setCaretPosition(newCaret);
                        int length = table.getRowLength(caret);
                        commandManager.execute(new RemoveAndDecorateTableCmd(0, length, ParagraphDecoration.builder().tableDecoration(newTableDecoration).build()));
                        viewModel.setCaretPosition(newCaret);
                        break;
                    }
                    case ADD_COLUMN_BEFORE: 
                    case ADD_COLUMN_AFTER: {
                        RichTextAreaViewModel.Direction direction = this.tableOperation == TableOperation.ADD_COLUMN_AFTER ? RichTextAreaViewModel.Direction.FORWARD : RichTextAreaViewModel.Direction.BACK;
                        int newCol = table.getNextColumn(caret, direction);
                        TableDecoration newTableDecoration = TableDecoration.fromTableDecorationInsertingColumn(oldTableDecoration, newCol);
                        String newText = table.addColumnAndGetTableText(caret, direction);
                        viewModel.setCaretPosition(p.getStart());
                        commandManager.execute(new ReplaceAndDecorateTableCmd(0, table.getTableTextLength(), newText, ParagraphDecoration.builder().tableDecoration(newTableDecoration).build()));
                        viewModel.setCaretPosition(new Table(newText, p.getStart(), oldRows, oldColumns + 1).getCaretAtColumn(newCol));
                        break;
                    }
                    case DELETE_COLUMN: {
                        if (oldColumns <= 1) break;
                        TableDecoration newTableDecoration = TableDecoration.fromTableDecorationDeletingColumn(oldTableDecoration, currentCol);
                        String newText = table.removeColumnAndGetText(caret);
                        viewModel.setCaretPosition(p.getStart());
                        commandManager.execute(new ReplaceAndDecorateTableCmd(0, table.getTableTextLength(), newText, ParagraphDecoration.builder().tableDecoration(newTableDecoration).build()));
                        viewModel.setCaretPosition(new Table(newText, p.getStart(), oldRows, oldColumns - 1).getCaretAtColumn(Math.max(currentCol - 1, 0)));
                        break;
                    }
                    case DELETE_TABLE: {
                        viewModel.setCaretPosition(p.getStart());
                        commandManager.execute(new RemoveAndDecorateTableCmd(0, p.getEnd() - p.getStart() - 1, ParagraphDecoration.builder().presets().build()));
                        viewModel.setCaretPosition(Math.max(p.getStart() - 1, 0));
                        break;
                    }
                    case DELETE_CELL_CONTENT: {
                        Selection cellSelection = table.getCellSelection(caret);
                        if (!cellSelection.isDefined()) break;
                        viewModel.setCaretPosition(cellSelection.getStart());
                        commandManager.execute(new RemoveTextCmd(0, cellSelection.getEnd() - cellSelection.getStart()));
                        break;
                    }
                    case ALIGN_CELL_CONTENT: {
                        tableDecoration.getCellAlignment()[currentRow][currentCol] = this.textAlignment;
                        commandManager.execute(new DecorateCmd(ParagraphDecoration.builder().tableDecoration(oldTableDecoration).build()));
                        break;
                    }
                }
            });
        }
        viewModel.getParagraphWithCaret().filter(p -> p.getEnd() > 0 && p.getDecoration().hasTableDecoration()).ifPresent(p -> {
            this.text = viewModel.getTextBuffer().getText(p.getStart(), p.getEnd());
            TableDecoration tableDecoration = viewModel.getDecorationAtParagraph().getTableDecoration();
            new Table("[" + this.text, 0, tableDecoration.getRows(), tableDecoration.getColumns()).printTable();
        });
    }

    @Override
    public BooleanBinding getDisabledBinding(RichTextAreaViewModel viewModel) {
        return Bindings.createBooleanBinding(() -> {
            if (!viewModel.isEditable()) {
                return true;
            }
            if (this.tableOperation == TableOperation.CREATE_TABLE) {
                if (viewModel.getDecorationAtParagraph() != null && viewModel.getDecorationAtParagraph().hasTableDecoration()) {
                    return true;
                }
                return false;
            }
            if (viewModel.getDecorationAtParagraph() == null || !viewModel.getDecorationAtParagraph().hasTableDecoration()) {
                return true;
            }
            TableDecoration tableDecoration = viewModel.getDecorationAtParagraph().getTableDecoration();
            int oldColumns = tableDecoration.getColumns();
            int oldRows = tableDecoration.getRows();
            if (this.tableOperation == TableOperation.DELETE_ROW) {
                if (oldRows <= 1) {
                    return true;
                }
                return false;
            }
            if (this.tableOperation == TableOperation.DELETE_COLUMN) {
                if (oldColumns <= 1) {
                    return true;
                }
                return false;
            }
            Paragraph paragraph = viewModel.getParagraphWithCaret().orElse(null);
            if (paragraph != null) {
                int caret = viewModel.getCaretPosition();
                this.text = viewModel.getTextBuffer().getText(paragraph.getStart(), paragraph.getEnd());
                Table table = new Table(this.text, paragraph.getStart(), oldRows, oldColumns);
                if (this.tableOperation == TableOperation.DELETE_CELL_CONTENT) {
                    return table.isCaretAtEmptyCell(caret);
                }
                if (this.tableOperation == TableOperation.ALIGN_CELL_CONTENT) {
                    if (tableDecoration.getCellAlignment()[table.getCurrentRow(caret)][table.getCurrentColumn(caret)] == this.textAlignment) {
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }, (Observable[])new Observable[]{viewModel.editableProperty(), viewModel.decorationAtParagraphProperty(), viewModel.caretPositionProperty()});
    }

    public static enum TableOperation {
        CREATE_TABLE,
        DELETE_TABLE,
        ADD_COLUMN_BEFORE,
        ADD_COLUMN_AFTER,
        DELETE_COLUMN,
        ADD_ROW_ABOVE,
        ADD_ROW_BELOW,
        DELETE_ROW,
        DELETE_CELL_CONTENT,
        ALIGN_CELL_CONTENT;

    }
}

