/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.viewmodel;

import com.gluonhq.richtextarea.Selection;
import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.ImageDecoration;
import com.gluonhq.richtextarea.model.NodeDecoration;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.TextDecoration;
import com.gluonhq.richtextarea.viewmodel.AbstractEditCmd;
import com.gluonhq.richtextarea.viewmodel.RichTextAreaViewModel;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class DecorateCmd
extends AbstractEditCmd {
    private final List<Decoration> decorations;
    private Decoration prevDecoration;

    public DecorateCmd(Decoration decoration) {
        this(List.of(decoration));
    }

    public DecorateCmd(List<Decoration> decorations) {
        this.decorations = decorations;
    }

    @Override
    public void doRedo(RichTextAreaViewModel viewModel) {
        Objects.requireNonNull(viewModel);
        if (!this.selection.isDefined() && this.decorations.size() == 1 && this.decorations.get(0) instanceof TextDecoration) {
            this.prevDecoration = viewModel.getDecorationAtCaret();
            viewModel.setDecorationAtCaret(this.decorations.get(0));
        } else {
            Optional<Decoration> decorationAtCaret = this.decorations.stream().filter(decoration -> !this.selection.isDefined() && decoration instanceof TextDecoration).findFirst();
            Selection prevSelection = this.selection;
            if (!this.selection.isDefined()) {
                if (this.decorations.stream().anyMatch(ParagraphDecoration.class::isInstance)) {
                    viewModel.getParagraphWithCaret().ifPresent(p -> {
                        this.selection = new Selection(p.getStart(), p.getEnd() - (p.getEnd() == viewModel.getTextLength() ? 0 : 1));
                        viewModel.setSelection(this.selection);
                    });
                }
            }
            this.decorations.stream().filter(decoration -> this.selection.isDefined() || decoration instanceof ImageDecoration || decoration instanceof ParagraphDecoration || decoration instanceof NodeDecoration).forEach(viewModel::decorate);
            if (prevSelection != this.selection) {
                viewModel.setSelection(prevSelection);
            }
            decorationAtCaret.ifPresent(viewModel::setDecorationAtCaret);
        }
    }

    @Override
    public void doUndo(RichTextAreaViewModel viewModel) {
        Objects.requireNonNull(viewModel);
        if (this.prevDecoration != null && this.prevDecoration instanceof TextDecoration) {
            viewModel.setDecorationAtCaret(this.prevDecoration);
        }
        this.decorations.forEach(decoration -> viewModel.undoDecoration());
    }

    @Override
    public String toString() {
        return "DecorateCmd [" + super.toString() + ", " + this.decorations + "]";
    }
}

