/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.viewmodel;

import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.viewmodel.AbstractEditCmd;
import com.gluonhq.richtextarea.viewmodel.RichTextAreaViewModel;
import java.util.Objects;

class InsertAndDecorateTableCmd
extends AbstractEditCmd {
    private final String content;
    private final Decoration decoration;

    public InsertAndDecorateTableCmd(String content, Decoration decoration) {
        this.content = content;
        this.decoration = decoration;
    }

    @Override
    public void doRedo(RichTextAreaViewModel viewModel) {
        int caretPosition = viewModel.getCaretPosition();
        if (!this.content.isEmpty()) {
            viewModel.insert(this.content);
        }
        viewModel.setCaretPosition(caretPosition + (this.content.length() > 1 && this.content.startsWith("\n") ? 1 : 0));
        if (this.decoration instanceof ParagraphDecoration) {
            Objects.requireNonNull(viewModel).decorate(this.decoration);
        }
    }

    @Override
    public void doUndo(RichTextAreaViewModel viewModel) {
        if (this.decoration instanceof ParagraphDecoration) {
            Objects.requireNonNull(viewModel).undoDecoration();
        }
        if (!this.content.isEmpty()) {
            viewModel.undo();
        }
    }

    @Override
    public String toString() {
        return "InsertAndDecorateTableCmd[" + super.toString() + ", Insert: <" + (this.content != null ? this.content.replace("\n", "<n>") : "") + "]>" + " <Decorate: [" + this.decoration + "]>";
    }
}

