/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.viewmodel;

import com.gluonhq.richtextarea.viewmodel.AbstractEditCmd;
import com.gluonhq.richtextarea.viewmodel.RichTextAreaViewModel;
import java.util.Objects;

class InsertTextCmd
extends AbstractEditCmd {
    private final String content;

    public InsertTextCmd(String content) {
        this.content = content;
    }

    @Override
    public void doRedo(RichTextAreaViewModel viewModel) {
        String text = Objects.requireNonNull(viewModel).getDecorationAtParagraph() != null && viewModel.getDecorationAtParagraph().hasTableDecoration() ? this.content.replace("\n", "") : this.content;
        if (!text.isEmpty()) {
            viewModel.insert(text);
        }
    }

    @Override
    public void doUndo(RichTextAreaViewModel viewModel) {
        Objects.requireNonNull(viewModel).undo();
    }

    @Override
    public String toString() {
        return "InsertTextCmd[" + super.toString() + ", " + (this.content != null ? this.content.replace("\n", "<n>") : "") + "]";
    }
}

