/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.viewmodel;

import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.viewmodel.AbstractEditCmd;
import com.gluonhq.richtextarea.viewmodel.RichTextAreaViewModel;
import java.util.Objects;

class RemoveAndDecorateTableCmd
extends AbstractEditCmd {
    private final int caretOffset;
    private final int length;
    private final Decoration decoration;

    public RemoveAndDecorateTableCmd(int caretOffset, int length, Decoration decoration) {
        this.caretOffset = caretOffset;
        this.length = length;
        this.decoration = decoration;
    }

    @Override
    public void doRedo(RichTextAreaViewModel viewModel) {
        Objects.requireNonNull(viewModel).remove(this.caretOffset, this.length);
        if (this.decoration instanceof ParagraphDecoration) {
            viewModel.decorate(this.decoration);
        }
    }

    @Override
    public void doUndo(RichTextAreaViewModel viewModel) {
        if (this.decoration instanceof ParagraphDecoration) {
            Objects.requireNonNull(viewModel).undoDecoration();
        }
        viewModel.undo();
    }

    @Override
    public String toString() {
        return "RemoveAndDecorateTableCmd[" + super.toString() + ", Remove <" + this.caretOffset + ", " + this.length + "]> " + " <Decorate: [" + this.decoration + "]>";
    }
}

