/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.viewmodel;

import com.gluonhq.richtextarea.Selection;
import com.gluonhq.richtextarea.Tools;
import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.Document;
import com.gluonhq.richtextarea.model.ImageDecoration;
import com.gluonhq.richtextarea.model.NodeDecoration;
import com.gluonhq.richtextarea.model.Paragraph;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.TextBuffer;
import com.gluonhq.richtextarea.model.TextDecoration;
import com.gluonhq.richtextarea.undo.CommandManager;
import com.gluonhq.richtextarea.viewmodel.DecorateCmd;
import com.gluonhq.richtextarea.viewmodel.InsertTextCmd;
import com.gluonhq.richtextarea.viewmodel.RemoveTextCmd;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;

public class RichTextAreaViewModel {
    public static final Logger LOGGER = Logger.getLogger(RichTextAreaViewModel.class.getName());
    private final CommandManager<RichTextAreaViewModel> commandManager = new CommandManager<RichTextAreaViewModel>(this, this::updateProperties);
    private BreakIterator wordIterator;
    private int undoStackSizeWhenSaved = 0;
    private final ObservableList<Paragraph> paragraphList = FXCollections.observableArrayList();
    Paragraph lastParagraph;
    private final ObjectProperty<TextBuffer> textBufferProperty = new SimpleObjectProperty<TextBuffer>((Object)this, "textBuffer"){

        protected void invalidated() {
            RichTextAreaViewModel.this.commandManager.clearStacks();
            RichTextAreaViewModel.this.undoStackSizeWhenSaved = 0;
            RichTextAreaViewModel.this.undoStackSizeProperty.set(0);
            RichTextAreaViewModel.this.redoStackSizeProperty.set(0);
        }
    };
    private final IntegerProperty caretPositionProperty = new SimpleIntegerProperty(this, "caretPosition", -1){

        protected void invalidated() {
            if (!RichTextAreaViewModel.this.hasSelection()) {
                Decoration decorationAtCaret = RichTextAreaViewModel.this.getTextBuffer().getDecorationAtCaret(this.get());
                if (decorationAtCaret instanceof TextDecoration) {
                    RichTextAreaViewModel.this.setDecorationAtCaret(decorationAtCaret);
                }
                RichTextAreaViewModel.this.getParagraphWithCaret().ifPresent(p -> RichTextAreaViewModel.this.setDecorationAtParagraph(p.getDecoration()));
            }
        }
    };
    private final BiFunction<Double, Boolean, Integer> getNextRowPosition;
    private final ObjectProperty<Selection> selectionProperty = new SimpleObjectProperty<Selection>((Object)this, "selection", Selection.UNDEFINED){

        public void set(Selection value) {
            Selection selection = Selection.UNDEFINED;
            if (value != null) {
                selection = value.getEnd() >= RichTextAreaViewModel.this.getTextLength() ? new Selection(value.getStart(), RichTextAreaViewModel.this.getTextLength()) : value;
            }
            super.set((Object)selection);
        }

        protected void invalidated() {
            if (!((Selection)this.get()).isDefined()) {
                RichTextAreaViewModel.this.setDecorationAtCaret(RichTextAreaViewModel.this.getTextBuffer().getDecorationAtCaret(RichTextAreaViewModel.this.getCaretPosition()));
            }
        }
    };
    private final ReadOnlyIntegerWrapper undoStackSizeProperty = new ReadOnlyIntegerWrapper(this, "undoStackSize"){

        protected void invalidated() {
            if (RichTextAreaViewModel.this.isAutoSave()) {
                RichTextAreaViewModel.this.save();
            } else {
                RichTextAreaViewModel.this.savedProperty.set(this.get() == RichTextAreaViewModel.this.undoStackSizeWhenSaved);
            }
        }
    };
    private final ReadOnlyIntegerWrapper redoStackSizeProperty = new ReadOnlyIntegerWrapper((Object)this, "redoStackSize");
    private final BooleanProperty editableProperty = new SimpleBooleanProperty((Object)this, "editable");
    private final ObjectProperty<Decoration> decorationAtCaretProperty = new SimpleObjectProperty<Decoration>((Object)this, "decorationAtCaret"){

        protected void invalidated() {
            if (this.get() instanceof TextDecoration && !RichTextAreaViewModel.this.getSelection().isDefined()) {
                RichTextAreaViewModel.this.getTextBuffer().setDecorationAtCaret((TextDecoration)this.get());
            }
        }
    };
    private final ObjectProperty<ParagraphDecoration> decorationAtParagraphProperty = new SimpleObjectProperty<ParagraphDecoration>((Object)this, "decorationAtParagraph"){

        protected void invalidated() {
        }
    };
    private final ObjectProperty<Document> documentProperty = new SimpleObjectProperty<Document>((Object)this, "document"){

        protected void invalidated() {
            RichTextAreaViewModel.this.paragraphList.clear();
            Document document = (Document)this.get();
            if (document != null) {
                RichTextAreaViewModel.this.updateParagraphList();
                RichTextAreaViewModel.this.getParagraphWithCaret().ifPresent(p -> RichTextAreaViewModel.this.setDecorationAtParagraph(p.getDecoration()));
            }
        }
    };
    private final BooleanProperty autoSaveProperty = new SimpleBooleanProperty((Object)this, "autoSave");
    final ReadOnlyBooleanWrapper savedProperty = new ReadOnlyBooleanWrapper((Object)this, "saved", true);

    public final ObjectProperty<TextBuffer> textBufferProperty() {
        return this.textBufferProperty;
    }

    public final TextBuffer getTextBuffer() {
        TextBuffer textBuffer = (TextBuffer)this.textBufferProperty.get();
        if (textBuffer == null) {
            throw new RuntimeException("Fatal error: TextBuffer was null");
        }
        return textBuffer;
    }

    public final void setTextBuffer(TextBuffer value) {
        this.textBufferProperty.set((Object)value);
    }

    public final IntegerProperty caretPositionProperty() {
        return this.caretPositionProperty;
    }

    public final int getCaretPosition() {
        return this.caretPositionProperty.get();
    }

    public final void setCaretPosition(int value) {
        this.caretPositionProperty.set(value);
    }

    public final ObjectProperty<Selection> selectionProperty() {
        return this.selectionProperty;
    }

    public final Selection getSelection() {
        return (Selection)this.selectionProperty.get();
    }

    public final void setSelection(Selection value) {
        this.selectionProperty.set((Object)value);
    }

    public final ReadOnlyIntegerProperty textLengthProperty() {
        return this.getTextBuffer().textLengthProperty();
    }

    public final int getTextLength() {
        return this.getTextBuffer().getTextLength();
    }

    public final ReadOnlyIntegerProperty undoStackSizeProperty() {
        return this.undoStackSizeProperty.getReadOnlyProperty();
    }

    public final int getUndoStackSize() {
        return this.undoStackSizeProperty.get();
    }

    public final ReadOnlyIntegerProperty redoStackSizeProperty() {
        return this.redoStackSizeProperty.getReadOnlyProperty();
    }

    public final int getRedoStackSize() {
        return this.redoStackSizeProperty.get();
    }

    final BooleanProperty editableProperty() {
        return this.editableProperty;
    }

    final boolean isEditable() {
        return this.editableProperty.get();
    }

    public final void setEditable(boolean value) {
        this.editableProperty.set(value);
    }

    public final ObjectProperty<Decoration> decorationAtCaretProperty() {
        return this.decorationAtCaretProperty;
    }

    public final Decoration getDecorationAtCaret() {
        return (Decoration)this.decorationAtCaretProperty.get();
    }

    public final void setDecorationAtCaret(Decoration value) {
        this.decorationAtCaretProperty.set((Object)value);
    }

    public final ObjectProperty<ParagraphDecoration> decorationAtParagraphProperty() {
        return this.decorationAtParagraphProperty;
    }

    public final ParagraphDecoration getDecorationAtParagraph() {
        return (ParagraphDecoration)this.decorationAtParagraphProperty.get();
    }

    public final void setDecorationAtParagraph(ParagraphDecoration value) {
        this.decorationAtParagraphProperty.set((Object)value);
    }

    public final ObjectProperty<Document> documentProperty() {
        return this.documentProperty;
    }

    public final Document getDocument() {
        return (Document)this.documentProperty.get();
    }

    public final void setDocument(Document value) {
        this.documentProperty.set((Object)value);
    }

    public final BooleanProperty autoSaveProperty() {
        return this.autoSaveProperty;
    }

    public final boolean isAutoSave() {
        return this.autoSaveProperty.get();
    }

    public final void setAutoSave(boolean value) {
        this.autoSaveProperty.set(value);
    }

    public final ReadOnlyBooleanProperty savedProperty() {
        return this.savedProperty.getReadOnlyProperty();
    }

    public final boolean isSaved() {
        return this.savedProperty.get();
    }

    public RichTextAreaViewModel(BiFunction<Double, Boolean, Integer> getNextRowPosition) {
        this.getNextRowPosition = Objects.requireNonNull(getNextRowPosition);
    }

    public ObservableList<Paragraph> getParagraphList() {
        return this.paragraphList;
    }

    public boolean isEmptyParagraph(Paragraph paragraph) {
        if (paragraph == null || paragraph.getEnd() - paragraph.getStart() < 1) {
            return true;
        }
        return paragraph.getEnd() - paragraph.getStart() == 1 && "\n".equals(this.getTextBuffer().getText(paragraph.getStart(), paragraph.getEnd()));
    }

    public final void addChangeListener(Consumer<TextBuffer.Event> listener) {
        this.getTextBuffer().addChangeListener(listener);
    }

    public final void removeChangeListener(Consumer<TextBuffer.Event> listener) {
        this.getTextBuffer().removeChangeListener(listener);
    }

    CommandManager<RichTextAreaViewModel> getCommandManager() {
        return this.commandManager;
    }

    void moveCaretPosition(int charCount) {
        int pos = this.getCaretPosition() + charCount;
        if (pos >= 0 && pos <= this.getTextLength()) {
            this.setCaretPosition(pos);
        }
    }

    boolean hasSelection() {
        return this.getSelection().isDefined();
    }

    public void clearSelection() {
        this.setSelection(Selection.UNDEFINED);
    }

    void insert(String text) {
        this.removeSelection();
        int caretPosition = this.getCaretPosition();
        if (caretPosition >= this.getTextLength()) {
            this.getTextBuffer().append(text);
        } else {
            this.getTextBuffer().insert(text, caretPosition);
        }
        this.moveCaretPosition(text.length());
    }

    void remove(int caretOffset, int length) {
        int position;
        if (!this.removeSelection() && (position = this.getCaretPosition() + caretOffset) >= 0 && position <= this.getTextLength()) {
            this.getTextBuffer().delete(position, length);
            this.setCaretPosition(position);
        }
    }

    void decorate(Decoration decoration) {
        if (decoration instanceof TextDecoration) {
            if (this.getSelection().isDefined()) {
                Selection selection = this.getSelection();
                this.clearSelection();
                int caretPosition = this.getCaretPosition();
                this.setCaretPosition(-1);
                this.getTextBuffer().decorate(selection.getStart(), selection.getEnd(), decoration);
                this.setCaretPosition(caretPosition);
                this.setSelection(selection);
            }
        } else if (decoration instanceof ImageDecoration) {
            int caretPosition = this.getCaretPosition();
            this.setCaretPosition(-1);
            this.getTextBuffer().decorate(caretPosition, 1, decoration);
            this.setCaretPosition(caretPosition + 1);
        } else if (decoration instanceof NodeDecoration) {
            int caretPosition = this.getCaretPosition();
            this.setCaretPosition(-1);
            this.getTextBuffer().decorate(caretPosition, 1, decoration);
            this.setCaretPosition(caretPosition + 1);
        } else if (decoration instanceof ParagraphDecoration) {
            if (this.getSelection().isDefined()) {
                List<Paragraph> paragraphsWithSelection = this.getParagraphsWithSelection();
                if (!paragraphsWithSelection.isEmpty()) {
                    Selection selection = this.getSelection();
                    int caretPosition = this.getCaretPosition();
                    int start = paragraphsWithSelection.get(0).getStart();
                    int end = paragraphsWithSelection.get(paragraphsWithSelection.size() - 1).getEnd();
                    this.setCaretPosition(-1);
                    this.clearSelection();
                    this.getTextBuffer().decorate(start, end, decoration);
                    this.setCaretPosition(caretPosition);
                    this.setSelection(selection);
                }
            } else {
                int caretPosition = this.getCaretPosition();
                Paragraph paragraph = this.getParagraphWithCaret().orElseThrow(() -> new IllegalArgumentException("No paragraph available"));
                this.setCaretPosition(-1);
                this.getTextBuffer().decorate(paragraph.getStart(), paragraph.getEnd(), decoration);
                this.setCaretPosition(caretPosition);
            }
        }
    }

    private boolean removeSelection() {
        if (this.hasSelection()) {
            Selection selection = this.getSelection();
            this.getTextBuffer().delete(selection.getStart(), selection.getLength());
            this.clearSelection();
            this.setCaretPosition(selection.getStart());
            return true;
        }
        return false;
    }

    void clipboardCopy(boolean cutText) {
        Selection selection = this.getSelection();
        if (selection.isDefined()) {
            String selectedText = this.getTextBuffer().getText(selection.getStart(), selection.getEnd());
            ClipboardContent content = new ClipboardContent();
            content.putString(selectedText);
            if (cutText) {
                this.commandManager.execute(new RemoveTextCmd(0));
            }
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
    }

    boolean clipboardHasImage() {
        return Clipboard.getSystemClipboard().hasImage();
    }

    boolean clipboardHasString() {
        return Clipboard.getSystemClipboard().hasString();
    }

    boolean clipboardHasUrl() {
        return Clipboard.getSystemClipboard().hasUrl();
    }

    void clipboardPaste() {
        String text;
        if (this.clipboardHasImage()) {
            Image image = Clipboard.getSystemClipboard().getImage();
            if (image != null) {
                String url;
                String string = url = image.getUrl() != null ? image.getUrl() : Clipboard.getSystemClipboard().getUrl();
                if (url != null) {
                    this.commandManager.execute(new DecorateCmd(new ImageDecoration(url)));
                }
            }
        } else if (this.clipboardHasUrl()) {
            String url = Clipboard.getSystemClipboard().getUrl();
            if (url != null) {
                if (!this.getSelection().isDefined()) {
                    int caret = this.getCaretPosition();
                    this.commandManager.execute(new InsertTextCmd(url));
                    this.setSelection(new Selection(caret, caret + url.length()));
                }
                this.commandManager.execute(new DecorateCmd(TextDecoration.builder().url(url).build()));
            }
        } else if (this.clipboardHasString() && (text = Clipboard.getSystemClipboard().getString()) != null) {
            this.commandManager.execute(new InsertTextCmd(text));
        }
    }

    void moveCaret(Direction direction, boolean changeSelection, boolean wordSelection, boolean lineSelection, boolean paragraphSelection) {
        Selection prevSelection = this.getSelection();
        int prevCaretPosition = this.getCaretPosition();
        switch (direction) {
            case FORWARD: {
                if (wordSelection) {
                    this.nextWord(c -> c.charValue() != ' ' && c.charValue() != '\t' && c.charValue() != '\u200b');
                    break;
                }
                if (lineSelection) {
                    this.lineEnd();
                    break;
                }
                if (paragraphSelection) {
                    this.paragraphEnd();
                    break;
                }
                this.moveCaretPosition(1);
                break;
            }
            case BACK: {
                if (wordSelection) {
                    this.previousWord();
                    break;
                }
                if (lineSelection) {
                    this.lineStart();
                    break;
                }
                if (paragraphSelection) {
                    this.paragraphStart();
                    break;
                }
                this.moveCaretPosition(-1);
                break;
            }
            case UP: 
            case DOWN: {
                if (wordSelection) {
                    if (direction == Direction.UP) {
                        this.paragraphStart();
                        break;
                    }
                    this.paragraphEnd();
                    break;
                }
                if (lineSelection) {
                    this.setCaretPosition(direction == Direction.UP ? 0 : this.getTextLength());
                    break;
                }
                int rowCharIndex = this.getNextRowPosition.apply(-1.0, Direction.DOWN == direction);
                if (rowCharIndex < 0) break;
                this.setCaretPosition(rowCharIndex);
            }
        }
        if (changeSelection) {
            int pos = prevSelection.isDefined() ? (prevCaretPosition == prevSelection.getStart() ? prevSelection.getEnd() : prevSelection.getStart()) : prevCaretPosition;
            this.setSelection(new Selection(pos, this.getCaretPosition()));
        } else {
            this.clearSelection();
        }
    }

    public void resetCharacterIterator() {
        this.getTextBuffer().resetCharacterIterator();
        this.updateParagraphList();
        LOGGER.log(Level.FINE, this.getTextBuffer().toString());
    }

    public void walkFragments(BiConsumer<String, Decoration> onFragment, int start, int end) {
        this.getTextBuffer().walkFragments(onFragment, start, end);
    }

    private void updateParagraphList() {
        List<Integer> lineFeeds = this.getTextBuffer().getLineFeeds();
        AtomicInteger pos = new AtomicInteger();
        ArrayList<Paragraph> newParagraphList = new ArrayList<Paragraph>();
        lineFeeds.forEach(lfPos -> {
            boolean bl = newParagraphList.add(this.getParagraphAt(pos.getAndSet((int)lfPos), pos.incrementAndGet()));
        });
        if (pos.get() <= this.getTextLength()) {
            this.lastParagraph = this.getParagraphAt(pos.get(), this.getTextLength());
            newParagraphList.add(this.lastParagraph);
        }
        this.paragraphList.setAll(newParagraphList);
    }

    private Paragraph getParagraphAt(int start, int end) {
        ParagraphDecoration pd = this.getTextBuffer().getParagraphDecorationAtCaret(start);
        return new Paragraph(start, end, pd != null ? pd : ParagraphDecoration.builder().presets().build());
    }

    public Optional<Paragraph> getParagraphWithCaret() {
        int position = this.getCaretPosition();
        return this.paragraphList.stream().filter(p -> p.getStart() <= position && position < (p.equals(this.lastParagraph) ? p.getEnd() + 1 : p.getEnd())).findFirst();
    }

    private List<Paragraph> getParagraphsWithSelection() {
        Selection selection = this.getSelection();
        if (!selection.isDefined()) {
            return List.of();
        }
        return this.paragraphList.stream().filter(p -> p.getStart() <= selection.getEnd() && p.getEnd() > selection.getStart()).collect(Collectors.toList());
    }

    void undo() {
        this.getTextBuffer().undo();
    }

    void undoDecoration() {
        Selection selection = this.getSelection();
        this.clearSelection();
        int caretPosition = this.getCaretPosition();
        this.setCaretPosition(-1);
        this.undo();
        this.setCaretPosition(caretPosition);
        this.setSelection(selection);
    }

    public void selectCurrentWord() {
        if (this.getTextLength() <= 0) {
            return;
        }
        this.moveCaret(Direction.BACK, false, true, false, false);
        int prevCaretPosition = this.getCaretPosition();
        this.nextWord(c -> !Character.isLetterOrDigit(c.charValue()));
        this.setSelection(new Selection(prevCaretPosition, this.getCaretPosition()));
    }

    public void selectCurrentParagraph() {
        if (this.getTextLength() <= 0) {
            return;
        }
        this.moveCaret(Direction.BACK, false, false, false, true);
        this.moveCaret(Direction.FORWARD, true, false, false, true);
    }

    private void previousWord() {
        int textLength = this.getTextLength();
        if (textLength <= 0) {
            return;
        }
        if (this.wordIterator == null) {
            this.wordIterator = BreakIterator.getWordInstance();
        }
        this.wordIterator.setText(this.getTextBuffer().getCharacterIterator());
        int prevCaretPosition = this.getCaretPosition();
        int position = this.wordIterator.preceding(Tools.clamp(0, prevCaretPosition, textLength));
        while (position != -1 && !Character.isLetterOrDigit(this.getTextBuffer().charAt(Tools.clamp(0, position, textLength - 1)))) {
            position = this.wordIterator.preceding(Tools.clamp(0, position, textLength));
        }
        this.setCaretPosition(Tools.clamp(0, position, textLength));
    }

    private void nextWord(Predicate<Character> filter) {
        int textLength = this.getTextLength();
        if (this.wordIterator == null) {
            this.wordIterator = BreakIterator.getWordInstance();
        }
        this.wordIterator.setText(this.getTextBuffer().getCharacterIterator());
        int prevCaretPosition = this.getCaretPosition();
        int last = this.wordIterator.following(Tools.clamp(0, prevCaretPosition, textLength - 1));
        int current = this.wordIterator.next();
        while (current != -1) {
            int i = last;
            while (i <= current) {
                char c = this.getTextBuffer().charAt(Tools.clamp(0, i, textLength - 1));
                if (filter.test(Character.valueOf(c))) {
                    this.setCaretPosition(Tools.clamp(0, i, textLength));
                    return;
                }
                ++i;
            }
            last = current;
            current = this.wordIterator.next();
        }
        this.setCaretPosition(textLength);
    }

    private void lineStart() {
        int pos = this.getNextRowPosition.apply(0.0, null);
        this.setCaretPosition(pos);
    }

    private void lineEnd() {
        int pos = this.getNextRowPosition.apply((Double)Double.MAX_VALUE, (Boolean)null);
        this.setCaretPosition(Math.max(pos == this.getTextLength() ? pos : pos - 1, 0));
    }

    private void paragraphStart() {
        int pos = this.getCaretPosition();
        if (pos > 0) {
            while (pos > 0 && this.getTextBuffer().charAt(pos - 1) != '\n') {
                --pos;
            }
            this.setCaretPosition(pos);
        }
    }

    private void paragraphEnd() {
        int len;
        int pos = this.getCaretPosition();
        if (pos < (len = this.getTextLength())) {
            while (pos < len && this.getTextBuffer().charAt(pos) != '\n') {
                ++pos;
            }
            this.setCaretPosition(pos);
        }
    }

    private void updateProperties() {
        this.undoStackSizeProperty.set(this.commandManager.getUndoStackSize());
        this.redoStackSizeProperty.set(this.commandManager.getRedoStackSize());
    }

    private Document getCurrentDocument() {
        return new Document(this.getTextBuffer().getText(), this.getTextBuffer().getDecorationModelList(), this.getCaretPosition());
    }

    void newDocument() {
        Platform.runLater(() -> {
            this.setDocument(null);
            this.setDocument(new Document());
        });
    }

    void open(Document document) {
        Platform.runLater(() -> {
            this.setDocument(null);
            this.setDocument(document);
        });
    }

    void save() {
        Document currentDocument = this.getCurrentDocument();
        this.undoStackSizeWhenSaved = this.getUndoStackSize();
        this.savedProperty.set(true);
        this.setDocument(currentDocument);
    }

    public static enum Direction {
        FORWARD,
        BACK,
        UP,
        DOWN;

    }
}

