/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractStreamingHasher;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.errorprone.annotations.Immutable;
import java.nio.ByteBuffer;

@Immutable
@ElementTypesAreNonnullByDefault
final class Crc32cHashFunction
extends AbstractHashFunction {
    static final HashFunction CRC_32_C = new Crc32cHashFunction();

    Crc32cHashFunction() {
    }

    @Override
    public int bits() {
        return 32;
    }

    @Override
    public Hasher newHasher() {
        return new Crc32cHasher();
    }

    public String toString() {
        return "Hashing.crc32c()";
    }

    static final class Crc32cHasher
    extends AbstractStreamingHasher {
        private boolean finished = false;
        private int crc0 = -287056435;
        private int crc1 = 0;
        private int crc2 = 0;
        private int crc3 = 0;
        static final int[] BYTE_TABLE;
        static final int[][] STRIDE_TABLE;
        static final int INVERSE_COMPUTE_FOR_WORD_OF_ALL_1S = -287056435;
        private static final ByteBuffer EMPTY;

        static {
            int[] nArray = new int[256];
            nArray[1] = -227835133;
            nArray[2] = -516198153;
            nArray[3] = 324072436;
            nArray[4] = -946170081;
            nArray[5] = 904991772;
            nArray[6] = 648144872;
            nArray[7] = -724933397;
            nArray[8] = -1965467441;
            nArray[9] = 2024987596;
            nArray[10] = 1809983544;
            nArray[11] = -1719030981;
            nArray[12] = 1296289744;
            nArray[13] = -1087877933;
            nArray[14] = -1401372889;
            nArray[15] = 1578318884;
            nArray[16] = 274646895;
            nArray[17] = -499825556;
            nArray[18] = -244992104;
            nArray[19] = 51262619;
            nArray[20] = -675000208;
            nArray[21] = 632279923;
            nArray[22] = 922689671;
            nArray[23] = -996891772;
            nArray[24] = -1702387808;
            nArray[25] = 1760304291;
            nArray[26] = 2075979607;
            nArray[27] = -1982370732;
            nArray[28] = 1562183871;
            nArray[29] = -1351185476;
            nArray[30] = -1138329528;
            nArray[31] = 1313733451;
            nArray[32] = 549293790;
            nArray[33] = -757723683;
            nArray[34] = -1048117719;
            nArray[35] = 871202090;
            nArray[36] = -416867903;
            nArray[37] = 357341890;
            nArray[38] = 102525238;
            nArray[39] = -193467851;
            nArray[40] = -1436232175;
            nArray[41] = 1477399826;
            nArray[42] = 1264559846;
            nArray[43] = -1187764763;
            nArray[44] = 1845379342;
            nArray[45] = -1617575411;
            nArray[46] = -1933233671;
            nArray[47] = 2125378298;
            nArray[48] = 820201905;
            nArray[49] = -1031222606;
            nArray[50] = -774358714;
            nArray[51] = 598981189;
            nArray[52] = -143008082;
            nArray[53] = 85089709;
            nArray[54] = 373468761;
            nArray[55] = -467063462;
            nArray[56] = -1170599554;
            nArray[57] = 1213305469;
            nArray[58] = 1526817161;
            nArray[59] = -1452612982;
            nArray[60] = 2107672161;
            nArray[61] = -1882520222;
            nArray[62] = -1667500394;
            nArray[63] = 1861252501;
            nArray[64] = 1098587580;
            nArray[65] = -1290756417;
            nArray[66] = -1606390453;
            nArray[67] = 1378610760;
            nArray[68] = -2032039261;
            nArray[69] = 1955203488;
            nArray[70] = 1742404180;
            nArray[71] = -1783531177;
            nArray[72] = -878557837;
            nArray[73] = 969524848;
            nArray[74] = 714683780;
            nArray[75] = -655182201;
            nArray[76] = 205050476;
            nArray[77] = -28094097;
            nArray[78] = -318528869;
            nArray[79] = 526918040;
            nArray[80] = 1361435347;
            nArray[81] = -1555146288;
            nArray[82] = -1340167644;
            nArray[83] = 1114974503;
            nArray[84] = -1765847604;
            nArray[85] = 1691668175;
            nArray[86] = 2005155131;
            nArray[87] = -2047885768;
            nArray[88] = -604208612;
            nArray[89] = 697762079;
            nArray[90] = 986182379;
            nArray[91] = -928222744;
            nArray[92] = 476452099;
            nArray[93] = -301099520;
            nArray[94] = -44210700;
            nArray[95] = 255256311;
            nArray[96] = 1640403810;
            nArray[97] = -1817374623;
            nArray[98] = -2130844779;
            nArray[99] = 1922457750;
            nArray[100] = -1503918979;
            nArray[101] = 1412925310;
            nArray[102] = 1197962378;
            nArray[103] = -1257441399;
            nArray[104] = -350237779;
            nArray[105] = 427051182;
            nArray[106] = 170179418;
            nArray[107] = -129025959;
            nArray[108] = 746937522;
            nArray[109] = -554770511;
            nArray[110] = -843174843;
            nArray[111] = 1070968646;
            nArray[112] = 1905808397;
            nArray[113] = -2081171698;
            nArray[114] = -1868356358;
            nArray[115] = 1657317369;
            nArray[116] = -1241332974;
            nArray[117] = 1147748369;
            nArray[118] = 1463399397;
            nArray[119] = -1521340186;
            nArray[120] = -79622974;
            nArray[121] = 153784257;
            nArray[122] = 444234805;
            nArray[123] = -401473738;
            nArray[124] = 1021025245;
            nArray[125] = -827320098;
            nArray[126] = -572462294;
            nArray[127] = 797665321;
            nArray[128] = -2097792136;
            nArray[129] = 1889384571;
            nArray[130] = 1674398607;
            nArray[131] = -1851340660;
            nArray[132] = 1164749927;
            nArray[133] = -1224265884;
            nArray[134] = -1537745776;
            nArray[135] = 1446797203;
            nArray[136] = 137323447;
            nArray[137] = -96149324;
            nArray[138] = -384560320;
            nArray[139] = 461344835;
            nArray[140] = -810158936;
            nArray[141] = 1037989803;
            nArray[142] = 781091935;
            nArray[143] = -588970148;
            nArray[144] = -1834419177;
            nArray[145] = 1623424788;
            nArray[146] = 1939049696;
            nArray[147] = -2114449437;
            nArray[148] = 1429367560;
            nArray[149] = -1487280117;
            nArray[150] = -1274471425;
            nArray[151] = 1180866812;
            nArray[152] = 410100952;
            nArray[153] = -367384613;
            nArray[154] = -112536529;
            nArray[155] = 186734380;
            nArray[156] = -538233913;
            nArray[157] = 763408580;
            nArray[158] = 1053836080;
            nArray[159] = -860110797;
            nArray[160] = -1572096602;
            nArray[161] = 1344288421;
            nArray[162] = 1131464017;
            nArray[163] = -1323612590;
            nArray[164] = 1708204729;
            nArray[165] = -1749376582;
            nArray[166] = -2065018290;
            nArray[167] = 1988219213;
            nArray[168] = 680717673;
            nArray[169] = -621187478;
            nArray[170] = -911630946;
            nArray[171] = 1002577565;
            nArray[172] = -284657034;
            nArray[173] = 493091189;
            nArray[174] = 238226049;
            nArray[175] = -61306494;
            nArray[176] = -1307217207;
            nArray[177] = 1082061258;
            nArray[178] = 1395524158;
            nArray[179] = -1589280451;
            nArray[180] = 1972364758;
            nArray[181] = -2015074603;
            nArray[182] = -1800104671;
            nArray[183] = 1725896226;
            nArray[184] = 952904198;
            nArray[185] = -894981883;
            nArray[186] = -638100751;
            nArray[187] = 731699698;
            nArray[188] = -11092711;
            nArray[189] = 222117402;
            nArray[190] = 510512622;
            nArray[191] = -335130899;
            nArray[192] = -1014159676;
            nArray[193] = 837199303;
            nArray[194] = 582374963;
            nArray[195] = -790768336;
            nArray[196] = 68661723;
            nArray[197] = -159632680;
            nArray[198] = -450051796;
            nArray[199] = 390545967;
            nArray[200] = 1230274059;
            nArray[201] = -1153434360;
            nArray[202] = -1469116676;
            nArray[203] = 1510247935;
            nArray[204] = -1899042540;
            nArray[205] = 2091215383;
            nArray[206] = 1878366691;
            nArray[207] = -1650582816;
            nArray[208] = -741088853;
            nArray[209] = 565732008;
            nArray[210] = 854102364;
            nArray[211] = -1065151905;
            nArray[212] = 340358836;
            nArray[213] = -433916489;
            nArray[214] = -177076669;
            nArray[215] = 119113024;
            nArray[216] = 1493875044;
            nArray[217] = -1419691417;
            nArray[218] = -1204696685;
            nArray[219] = 1247431312;
            nArray[220] = -1634718085;
            nArray[221] = 1828433272;
            nArray[222] = 2141937292;
            nArray[223] = -1916740209;
            nArray[224] = -483350502;
            nArray[225] = 291187481;
            nArray[226] = 34330861;
            nArray[227] = -262120466;
            nArray[228] = 615137029;
            nArray[229] = -691946490;
            nArray[230] = -980332558;
            nArray[231] = 939183345;
            nArray[232] = 1776939221;
            nArray[233] = -1685949482;
            nArray[234] = -1999470558;
            nArray[235] = 2058945313;
            nArray[236] = -1368168502;
            nArray[237] = 1545135305;
            nArray[238] = 1330124605;
            nArray[239] = -1121741762;
            nArray[240] = -210866315;
            nArray[241] = 17165430;
            nArray[242] = 307568514;
            nArray[243] = -532767615;
            nArray[244] = 888469610;
            nArray[245] = -962626711;
            nArray[246] = -707819363;
            nArray[247] = 665062302;
            nArray[248] = 2042050490;
            nArray[249] = -1948470087;
            nArray[250] = -1735637171;
            nArray[251] = 1793573966;
            nArray[252] = -1104306011;
            nArray[253] = 1279665062;
            nArray[254] = 1595330642;
            nArray[255] = -1384295599;
            BYTE_TABLE = nArray;
            int[][] nArrayArray = new int[4][];
            int[] nArray2 = new int[256];
            nArray2[1] = 819083365;
            nArray2[2] = 1638166730;
            nArray2[3] = 1366706351;
            nArray2[4] = -1018633836;
            nArray2[5] = -207955471;
            nArray2[6] = -1561554594;
            nArray2[7] = -1841387205;
            nArray2[8] = -2088913447;
            nArray2[9] = -1280340548;
            nArray2[10] = -489044717;
            nArray2[11] = -770966154;
            nArray2[12] = 1077236813;
            nArray2[13] = 1894214696;
            nArray2[14] = 563160199;
            nArray2[15] = 289610978;
            nArray2[16] = 51846467;
            nArray2[17] = 868558118;
            nArray2[18] = 1655926153;
            nArray2[19] = 1382110700;
            nArray2[20] = -1067451177;
            nArray2[21] = -259144526;
            nArray2[22] = -1577350115;
            nArray2[23] = -1859537800;
            nArray2[24] = -2140493670;
            nArray2[25] = -1330081537;
            nArray2[26] = -506537904;
            nArray2[27] = -786636747;
            nArray2[28] = 1126320398;
            nArray2[29] = 1945137515;
            nArray2[30] = 579221956;
            nArray2[31] = 307495329;
            nArray2[32] = 103692934;
            nArray2[33] = 922485475;
            nArray2[34] = 1737116236;
            nArray2[35] = 1465414185;
            nArray2[36] = -983114990;
            nArray2[37] = -172694665;
            nArray2[38] = -1530745896;
            nArray2[39] = -1810852931;
            nArray2[40] = -2058121377;
            nArray2[41] = -1249790150;
            nArray2[42] = -453509227;
            nArray2[43] = -735721488;
            nArray2[44] = 1176202955;
            nArray2[45] = 1992906414;
            nArray2[46] = 666836481;
            nArray2[47] = 393029220;
            nArray2[48] = 87631813;
            nArray2[49] = 904601504;
            nArray2[50] = 1688033039;
            nArray2[51] = 1414492010;
            nArray2[52] = -965622191;
            nArray2[53] = -157024716;
            nArray2[54] = -1479166309;
            nArray2[55] = -1761112322;
            nArray2[56] = -2042326500;
            nArray2[57] = -1231639943;
            nArray2[58] = -404692266;
            nArray2[59] = -684533069;
            nArray2[60] = 1158443912;
            nArray2[61] = 1977502701;
            nArray2[62] = 614990658;
            nArray2[63] = 343554855;
            nArray2[64] = 207385868;
            nArray2[65] = 1015958889;
            nArray2[66] = 1844970950;
            nArray2[67] = 1563049379;
            nArray2[68] = -820734824;
            nArray2[69] = -3756803;
            nArray2[70] = -1364138926;
            nArray2[71] = -1637688265;
            nArray2[72] = -1893613355;
            nArray2[73] = -1074530128;
            nArray2[74] = -293228513;
            nArray2[75] = -564688774;
            nArray2[76] = 1281958209;
            nArray2[77] = 2092636452;
            nArray2[78] = 768430475;
            nArray2[79] = 488597998;
            nArray2[80] = 256600143;
            nArray2[81] = 1067012138;
            nArray2[82] = 1861163141;
            nArray2[83] = 1581064416;
            nArray2[84] = -872183333;
            nArray2[85] = -53366338;
            nArray2[86] = -1381500655;
            nArray2[87] = -1653227148;
            nArray2[88] = -1942561386;
            nArray2[89] = -1125849613;
            nArray2[90] = -309154468;
            nArray2[91] = -582970055;
            nArray2[92] = 1333672962;
            nArray2[93] = 2141979751;
            nArray2[94] = 786058440;
            nArray2[95] = 503870637;
            nArray2[96] = 175263626;
            nArray2[97] = 983594991;
            nArray2[98] = 1809203008;
            nArray2[99] = 1526990629;
            nArray2[100] = -918901218;
            nArray2[101] = -102197637;
            nArray2[102] = -1465983276;
            nArray2[103] = -1739790671;
            nArray2[104] = -1995441581;
            nArray2[105] = -1176649162;
            nArray2[106] = -391411047;
            nArray2[107] = -663112964;
            nArray2[108] = 1246174151;
            nArray2[109] = 2056594338;
            nArray2[110] = 736324365;
            nArray2[111] = 456217448;
            nArray2[112] = 157635273;
            nArray2[113] = 968321708;
            nArray2[114] = 1757487619;
            nArray2[115] = 1477646950;
            nArray2[116] = -902974627;
            nArray2[117] = -83915976;
            nArray2[118] = -1417034857;
            nArray2[119] = -1688470542;
            nArray2[120] = -1978079472;
            nArray2[121] = -1161109643;
            nArray2[122] = -339961894;
            nArray2[123] = -613503041;
            nArray2[124] = 1229981316;
            nArray2[125] = 2038578913;
            nArray2[126] = 687109710;
            nArray2[127] = 405163563;
            nArray2[128] = 414771736;
            nArray2[129] = 678089341;
            nArray2[130] = 2031917778;
            nArray2[131] = 1238278839;
            nArray2[132] = -605025396;
            nArray2[133] = -350080023;
            nArray2[134] = -1168868538;
            nArray2[135] = -1970912477;
            nArray2[136] = -1681563711;
            nArray2[137] = -1424529500;
            nArray2[138] = -94294261;
            nArray2[139] = -894232722;
            nArray2[140] = 1485684309;
            nArray2[141] = 1751090736;
            nArray2[142] = 959041183;
            nArray2[143] = 167507706;
            nArray2[144] = 464516955;
            nArray2[145] = 729665342;
            nArray2[146] = 2047575953;
            nArray2[147] = 1255784436;
            nArray2[148] = -655943985;
            nArray2[149] = -399167830;
            nArray2[150] = -1186765307;
            nArray2[151] = -1986961824;
            nArray2[152] = -1731050878;
            nArray2[153] = -1476363545;
            nArray2[154] = -109694392;
            nArray2[155] = -911996371;
            nArray2[156] = 1536860950;
            nArray2[157] = 1799920499;
            nArray2[158] = 977195996;
            nArray2[159] = 183299001;
            nArray2[160] = 513200286;
            nArray2[161] = 776268027;
            nArray2[162] = 2134024276;
            nArray2[163] = 1340119089;
            nArray2[164] = -572641014;
            nArray2[165] = -317978257;
            nArray2[166] = -1132838464;
            nArray2[167] = -1935115867;
            nArray2[168] = -1645517497;
            nArray2[169] = -1388749534;
            nArray2[170] = -61926003;
            nArray2[171] = -862114328;
            nArray2[172] = 1587774675;
            nArray2[173] = 1852947638;
            nArray2[174] = 1057485849;
            nArray2[175] = 265669756;
            nArray2[176] = 495046109;
            nArray2[177] = 760477112;
            nArray2[178] = 2082848023;
            nArray2[179] = 1291289970;
            nArray2[180] = -557241271;
            nArray2[181] = -300215252;
            nArray2[182] = -1083351933;
            nArray2[183] = -1883282202;
            nArray2[184] = -1627621372;
            nArray2[185] = -1372700575;
            nArray2[186] = -11007794;
            nArray2[187] = -813027157;
            nArray2[188] = 1572116880;
            nArray2[189] = 1835442677;
            nArray2[190] = 1007741274;
            nArray2[191] = 214094143;
            nArray2[192] = 350527252;
            nArray2[193] = 607561585;
            nArray2[194] = 1967189982;
            nArray2[195] = 1167251387;
            nArray2[196] = -676561280;
            nArray2[197] = -411154715;
            nArray2[198] = -1240986038;
            nArray2[199] = -2032519633;
            nArray2[200] = -1751569715;
            nArray2[201] = -1488252248;
            nArray2[202] = -163751417;
            nArray2[203] = -957390238;
            nArray2[204] = 1423035225;
            nArray2[205] = 1677980476;
            nArray2[206] = 896908179;
            nArray2[207] = 94864374;
            nArray2[208] = 401834583;
            nArray2[209] = 656521778;
            nArray2[210] = 1985475229;
            nArray2[211] = 1183173368;
            nArray2[212] = -725916733;
            nArray2[213] = -462857306;
            nArray2[214] = -1256254711;
            nArray2[215] = -2050151572;
            nArray2[216] = -1802618994;
            nArray2[217] = -1537470485;
            nArray2[218] = -181778620;
            nArray2[219] = -973570271;
            nArray2[220] = 1472648730;
            nArray2[221] = 1729425023;
            nArray2[222] = 912434896;
            nArray2[223] = 112238261;
            nArray2[224] = 315270546;
            nArray2[225] = 572038647;
            nArray2[226] = 1936643416;
            nArray2[227] = 1136454973;
            nArray2[228] = -779992058;
            nArray2[229] = -514818973;
            nArray2[230] = -1339673396;
            nArray2[231] = -2131489623;
            nArray2[232] = -1850273717;
            nArray2[233] = -1587206098;
            nArray2[234] = -267165567;
            nArray2[235] = -1061070620;
            nArray2[236] = 1392505311;
            nArray2[237] = 1647167930;
            nArray2[238] = 861634837;
            nArray2[239] = 59357552;
            nArray2[240] = 299743441;
            nArray2[241] = 554664116;
            nArray2[242] = 1887029275;
            nArray2[243] = 1085010046;
            nArray2[244] = -761964219;
            nArray2[245] = -498638560;
            nArray2[246] = -1288623729;
            nArray2[247] = -2082270742;
            nArray2[248] = -1835004664;
            nArray2[249] = -1569573523;
            nArray2[250] = -217809470;
            nArray2[251] = -1009367641;
            nArray2[252] = 1374219420;
            nArray2[253] = 1631245561;
            nArray2[254] = 810327126;
            nArray2[255] = 10396723;
            nArrayArray[0] = nArray2;
            int[] nArray3 = new int[256];
            nArray3[1] = 1409766726;
            nArray3[2] = -1475433844;
            nArray3[3] = -66453558;
            nArray3[4] = 1441866729;
            nArray3[5] = 32929455;
            nArray3[6] = -33584795;
            nArray3[7] = -1443308509;
            nArray3[8] = -1411233838;
            nArray3[9] = -1764716;
            nArray3[10] = 65858910;
            nArray3[11] = 1475065880;
            nArray3[12] = -32283589;
            nArray3[13] = -1441517187;
            nArray3[14] = 1444794039;
            nArray3[15] = 35298289;
            nArray3[16] = 1378416981;
            nArray3[17] = 103787539;
            nArray3[18] = -98151463;
            nArray3[19] = -1373567329;
            nArray3[20] = 131717820;
            nArray3[21] = 1407094778;
            nArray3[22] = -1344835536;
            nArray3[23] = -70245002;
            nArray3[24] = -104153465;
            nArray3[25] = -1379013695;
            nArray3[26] = 1371804683;
            nArray3[27] = 96682317;
            nArray3[28] = -1405379218;
            nArray3[29] = -130234328;
            nArray3[30] = 70596578;
            nArray3[31] = 1345479332;
            nArray3[32] = -1538133334;
            nArray3[33] = -262756372;
            nArray3[34] = 207575078;
            nArray3[35] = 1482165600;
            nArray3[36] = -241118909;
            nArray3[37] = -1515748347;
            nArray3[38] = 1504607183;
            nArray3[39] = 229191305;
            nArray3[40] = 263435640;
            nArray3[41] = 1538580542;
            nArray3[42] = -1480777740;
            nArray3[43] = -205894990;
            nArray3[44] = 1514313361;
            nArray3[45] = 239453143;
            nArray3[46] = -229884899;
            nArray3[47] = -1505007269;
            nArray3[48] = -159839233;
            nArray3[49] = -1568776519;
            nArray3[50] = 1584898419;
            nArray3[51] = 175174709;
            nArray3[52] = -1551357930;
            nArray3[53] = -141591216;
            nArray3[54] = 193364634;
            nArray3[55] = 1602344924;
            nArray3[56] = 1570458669;
            nArray3[57] = 161225067;
            nArray3[58] = -174725471;
            nArray3[59] = -1584221209;
            nArray3[60] = 141193156;
            nArray3[61] = 1550662274;
            nArray3[62] = -1604008632;
            nArray3[63] = -194801650;
            nArray3[64] = 1297060773;
            nArray3[65] = 424199907;
            nArray3[66] = -448710359;
            nArray3[67] = -1320784785;
            nArray3[68] = 415150156;
            nArray3[69] = 1287251210;
            nArray3[70] = -1330636096;
            nArray3[71] = -457748602;
            nArray3[72] = -424815497;
            nArray3[73] = -1297448655;
            nArray3[74] = 1319337723;
            nArray3[75] = 446966717;
            nArray3[76] = -1285752930;
            nArray3[77] = -413424936;
            nArray3[78] = 458382610;
            nArray3[79] = 1330972756;
            nArray3[80] = 526871280;
            nArray3[81] = 1264598966;
            nArray3[82] = -1217806212;
            nArray3[83] = -479292102;
            nArray3[84] = 1251363097;
            nArray3[85] = 512826463;
            nArray3[86] = -493296747;
            nArray3[87] = -1231046957;
            nArray3[88] = -1266340574;
            nArray3[89] = -528320412;
            nArray3[90] = 478906286;
            nArray3[91] = 1217188584;
            nArray3[92] = -512487733;
            nArray3[93] = -1250731123;
            nArray3[94] = 1232774215;
            nArray3[95] = 494792961;
            nArray3[96] = -383885041;
            nArray3[97] = -1122421687;
            nArray3[98] = 1091619715;
            nArray3[99] = 353869509;
            nArray3[100] = -1125170458;
            nArray3[101] = -387442784;
            nArray3[102] = 350349418;
            nArray3[103] = 1088863532;
            nArray3[104] = 1123821277;
            nArray3[105] = 385577883;
            nArray3[106] = -353203119;
            nArray3[107] = -1091184361;
            nArray3[108] = 386729268;
            nArray3[109] = 1124749426;
            nArray3[110] = -1090277448;
            nArray3[111] = -351995138;
            nArray3[112] = -1154049958;
            nArray3[113] = -281948900;
            nArray3[114] = 322450134;
            nArray3[115] = 1195337616;
            nArray3[116] = -288900173;
            nArray3[117] = -1161761035;
            nArray3[118] = 1187582271;
            nArray3[119] = 315507833;
            nArray3[120] = 282386312;
            nArray3[121] = 1154714318;
            nArray3[122] = -1193642748;
            nArray3[123] = -321052606;
            nArray3[124] = 1160117345;
            nArray3[125] = 287484199;
            nArray3[126] = -315926803;
            nArray3[127] = -1188297813;
            nArray3[128] = -1700845750;
            nArray3[129] = -828870132;
            nArray3[130] = 848399814;
            nArray3[131] = 1721161856;
            nArray3[132] = -814873437;
            nArray3[133] = -1687596571;
            nArray3[134] = 1734389295;
            nArray3[135] = 862452585;
            nArray3[136] = 830300312;
            nArray3[137] = 1702507998;
            nArray3[138] = -1720464876;
            nArray3[139] = -847995054;
            nArray3[140] = 1686913905;
            nArray3[141] = 814421559;
            nArray3[142] = -863835651;
            nArray3[143] = -1736065861;
            nArray3[144] = -927474145;
            nArray3[145] = -1666151591;
            nArray3[146] = 1622766739;
            nArray3[147] = 884875733;
            nArray3[148] = -1656291850;
            nArray3[149] = -918443856;
            nArray3[150] = 893933434;
            nArray3[151] = 1632567868;
            nArray3[152] = 1666554317;
            nArray3[153] = 928173195;
            nArray3[154] = -883215551;
            nArray3[155] = -1621334521;
            nArray3[156] = 916765220;
            nArray3[157] = 1654910818;
            nArray3[158] = -1633021784;
            nArray3[159] = -894614034;
            nArray3[160] = 1053742560;
            nArray3[161] = 1791590566;
            nArray3[162] = -1765769364;
            nArray3[163] = -1027134934;
            nArray3[164] = 1799353865;
            nArray3[165] = 1060676431;
            nArray3[166] = -1020175227;
            nArray3[167] = -1758066237;
            nArray3[168] = -1792241102;
            nArray3[169] = -1054095500;
            nArray3[170] = 1025652926;
            nArray3[171] = 1764060664;
            nArray3[172] = -1059212837;
            nArray3[173] = -1797593955;
            nArray3[174] = 1758665559;
            nArray3[175] = 1020546577;
            nArray3[176] = 1827024053;
            nArray3[177] = 954300915;
            nArray3[178] = -991394247;
            nArray3[179] = -1863330945;
            nArray3[180] = 957812572;
            nArray3[181] = 1829788186;
            nArray3[182] = -1860590128;
            nArray3[183] = -987828074;
            nArray3[184] = -956011673;
            nArray3[185] = -1828504031;
            nArray3[186] = 1862975979;
            nArray3[187] = 990745773;
            nArray3[188] = -1829418866;
            nArray3[189] = -957211192;
            nArray3[190] = 989585922;
            nArray3[191] = 1862055748;
            nArray3[192] = -674188049;
            nArray3[193] = -2083003991;
            nArray3[194] = 2145263203;
            nArray3[195] = 735660837;
            nArray3[196] = -2111727866;
            nArray3[197] = -702102976;
            nArray3[198] = 707739018;
            nArray3[199] = 2116577484;
            nArray3[200] = 2083713853;
            nArray3[201] = 674604667;
            nArray3[202] = -734242383;
            nArray3[203] = -2143613705;
            nArray3[204] = 700698836;
            nArray3[205] = 2110031250;
            nArray3[206] = -2117240232;
            nArray3[207] = -708169954;
            nArray3[208] = -2047324742;
            nArray3[209] = -771811076;
            nArray3[210] = 771155766;
            nArray3[211] = 2045882992;
            nArray3[212] = -804688301;
            nArray3[213] = -2079442155;
            nArray3[214] = 2013775071;
            nArray3[215] = 738234777;
            nArray3[216] = 773458536;
            nArray3[217] = 2048745262;
            nArray3[218] = -2045468444;
            nArray3[219] = -770443870;
            nArray3[220] = 2079009153;
            nArray3[221] = 804027591;
            nArray3[222] = -739933427;
            nArray3[223] = -2015177141;
            nArray3[224] = 1937851973;
            nArray3[225] = 663098115;
            nArray3[226] = -611324727;
            nArray3[227] = -1886865009;
            nArray3[228] = 644900268;
            nArray3[229] = 1920413930;
            nArray3[230] = -1904292064;
            nArray3[231] = -629564826;
            nArray3[232] = -664600169;
            nArray3[233] = -1939581743;
            nArray3[234] = 1886235419;
            nArray3[235] = 610991709;
            nArray3[236] = -1919802754;
            nArray3[237] = -644516040;
            nArray3[238] = 631015666;
            nArray3[239] = 1906040244;
            nArray3[240] = 564772624;
            nArray3[241] = 1974397526;
            nArray3[242] = -1985538660;
            nArray3[243] = -576700198;
            nArray3[244] = 1951964409;
            nArray3[245] = 543148479;
            nArray3[246] = -598329739;
            nArray3[247] = -2007932109;
            nArray3[248] = -1974732606;
            nArray3[249] = -565400188;
            nArray3[250] = 574968398;
            nArray3[251] = 1984038664;
            nArray3[252] = -541402325;
            nArray3[253] = -1950511507;
            nArray3[254] = 2008314279;
            nArray3[255] = 598942945;
            nArrayArray[1] = nArray3;
            int[] nArray4 = new int[256];
            nArray4[1] = 1737424129;
            nArray4[2] = -820119038;
            nArray4[3] = -1466759421;
            nArray4[4] = -1680375051;
            nArray4[5] = -61243404;
            nArray4[6] = 1422555383;
            nArray4[7] = 860128758;
            nArray4[8] = 843281179;
            nArray4[9] = 1439534618;
            nArray4[10] = -44136167;
            nArray4[11] = -1697614824;
            nArray4[12] = -1449856530;
            nArray4[13] = -837153553;
            nArray4[14] = 1720257516;
            nArray4[15] = 17299181;
            nArray4[16] = 1686562358;
            nArray4[17] = 50862903;
            nArray4[18] = -1415898060;
            nArray4[19] = -870981323;
            nArray4[20] = -11443005;
            nArray4[21] = -1730176574;
            nArray4[22] = 810327745;
            nArray4[23] = 1472357312;
            nArray4[24] = 1455789357;
            nArray4[25] = 827025452;
            nArray4[26] = -1713869009;
            nArray4[27] = -27880914;
            nArray4[28] = -854452264;
            nArray4[29] = -1432556839;
            nArray4[30] = 34598362;
            nArray4[31] = 1702957275;
            nArray4[32] = -921842580;
            nArray4[33] = -1367133843;
            nArray4[34] = 101725806;
            nArray4[35] = 1637796719;
            nArray4[36] = 1390038681;
            nArray4[37] = 894743448;
            nArray4[38] = -1647856485;
            nArray4[39] = -95860326;
            nArray4[40] = -78725257;
            nArray4[41] = -1665121674;
            nArray4[42] = 877872501;
            nArray4[43] = 1407039604;
            nArray4[44] = 1620655490;
            nArray4[45] = 118997123;
            nArray4[46] = -1350252672;
            nArray4[47] = -938853759;
            nArray4[48] = -1383388582;
            nArray4[49] = -905586853;
            nArray4[50] = 1654050904;
            nArray4[51] = 85470553;
            nArray4[52] = 912042159;
            nArray4[53] = 1372738990;
            nArray4[54] = -113159507;
            nArray4[55] = -1630556244;
            nArray4[56] = -1614259903;
            nArray4[57] = -129588160;
            nArray4[58] = 1356178243;
            nArray4[59] = 928734786;
            nArray4[60] = 69196724;
            nArray4[61] = 1670457013;
            nArray4[62] = -889052746;
            nArray4[63] = -1400054601;
            nArray4[64] = -1745359319;
            nArray4[65] = -260500696;
            nArray4[66] = 1491735595;
            nArray4[67] = 1063577898;
            nArray4[68] = 203451612;
            nArray4[69] = 1806602717;
            nArray4[70] = -1019373858;
            nArray4[71] = -1531745313;
            nArray4[72] = -1514889934;
            nArray4[73] = -1036361677;
            nArray4[74] = 1789486896;
            nArray4[75] = 220699185;
            nArray4[76] = 1046683591;
            nArray4[77] = 1508762310;
            nArray4[78] = -243341883;
            nArray4[79] = -1762649916;
            nArray4[80] = -210696161;
            nArray4[81] = -1795164898;
            nArray4[82] = 1013772829;
            nArray4[83] = 1541541660;
            nArray4[84] = 1755745002;
            nArray4[85] = 254310379;
            nArray4[86] = -1480888088;
            nArray4[87] = -1070232087;
            nArray4[88] = -1053656316;
            nArray4[89] = -1497594363;
            nArray4[90] = 237994246;
            nArray4[91] = 1772190727;
            nArray4[92] = 1525021169;
            nArray4[93] = 1030423792;
            nArray4[94] = -1778908173;
            nArray4[95] = -227082510;
            nArray4[96] = 1593451077;
            nArray4[97] = 963960644;
            nArray4[98] = -1847076793;
            nArray4[99] = -160881338;
            nArray4[100] = -986865488;
            nArray4[101] = -1566351951;
            nArray4[102] = 170941106;
            nArray4[103] = 1841211315;
            nArray4[104] = 1824084318;
            nArray4[105] = 188197983;
            nArray4[106] = -1549489316;
            nArray4[107] = -1003858339;
            nArray4[108] = -143731797;
            nArray4[109] = -1864356182;
            nArray4[110] = 947071401;
            nArray4[111] = 1610470568;
            nArray4[112] = 981255283;
            nArray4[113] = 1576155506;
            nArray4[114] = -178176399;
            nArray4[115] = -1829780624;
            nArray4[116] = -1582610810;
            nArray4[117] = -970605689;
            nArray4[118] = 1857469572;
            nArray4[119] = 154681733;
            nArray4[120] = 138393448;
            nArray4[121] = 1873889897;
            nArray4[122] = -954053270;
            nArray4[123] = -1599295381;
            nArray4[124] = -1813498467;
            nArray4[125] = -194590564;
            nArray4[126] = 1559613343;
            nArray4[127] = 997929630;
            nArray4[128] = 704883363;
            nArray4[129] = 1301108642;
            nArray4[130] = -450998111;
            nArray4[131] = -2104447584;
            nArray4[132] = -1311496106;
            nArray4[133] = -698690217;
            nArray4[134] = 2127155796;
            nArray4[135] = 424095573;
            nArray4[136] = 406903224;
            nArray4[137] = 2144216249;
            nArray4[138] = -681761862;
            nArray4[139] = -1328292165;
            nArray4[140] = -2087232691;
            nArray4[141] = -468081076;
            nArray4[142] = 1284153679;
            nArray4[143] = 721706062;
            nArray4[144] = 1317358741;
            nArray4[145] = 688632212;
            nArray4[146] = -2120698217;
            nArray4[147] = -434746474;
            nArray4[148] = -715993504;
            nArray4[149] = -1294191775;
            nArray4[150] = 441398370;
            nArray4[151] = 2109852003;
            nArray4[152] = 2093367182;
            nArray4[153] = 457753231;
            nArray4[154] = -1277442676;
            nArray4[155] = -732612467;
            nArray4[156] = -418267781;
            nArray4[157] = -2137046918;
            nArray4[158] = 671893369;
            nArray4[159] = 1333967480;
            nArray4[160] = -485595441;
            nArray4[161] = -2071946290;
            nArray4[162] = 739482829;
            nArray4[163] = 1268605388;
            nArray4[164] = 2027545658;
            nArray4[165] = 525801787;
            nArray4[166] = -1211883976;
            nArray4[167] = -800398535;
            nArray4[168] = -783477292;
            nArray4[169] = -1228674859;
            nArray4[170] = 508620758;
            nArray4[171] = 2044596951;
            nArray4[172] = 1251645217;
            nArray4[173] = 756312608;
            nArray4[174] = -2054722269;
            nArray4[175] = -502689758;
            nArray4[176] = -2021097223;
            nArray4[177] = -536445448;
            nArray4[178] = 1217755899;
            nArray4[179] = 790333434;
            nArray4[180] = 475988492;
            nArray4[181] = 2077359885;
            nArray4[182] = -750585842;
            nArray4[183] = -1261697777;
            nArray4[184] = -1244924958;
            nArray4[185] = -767226141;
            nArray4[186] = 2060847584;
            nArray4[187] = 492369121;
            nArray4[188] = 773615895;
            nArray4[189] = 1234340886;
            nArray4[190] = -519992555;
            nArray4[191] = -2037418476;
            nArray4[192] = -1108065142;
            nArray4[193] = -629491317;
            nArray4[194] = 1927921288;
            nArray4[195] = 359089033;
            nArray4[196] = 639878783;
            nArray4[197] = 1101871998;
            nArray4[198] = -381797251;
            nArray4[199] = -1901018756;
            nArray4[200] = -1883818095;
            nArray4[201] = -398865776;
            nArray4[202] = 1084935571;
            nArray4[203] = 656683154;
            nArray4[204] = 341882212;
            nArray4[205] = 1944995941;
            nArray4[206] = -612544666;
            nArray4[207] = -1124879769;
            nArray4[208] = -646798660;
            nArray4[209] = -1090756675;
            nArray4[210] = 376395966;
            nArray4[211] = 1910613439;
            nArray4[212] = 1118117961;
            nArray4[213] = 623631688;
            nArray4[214] = -1917265333;
            nArray4[215] = -365549750;
            nArray4[216] = -349056601;
            nArray4[217] = -1933628250;
            nArray4[218] = 606874533;
            nArray4[219] = 1134745252;
            nArray4[220] = 1894142802;
            nArray4[221] = 392736339;
            nArray4[222] = -1074026160;
            nArray4[223] = -663399343;
            nArray4[224] = 1962510566;
            nArray4[225] = 326596071;
            nArray4[226] = -1142656284;
            nArray4[227] = -596996123;
            nArray4[228] = -282195437;
            nArray4[229] = -2002716910;
            nArray4[230] = 540274705;
            nArray4[231] = 1203571984;
            nArray4[232] = 1186659325;
            nArray4[233] = 557057788;
            nArray4[234] = -1985543681;
            nArray4[235] = -299238146;
            nArray4[236] = -580028152;
            nArray4[237] = -1159494647;
            nArray4[238] = 309363466;
            nArray4[239] = 1979612683;
            nArray4[240] = 276786896;
            nArray4[241] = 2012320721;
            nArray4[242] = -547187502;
            nArray4[243] = -1192465965;
            nArray4[244] = -1951863771;
            nArray4[245] = -333049564;
            nArray4[246] = 1152718375;
            nArray4[247] = 591129382;
            nArray4[248] = 574365131;
            nArray4[249] = 1169350858;
            nArray4[250] = -316545079;
            nArray4[251] = -1968235832;
            nArray4[252] = -1175740610;
            nArray4[253] = -563781057;
            nArray4[254] = 1995859260;
            nArray4[255] = 293115965;
            nArrayArray[2] = nArray4;
            int[] nArray5 = new int[256];
            nArray5[1] = -234091010;
            nArray5[2] = -504074995;
            nArray5[3] = 335044851;
            nArray5[4] = -972772117;
            nArray5[5] = 872980757;
            nArray5[6] = 670089702;
            nArray5[7] = -704852968;
            nArray5[8] = -1981468889;
            nArray5[9] = 2078876377;
            nArray5[10] = 1745961514;
            nArray5[11] = -1709355052;
            nArray5[12] = 1340179404;
            nArray5[13] = -1108505038;
            nArray5[14] = -1374294335;
            nArray5[15] = 1545200447;
            nArray5[16] = 371599551;
            nArray5[17] = -466999999;
            nArray5[18] = -137214542;
            nArray5[19] = 98453580;
            nArray5[20] = -803044268;
            nArray5[21] = 573475242;
            nArray5[22] = 836168025;
            nArray5[23] = -1009064793;
            nArray5[24] = -1614608488;
            nArray5[25] = 1842285158;
            nArray5[26] = 2117560981;
            nArray5[27] = -1942263957;
            nArray5[28] = 1506257779;
            nArray5[29] = -1412716915;
            nArray5[30] = -1204566402;
            nArray5[31] = 1245694848;
            nArray5[32] = 743199102;
            nArray5[33] = -566207360;
            nArray5[34] = -843563917;
            nArray5[35] = 1068773773;
            nArray5[36] = -364315243;
            nArray5[37] = 407171179;
            nArray5[38] = 196907160;
            nArray5[39] = -105865882;
            nArray5[40] = -1515618727;
            nArray5[41] = 1470460839;
            nArray5[42] = 1146950484;
            nArray5[43] = -1236197718;
            nArray5[44] = 1672336050;
            nArray5[45] = -1851662516;
            nArray5[46] = -2108047425;
            nArray5[47] = 1884664385;
            nArray5[48] = 980056513;
            nArray5[49] = -932809665;
            nArray5[50] = -610396980;
            nArray5[51] = 697440562;
            nArray5[52] = -59845334;
            nArray5[53] = 241359060;
            nArray5[54] = 496678951;
            nArray5[55] = -275335719;
            nArray5[56] = -1282451738;
            nArray5[57] = 1099127576;
            nArray5[58] = 1383807979;
            nArray5[59] = -1602800107;
            nArray5[60] = 1972107789;
            nArray5[61] = -2021132301;
            nArray5[62] = -1803577600;
            nArray5[63] = 1718852350;
            nArray5[64] = 1486398204;
            nArray5[65] = -1433096446;
            nArray5[66] = -1184051215;
            nArray5[67] = 1264632335;
            nArray5[68] = -1633939945;
            nArray5[69] = 1821377513;
            nArray5[70] = 2137547546;
            nArray5[71] = -1922797852;
            nArray5[72] = -780300837;
            nArray5[73] = 594640933;
            nArray5[74] = 814342358;
            nArray5[75] = -1031410392;
            nArray5[76] = 393814320;
            nArray5[77] = -445305650;
            nArray5[78] = -158512067;
            nArray5[79] = 75579843;
            nArray5[80] = 1321110083;
            nArray5[81] = -1129150531;
            nArray5[82] = -1354045618;
            nArray5[83] = 1564928688;
            nArray5[84] = -2001066328;
            nArray5[85] = 2058758998;
            nArray5[86] = 1766738853;
            nArray5[87] = -1690155429;
            nArray5[88] = -950295196;
            nArray5[89] = 894937242;
            nArray5[90] = 649054313;
            nArray5[91] = -727464553;
            nArray5[92] = 23005583;
            nArray5[93] = -212663183;
            nArray5[94] = -525638526;
            nArray5[95] = 312961404;
            nArray5[96] = 1960113026;
            nArray5[97] = -2032599428;
            nArray5[98] = -1793024369;
            nArray5[99] = 1730974577;
            nArray5[100] = -1294966935;
            nArray5[101] = 1088180887;
            nArray5[102] = 1394881124;
            nArray5[103] = -1591197798;
            nArray5[104] = -47063899;
            nArray5[105] = 255709531;
            nArray5[106] = 482718120;
            nArray5[107] = -288768938;
            nArray5[108] = 993357902;
            nArray5[109] = -918979152;
            nArray5[110] = -624878269;
            nArray5[111] = 684527805;
            nArray5[112] = 1660083005;
            nArray5[113] = -1862347069;
            nArray5[114] = -2096712144;
            nArray5[115] = 1896528846;
            nArray5[116] = -1527351338;
            nArray5[117] = 1459255848;
            nArray5[118] = 1157765851;
            nArray5[119] = -1223813339;
            nArray5[120] = -350751718;
            nArray5[121] = 421263844;
            nArray5[122] = 182688023;
            nArray5[123] = -118516503;
            nArray5[124] = 756242673;
            nArray5[125] = -551594737;
            nArray5[126] = -857262596;
            nArray5[127] = 1055602690;
            nArray5[128] = -1322170888;
            nArray5[129] = 1128089606;
            nArray5[130] = 1355098357;
            nArray5[131] = -1563876085;
            nArray5[132] = 2000021779;
            nArray5[133] = -2059803411;
            nArray5[134] = -1765702626;
            nArray5[135] = 1691191776;
            nArray5[136] = 953445087;
            nArray5[137] = -891787487;
            nArray5[138] = -652212270;
            nArray5[139] = 724306476;
            nArray5[140] = -19872204;
            nArray5[141] = 215796682;
            nArray5[142] = 522496825;
            nArray5[143] = -316102969;
            nArray5[144] = -1491636921;
            nArray5[145] = 1427857593;
            nArray5[146] = 1189281866;
            nArray5[147] = -1259401804;
            nArray5[148] = 1628684716;
            nArray5[149] = -1826632622;
            nArray5[150] = -2132300639;
            nArray5[151] = 1928044895;
            nArray5[152] = 787628640;
            nArray5[153] = -587313250;
            nArray5[154] = -821678227;
            nArray5[155] = 1024074387;
            nArray5[156] = -386470261;
            nArray5[157] = 452649845;
            nArray5[158] = 151159686;
            nArray5[159] = -82932104;
            nArray5[160] = -1652747130;
            nArray5[161] = 1869683064;
            nArray5[162] = 2089384331;
            nArray5[163] = -1903856523;
            nArray5[164] = 1534703725;
            nArray5[165] = -1451903597;
            nArray5[166] = -1165109920;
            nArray5[167] = 1216469150;
            nArray5[168] = 345521057;
            nArray5[169] = -426494369;
            nArray5[170] = -177449300;
            nArray5[171] = 123755346;
            nArray5[172] = -761489590;
            nArray5[173] = 546347700;
            nArray5[174] = 862517831;
            nArray5[175] = -1050347591;
            nArray5[176] = -1956955079;
            nArray5[177] = 2035757511;
            nArray5[178] = 1789874484;
            nArray5[179] = -1734124342;
            nArray5[180] = 1298108626;
            nArray5[181] = -1085039316;
            nArray5[182] = -1398014497;
            nArray5[183] = 1588064289;
            nArray5[184] = 46011166;
            nArray5[185] = -256762144;
            nArray5[186] = -481657325;
            nArray5[187] = 289829869;
            nArray5[188] = -994394123;
            nArray5[189] = 917942795;
            nArray5[190] = 625922808;
            nArray5[191] = -683483386;
            nArray5[192] = -374741244;
            nArray5[193] = 463858426;
            nArray5[194] = 140347913;
            nArray5[195] = -95320073;
            nArray5[196] = 799886319;
            nArray5[197] = -576633327;
            nArray5[198] = -833018142;
            nArray5[199] = 1012214556;
            nArray5[200] = 1615644707;
            nArray5[201] = -1841248803;
            nArray5[202] = -2118605522;
            nArray5[203] = 1941219536;
            nArray5[204] = -1505205048;
            nArray5[205] = 1413769526;
            nArray5[206] = 1203505605;
            nArray5[207] = -1246755781;
            nArray5[208] = -7352389;
            nArray5[209] = 226738757;
            nArray5[210] = 511419062;
            nArray5[211] = -327700664;
            nArray5[212] = 965436240;
            nArray5[213] = -880316754;
            nArray5[214] = -662761891;
            nArray5[215] = 712180643;
            nArray5[216] = 1986715804;
            nArray5[217] = -2073629342;
            nArray5[218] = -1751216751;
            nArray5[219] = 1704099951;
            nArray5[220] = -1334948745;
            nArray5[221] = 1113735561;
            nArray5[222] = 1369055610;
            nArray5[223] = -1550439292;
            nArray5[224] = -974801286;
            nArray5[225] = 938064772;
            nArray5[226] = 605150071;
            nArray5[227] = -702687607;
            nArray5[228] = 65084049;
            nArray5[229] = -236120209;
            nArray5[230] = -501909604;
            nArray5[231] = 270105186;
            nArray5[232] = 1275107677;
            nArray5[233] = -1106471773;
            nArray5[234] = -1376455600;
            nArray5[235] = 1610152366;
            nArray5[236] = -1979435594;
            nArray5[237] = 2013804616;
            nArray5[238] = 1810913467;
            nArray5[239] = -1711516347;
            nArray5[240] = -742154555;
            nArray5[241] = 567251771;
            nArray5[242] = 842527688;
            nArray5[243] = -1069810122;
            nArray5[244] = 365376046;
            nArray5[245] = -406110256;
            nArray5[246] = -197959901;
            nArray5[247] = 104813277;
            nArray5[248] = 1512485346;
            nArray5[249] = -1473594340;
            nArray5[250] = -1143808785;
            nArray5[251] = 1239339281;
            nArray5[252] = -1675485943;
            nArray5[253] = 1848512759;
            nArray5[254] = 2111205380;
            nArray5[255] = -1881506310;
            nArrayArray[3] = nArray5;
            STRIDE_TABLE = nArrayArray;
            EMPTY = ByteBuffer.allocate(0);
        }

        Crc32cHasher() {
            super(16);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected void process(ByteBuffer bb) {
            if (!this.finished) ** GOTO lbl11
            throw new IllegalStateException("The behavior of calling any method after calling hash() is undefined.");
lbl-1000:
            // 1 sources

            {
                this.crc0 = Crc32cHasher.computeForWord(this.crc0);
                this.crc1 = Crc32cHasher.computeForWord(this.crc1);
                this.crc2 = Crc32cHasher.computeForWord(this.crc2);
                this.crc3 = Crc32cHasher.computeForWord(this.crc3);
                this.crc0 ^= bb.getInt();
                this.crc1 ^= bb.getInt();
                this.crc2 ^= bb.getInt();
                this.crc3 ^= bb.getInt();
lbl11:
                // 2 sources

                ** while (bb.remaining() >= 16)
            }
lbl12:
            // 1 sources

        }

        @Override
        protected void processRemaining(ByteBuffer bb) {
            if (this.finished) {
                return;
            }
            this.crc0 = Crc32cHasher.combine(0, this.crc0);
            this.crc0 = Crc32cHasher.combine(this.crc0, this.crc1);
            this.crc0 = Crc32cHasher.combine(this.crc0, this.crc2);
            this.crc0 = Crc32cHasher.combine(this.crc0, this.crc3);
            while (bb.hasRemaining()) {
                this.crc0 = this.crc0 >>> 8 ^ BYTE_TABLE[(bb.get() ^ this.crc0) & 0xFF];
            }
            this.finished = true;
        }

        @Override
        protected HashCode makeHash() {
            if (!this.finished) {
                this.processRemaining(EMPTY);
            }
            return HashCode.fromInt(~this.crc0);
        }

        static int computeForWord(int word) {
            return STRIDE_TABLE[3][word & 0xFF] ^ STRIDE_TABLE[2][word >>> 8 & 0xFF] ^ STRIDE_TABLE[1][word >>> 16 & 0xFF] ^ STRIDE_TABLE[0][word >>> 24];
        }

        static int combine(int csum, int crc) {
            csum ^= crc;
            int i = 0;
            while (i < 4) {
                csum = csum >>> 8 ^ BYTE_TABLE[csum & 0xFF];
                ++i;
            }
            return csum;
        }
    }
}

