/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityFile;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Util;
import java.util.Vector;

class LocalIdentityRepository
implements IdentityRepository {
    private static final String name = "Local Identity Repository";
    private Vector identities = new Vector();
    private JSch jsch;

    LocalIdentityRepository(JSch jsch) {
        this.jsch = jsch;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public int getStatus() {
        return 2;
    }

    @Override
    public synchronized Vector getIdentities() {
        this.removeDupulicates();
        Vector v = new Vector();
        int i = 0;
        while (i < this.identities.size()) {
            v.addElement(this.identities.elementAt(i));
            ++i;
        }
        return v;
    }

    public synchronized void add(Identity identity) {
        if (!this.identities.contains(identity)) {
            byte[] blob1 = identity.getPublicKeyBlob();
            if (blob1 == null) {
                this.identities.addElement(identity);
                return;
            }
            int i = 0;
            while (i < this.identities.size()) {
                byte[] blob2 = ((Identity)this.identities.elementAt(i)).getPublicKeyBlob();
                if (blob2 != null && Util.array_equals(blob1, blob2)) {
                    if (!identity.isEncrypted() && ((Identity)this.identities.elementAt(i)).isEncrypted()) {
                        this.remove(blob2);
                    } else {
                        return;
                    }
                }
                ++i;
            }
            this.identities.addElement(identity);
        }
    }

    @Override
    public synchronized boolean add(byte[] identity) {
        try {
            IdentityFile _identity = IdentityFile.newInstance("from remote:", identity, null, this.jsch);
            this.add(_identity);
            return true;
        }
        catch (JSchException jSchException) {
            return false;
        }
    }

    synchronized void remove(Identity identity) {
        if (this.identities.contains(identity)) {
            this.identities.removeElement(identity);
            identity.clear();
        } else {
            this.remove(identity.getPublicKeyBlob());
        }
    }

    @Override
    public synchronized boolean remove(byte[] blob) {
        if (blob == null) {
            return false;
        }
        int i = 0;
        while (i < this.identities.size()) {
            Identity _identity = (Identity)this.identities.elementAt(i);
            byte[] _blob = _identity.getPublicKeyBlob();
            if (_blob != null && Util.array_equals(blob, _blob)) {
                this.identities.removeElement(_identity);
                _identity.clear();
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public synchronized void removeAll() {
        int i = 0;
        while (i < this.identities.size()) {
            Identity identity = (Identity)this.identities.elementAt(i);
            identity.clear();
            ++i;
        }
        this.identities.removeAllElements();
    }

    private void removeDupulicates() {
        Vector<byte[]> v = new Vector<byte[]>();
        int len = this.identities.size();
        if (len == 0) {
            return;
        }
        int i = 0;
        while (i < len) {
            Identity foo = (Identity)this.identities.elementAt(i);
            byte[] foo_blob = foo.getPublicKeyBlob();
            if (foo_blob != null) {
                int j = i + 1;
                while (j < len) {
                    Identity bar = (Identity)this.identities.elementAt(j);
                    byte[] bar_blob = bar.getPublicKeyBlob();
                    if (bar_blob != null && Util.array_equals(foo_blob, bar_blob) && foo.isEncrypted() == bar.isEncrypted()) {
                        v.addElement(foo_blob);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < v.size()) {
            this.remove((byte[])v.elementAt(i));
            ++i;
        }
    }
}

