/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jcraft;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

public class SftpUtil {
    public static void upload(String fileName) throws Exception {
        Session session = null;
        Channel channel = null;
        ChannelSftp channelSftp = null;
        try {
            JSch jsch = new JSch();
            session = jsch.getSession("<sftp.user.name>", "<sftp.host>", Integer.valueOf("<sftp.port>"));
            session.setPassword("<sftp.user.password>");
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            SftpUtil.isSftpProxyEnabled(session);
            long lStartTime = new Date().getTime();
            System.out.println("Connecting to the sftp...");
            session.connect();
            System.out.println("Connected to the sftp.");
            long lEndTime = new Date().getTime();
            System.out.println("---------------------------------------------");
            System.out.println("Connected to SFTP in : " + (lEndTime - lStartTime));
            channel = session.openChannel("sftp");
            channel.connect();
            channelSftp = (ChannelSftp)channel;
            channelSftp.cd("<sftp.output.folder.url>");
            File file = new File(fileName);
            FileInputStream fileInputStream = new FileInputStream(file);
            channelSftp.put(fileInputStream, file.getName());
            fileInputStream.close();
            fileInputStream = null;
        }
        finally {
            if (channelSftp != null) {
                channelSftp.exit();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private static void isSftpProxyEnabled(Session session) {
        boolean isSftpProxyEnabled = Boolean.valueOf("<sftp.proxy.enable>");
        if (isSftpProxyEnabled) {
            session.setProxy(new ProxyHTTP("<sftp.proxy.host>", Integer.valueOf("<sftp.proxy.port>")));
        }
        System.out.println("Proxy status: " + isSftpProxyEnabled);
    }

    public static void download(String folder, String event, String locale) {
        Session session = null;
        Channel channel = null;
        ChannelSftp channelSftp = null;
        try {
            try {
                JSch jsch = new JSch();
                session = jsch.getSession("<sftp.user.name>", "<sftp.host>", Integer.valueOf("<sftp.port>"));
                session.setPassword("<sftp.user.password>");
                Properties config = new Properties();
                config.put("StrictHostKeyChecking", "no");
                session.setConfig(config);
                SftpUtil.isSftpProxyEnabled(session);
                long lStartTime = new Date().getTime();
                System.out.println("Connecting to the sftp...");
                session.connect();
                System.out.println("Connected to the sftp.");
                long lEndTime = new Date().getTime();
                System.out.println("---------------------------------------------");
                System.out.println("Connected to SFTP in : " + (lEndTime - lStartTime));
                channel = session.openChannel("SFTP");
                channel.connect();
                channelSftp = (ChannelSftp)channel;
                try {
                    channelSftp.cd("<sftp.input.folder.url>");
                }
                catch (SftpException sftpException) {
                    System.out.println("Failed to change the directory in sftp.");
                }
                Vector lsEntries = channelSftp.ls("*" + "<sys.code>" + "*" + event + "*" + locale + "*" + ".csv");
                if (lsEntries.isEmpty()) {
                    System.out.println("No file exist in the specified sftp folder location.");
                }
                for (ChannelSftp.LsEntry entry : lsEntries) {
                    try {
                        channelSftp.get(entry.getFilename(), folder + File.separator + entry.getFilename());
                    }
                    catch (SftpException sftpException) {
                        System.out.println("Failed to download the file the sftp folder location.");
                    }
                }
                for (ChannelSftp.LsEntry entry : lsEntries) {
                    try {
                        channelSftp.rm(entry.getFilename());
                    }
                    catch (SftpException sftpException) {
                        System.out.println("Failed to delete the file from the sftp folder location.");
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Failed to download the file(s) from SFTP.");
                if (channelSftp != null) {
                    channelSftp.exit();
                }
                if (channel != null) {
                    channel.disconnect();
                }
                if (session != null) {
                    session.disconnect();
                }
            }
        }
        finally {
            if (channelSftp != null) {
                channelSftp.exit();
            }
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }
}

