/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.LifecycleAware;

public final class AggregateEventHandler<T>
implements EventHandler<T>,
LifecycleAware {
    private final EventHandler<T>[] eventHandlers;

    @SafeVarargs
    public AggregateEventHandler(EventHandler<T> ... eventHandlers) {
        this.eventHandlers = eventHandlers;
    }

    @Override
    public void onEvent(T event, long sequence, boolean endOfBatch) throws Exception {
        EventHandler<T>[] eventHandlerArray = this.eventHandlers;
        int n = this.eventHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            EventHandler<T> eventHandler = eventHandlerArray[n2];
            eventHandler.onEvent(event, sequence, endOfBatch);
            ++n2;
        }
    }

    @Override
    public void onStart() {
        EventHandler<T>[] eventHandlerArray = this.eventHandlers;
        int n = this.eventHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            EventHandler<T> eventHandler = eventHandlerArray[n2];
            if (eventHandler instanceof LifecycleAware) {
                ((LifecycleAware)((Object)eventHandler)).onStart();
            }
            ++n2;
        }
    }

    @Override
    public void onShutdown() {
        EventHandler<T>[] eventHandlerArray = this.eventHandlers;
        int n = this.eventHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            EventHandler<T> eventHandler = eventHandlerArray[n2];
            if (eventHandler instanceof LifecycleAware) {
                ((LifecycleAware)((Object)eventHandler)).onShutdown();
            }
            ++n2;
        }
    }
}

