/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.Cursored;
import com.lmax.disruptor.Sequence;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class SequenceGroups {
    SequenceGroups() {
    }

    static <T> void addSequences(T holder, AtomicReferenceFieldUpdater<T, Sequence[]> updater, Cursored cursor, Sequence ... sequencesToAdd) {
        int n;
        long cursorSequence;
        Sequence[] updatedSequences;
        Sequence[] currentSequences;
        do {
            currentSequences = updater.get(holder);
            updatedSequences = Arrays.copyOf(currentSequences, currentSequences.length + sequencesToAdd.length);
            cursorSequence = cursor.getCursor();
            int index = currentSequences.length;
            Sequence[] sequenceArray = sequencesToAdd;
            int n2 = sequencesToAdd.length;
            n = 0;
            while (n < n2) {
                Sequence sequence = sequenceArray[n];
                sequence.set(cursorSequence);
                updatedSequences[index++] = sequence;
                ++n;
            }
        } while (!updater.compareAndSet(holder, currentSequences, updatedSequences));
        cursorSequence = cursor.getCursor();
        Sequence[] sequenceArray = sequencesToAdd;
        n = sequencesToAdd.length;
        int n3 = 0;
        while (n3 < n) {
            Sequence sequence = sequenceArray[n3];
            sequence.set(cursorSequence);
            ++n3;
        }
    }

    static <T> boolean removeSequence(T holder, AtomicReferenceFieldUpdater<T, Sequence[]> sequenceUpdater, Sequence sequence) {
        Sequence[] oldSequences;
        int numToRemove;
        while ((numToRemove = SequenceGroups.countMatching(oldSequences = sequenceUpdater.get(holder), sequence)) != 0) {
            int oldSize = oldSequences.length;
            Sequence[] newSequences = new Sequence[oldSize - numToRemove];
            int i = 0;
            int pos = 0;
            while (i < oldSize) {
                Sequence testSequence = oldSequences[i];
                if (sequence != testSequence) {
                    newSequences[pos++] = testSequence;
                }
                ++i;
            }
            if (!sequenceUpdater.compareAndSet(holder, oldSequences, newSequences)) continue;
        }
        return numToRemove != 0;
    }

    private static <T> int countMatching(T[] values, T toMatch) {
        int numToRemove = 0;
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            if (value == toMatch) {
                ++numToRemove;
            }
            ++n2;
        }
        return numToRemove;
    }
}

