/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.test;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import javax.sql.DataSource;

public final class LoadPoolBackedDataSource {
    static final int NUM_THREADS = 100;
    static final int ITERATIONS_PER_THREAD = 1000;
    static DataSource ds;

    public static void main(String[] argv) {
        block26: {
            if (argv.length > 0) {
                System.err.println(String.valueOf(LoadPoolBackedDataSource.class.getName()) + " now requires no args. Please set everything in standard c3p0 config files.");
                return;
            }
            try {
                try {
                    block25: {
                        DataSource ds_unpooled = DataSources.unpooledDataSource();
                        ds = DataSources.pooledDataSource(ds_unpooled);
                        Connection con = null;
                        Statement stmt = null;
                        try {
                            try {
                                con = ds.getConnection();
                                stmt = con.createStatement();
                                stmt.executeUpdate("CREATE TABLE testpbds ( a varchar(16), b varchar(16) )");
                                System.err.println("LoadPoolBackedDataSource -- TEST SCHEMA CREATED");
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                                System.err.println("relation testpbds already exists, or something bad happened.");
                                StatementUtils.attemptClose((Statement)stmt);
                                ConnectionUtils.attemptClose((Connection)con);
                                break block25;
                            }
                        }
                        catch (Throwable throwable) {
                            StatementUtils.attemptClose(stmt);
                            ConnectionUtils.attemptClose((Connection)con);
                            throw throwable;
                        }
                        StatementUtils.attemptClose((Statement)stmt);
                        ConnectionUtils.attemptClose((Connection)con);
                    }
                    Thread[] threads = new Thread[100];
                    int i = 0;
                    while (i < 100) {
                        ChurnThread t = new ChurnThread(i);
                        threads[i] = t;
                        t.start();
                        System.out.println("THREAD MADE [" + i + "]");
                        Thread.sleep(500L);
                        ++i;
                    }
                    i = 0;
                    while (i < 100) {
                        threads[i].join();
                        ++i;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Connection con = null;
                    Statement stmt = null;
                    try {
                        try {
                            con = ds.getConnection();
                            stmt = con.createStatement();
                            stmt.executeUpdate("DROP TABLE testpbds");
                            System.err.println("LoadPoolBackedDataSource -- TEST SCHEMA DROPPED");
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            StatementUtils.attemptClose((Statement)stmt);
                            ConnectionUtils.attemptClose((Connection)con);
                            break block26;
                        }
                    }
                    catch (Throwable throwable) {
                        StatementUtils.attemptClose(stmt);
                        ConnectionUtils.attemptClose((Connection)con);
                        throw throwable;
                    }
                    StatementUtils.attemptClose((Statement)stmt);
                    ConnectionUtils.attemptClose((Connection)con);
                }
            }
            finally {
                block29: {
                    Connection con = null;
                    Statement stmt = null;
                    try {
                        try {
                            con = ds.getConnection();
                            stmt = con.createStatement();
                            stmt.executeUpdate("DROP TABLE testpbds");
                            System.err.println("LoadPoolBackedDataSource -- TEST SCHEMA DROPPED");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            StatementUtils.attemptClose((Statement)stmt);
                            ConnectionUtils.attemptClose((Connection)con);
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        StatementUtils.attemptClose(stmt);
                        ConnectionUtils.attemptClose((Connection)con);
                        throw throwable;
                    }
                    StatementUtils.attemptClose((Statement)stmt);
                    ConnectionUtils.attemptClose((Connection)con);
                }
            }
        }
    }

    static void executeInsert(Connection con, Random random) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.executeUpdate("INSERT INTO testpbds VALUES ('" + random.nextInt() + "', '" + random.nextInt() + "')");
            System.out.println("INSERTION");
        }
        finally {
            StatementUtils.attemptClose((Statement)stmt);
        }
    }

    static void executeDelete(Connection con) throws SQLException {
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.executeUpdate("DELETE FROM testpbds;");
            System.out.println("DELETION");
        }
        finally {
            StatementUtils.attemptClose((Statement)stmt);
        }
    }

    static void executeSelect(Connection con) throws SQLException {
        long l = System.currentTimeMillis();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SELECT count(*) FROM testpbds");
            rs.next();
            System.out.println("SELECT [count=" + rs.getInt(1) + ", time=" + (System.currentTimeMillis() - l) + " msecs]");
        }
        catch (Throwable throwable) {
            ResultSetUtils.attemptClose(rs);
            StatementUtils.attemptClose((Statement)stmt);
            throw throwable;
        }
        ResultSetUtils.attemptClose((ResultSet)rs);
        StatementUtils.attemptClose((Statement)stmt);
    }

    private static void usage() {
        System.err.println("java -Djdbc.drivers=<comma_sep_list_of_drivers> " + LoadPoolBackedDataSource.class.getName() + " <jdbc_url> [<username> <password>]");
        System.exit(-1);
    }

    static class ChurnThread
    extends Thread {
        Random random = new Random();
        int num;

        public ChurnThread(int num) {
            this.num = num;
        }

        @Override
        public void run() {
            try {
                int i = 0;
                while (i < 1000) {
                    Connection con = null;
                    try {
                        con = ds.getConnection();
                        int select = this.random.nextInt(3);
                        switch (select) {
                            case 0: {
                                LoadPoolBackedDataSource.executeSelect(con);
                                break;
                            }
                            case 1: {
                                LoadPoolBackedDataSource.executeInsert(con, this.random);
                                break;
                            }
                            case 2: {
                                LoadPoolBackedDataSource.executeDelete(con);
                            }
                        }
                        PooledDataSource pds = (PooledDataSource)ds;
                        System.out.println("iteration: (" + this.num + ", " + i + ')');
                        System.out.println(pds.getNumConnectionsDefaultUser());
                        System.out.println(pds.getNumIdleConnectionsDefaultUser());
                        System.out.println(pds.getNumBusyConnectionsDefaultUser());
                        System.out.println(pds.getNumConnectionsAllUsers());
                        Thread.sleep(1L);
                    }
                    finally {
                        ConnectionUtils.attemptClose((Connection)con);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

