/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.test;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.ResultSetUtils;
import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.c3p0.DataSources;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import javax.sql.DataSource;

public final class PSLoadPoolBackedDataSource {
    static final String INSERT_STMT = "INSERT INTO testpbds VALUES ( ? , ? )";
    static final String SELECT_STMT = "SELECT count(*) FROM testpbds";
    static final String DELETE_STMT = "DELETE FROM testpbds";
    static DataSource ds;

    public static void main(String[] argv) {
        if (argv.length > 0) {
            System.err.println(String.valueOf(PSLoadPoolBackedDataSource.class.getName()) + " now requires no args. Please set everything in standard c3p0 config files.");
            return;
        }
        try {
            block9: {
                DataSource ds_unpooled = DataSources.unpooledDataSource();
                ds = DataSources.pooledDataSource(ds_unpooled);
                Connection con = null;
                Statement stmt = null;
                try {
                    try {
                        con = ds_unpooled.getConnection();
                        stmt = con.createStatement();
                        stmt.executeUpdate("CREATE TABLE testpbds ( a varchar(16), b varchar(16) )");
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        System.err.println("relation testpbds already exists, or something bad happened.");
                        StatementUtils.attemptClose((Statement)stmt);
                        ConnectionUtils.attemptClose((Connection)con);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    StatementUtils.attemptClose(stmt);
                    ConnectionUtils.attemptClose((Connection)con);
                    throw throwable;
                }
                StatementUtils.attemptClose((Statement)stmt);
                ConnectionUtils.attemptClose((Connection)con);
            }
            int i = 0;
            while (i < 100) {
                ChurnThread t = new ChurnThread();
                t.start();
                System.out.println("THREAD MADE [" + i + "]");
                Thread.sleep(500L);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void executeInsert(Connection con, Random random) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(INSERT_STMT);
            pstmt.setInt(1, random.nextInt());
            pstmt.setInt(2, random.nextInt());
            pstmt.executeUpdate();
            System.out.println("INSERTION");
        }
        finally {
            StatementUtils.attemptClose((Statement)pstmt);
        }
    }

    static void executeSelect(Connection con, Random random) throws SQLException {
        long l = System.currentTimeMillis();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(SELECT_STMT);
            rs = pstmt.executeQuery();
            rs.next();
            System.out.println("SELECT [count=" + rs.getInt(1) + ", time=" + (System.currentTimeMillis() - l) + " msecs]");
        }
        catch (Throwable throwable) {
            ResultSetUtils.attemptClose(rs);
            StatementUtils.attemptClose((Statement)pstmt);
            throw throwable;
        }
        ResultSetUtils.attemptClose((ResultSet)rs);
        StatementUtils.attemptClose((Statement)pstmt);
    }

    static void executeDelete(Connection con, Random random) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(DELETE_STMT);
            int deleted = pstmt.executeUpdate();
            System.out.println("DELETE [" + deleted + " rows]");
        }
        finally {
            ResultSetUtils.attemptClose(rs);
            StatementUtils.attemptClose((Statement)pstmt);
        }
    }

    static class ChurnThread
    extends Thread {
        Random random = new Random();

        ChurnThread() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    block13: {
                        Connection con = null;
                        try {
                            try {
                                con = ds.getConnection();
                                int select = this.random.nextInt(3);
                                switch (select) {
                                    case 0: {
                                        PSLoadPoolBackedDataSource.executeSelect(con, this.random);
                                        break;
                                    }
                                    case 1: {
                                        PSLoadPoolBackedDataSource.executeInsert(con, this.random);
                                        break;
                                    }
                                    case 2: {
                                        PSLoadPoolBackedDataSource.executeDelete(con, this.random);
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                ConnectionUtils.attemptClose((Connection)con);
                                break block13;
                            }
                        }
                        catch (Throwable throwable) {
                            ConnectionUtils.attemptClose((Connection)con);
                            throw throwable;
                        }
                        ConnectionUtils.attemptClose((Connection)con);
                    }
                    Thread.sleep(1L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

