/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.test.junit;

import com.mchange.v2.c3p0.test.junit.C3P0JUnitTestCaseBase;
import java.sql.Connection;
import java.sql.SQLData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ConnectionPropertiesResetJUnitTestCase
extends C3P0JUnitTestCaseBase {
    static final Map TM;

    static {
        HashMap<String, Class<SQLData>> tmp = new HashMap<String, Class<SQLData>>();
        tmp.put("FAKE", SQLData.class);
        TM = Collections.unmodifiableMap(tmp);
    }

    public void testAllConnectionDefaultsReset() {
        this.cpds.setInitialPoolSize(5);
        this.cpds.setMinPoolSize(5);
        this.cpds.setMaxPoolSize(5);
        this.cpds.setMaxIdleTime(0);
        this.cpds.setTestConnectionOnCheckout(false);
        this.cpds.setTestConnectionOnCheckin(false);
        this.cpds.setIdleConnectionTestPeriod(0);
        try {
            int dflt_txn_isolation;
            String dfltCat;
            Connection con = null;
            try {
                con = this.cpds.getConnection();
                dfltCat = con.getCatalog();
                dflt_txn_isolation = con.getTransactionIsolation();
                try {
                    con.setReadOnly(true);
                }
                catch (Exception exception) {}
                try {
                    con.setTypeMap(TM);
                }
                catch (Exception exception) {}
                try {
                    con.setCatalog("C3P0TestCatalogXXX");
                }
                catch (Exception exception) {}
                try {
                    con.setTransactionIsolation(dflt_txn_isolation == 8 ? 2 : 8);
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception exception) {}
            Connection[] cons = new Connection[5];
            int i = 0;
            while (i < 5) {
                cons[i] = this.cpds.getConnection();
                ConnectionPropertiesResetJUnitTestCase.assertFalse((String)"Connection from pool should not be readOnly!", (boolean)cons[i].isReadOnly());
                Map<String, Class<?>> typeMap = cons[i].getTypeMap();
                ConnectionPropertiesResetJUnitTestCase.assertTrue((String)"Connection from pool should have an empty type map!", (boolean)(typeMap == null ? true : typeMap.isEmpty()));
                ConnectionPropertiesResetJUnitTestCase.assertEquals((String)"Connection from pool should have default catalog set!", (String)dfltCat, (String)cons[i].getCatalog());
                ConnectionPropertiesResetJUnitTestCase.assertEquals((String)"Connection from pool should have default txn isolation set!", (int)dflt_txn_isolation, (int)cons[i].getTransactionIsolation());
                cons[i].close();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ConnectionPropertiesResetJUnitTestCase.fail((String)e.getMessage());
        }
    }
}

