/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.test.junit;

import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.test.junit.C3P0JUnitTestCaseBase;
import com.mchange.v2.naming.ReferenceableUtils;
import com.mchange.v2.ser.SerializableUtils;
import java.util.Arrays;
import java.util.Collection;
import javax.naming.RefAddr;
import javax.naming.Reference;

public final class MarshallUnmarshallDataSourcesJUnitTestCase
extends C3P0JUnitTestCaseBase {
    static final Collection EXCLUDE_PROPS = Arrays.asList("allUsers", "connection", "connectionPoolDataSource", "effectivePropertyCycleDefaultUser", "lastCheckinFailureDefaultUser", "lastCheckoutFailureDefaultUser", "lastConnectionTestFailureDefaultUser", "lastIdleTestFailureDefaultUser", "logWriter", "numBusyConnections", "numBusyConnectionsAllUsers", "numBusyConnectionsDefaultUser", "numConnections", "numConnectionsAllUsers", "numConnectionsDefaultUser", "numFailedCheckinsDefaultUser", "numFailedCheckoutsDefaultUser", "numFailedIdleTestsDefaultUser", "numIdleConnections", "numIdleConnectionsAllUsers", "numIdleConnectionsDefaultUser", "numUnclosedOrphanedConnections", "numUnclosedOrphanedConnectionsAllUsers", "numUnclosedOrphanedConnectionsDefaultUser", "numUserPools", "parentLogger", "propertyChangeListeners", "reference", "startTimeMillisDefaultUser", "statementCacheNumCheckedOutDefaultUser", "statementCacheNumCheckedOutStatementsAllUsers", "statementCacheNumConnectionsWithCachedStatementsAllUsers", "statementCacheNumConnectionsWithCachedStatementsDefaultUser", "statementCacheNumDeferredCloseThreads", "statementCacheNumStatementsAllUsers", "statementCacheNumStatementsDefaultUser", "statementDestroyerNumActiveThreads", "statementDestroyerNumConnectionsWithDeferredDestroyStatementsAllUsers", "statementDestroyerNumConnectionsWithDeferredDestroyStatementsDefaultUser", "statementDestroyerNumConnectionsInUseAllUsers", "statementDestroyerNumConnectionsInUseDefaultUser", "statementDestroyerNumDeferredDestroyStatementsAllUsers", "statementDestroyerNumDeferredDestroyStatementsDefaultUser", "statementDestroyerNumIdleThreads", "statementDestroyerNumTasksPending", "statementDestroyerNumThreads", "threadPoolSize", "threadPoolNumActiveThreads", "threadPoolNumIdleThreads", "threadPoolNumTasksPending", "threadPoolStackTraces", "threadPoolStatus", "upTimeMillisDefaultUser", "vetoableChangeListeners");

    public void testSerializationRoundTrip() {
        try {
            this.cpds.setIdentityToken("poop");
            byte[] pickled = SerializableUtils.toByteArray((Object)this.cpds);
            ComboPooledDataSource unpickled = (ComboPooledDataSource)SerializableUtils.fromByteArray((byte[])pickled);
            this.compareReferences(this.cpds.getReference(), unpickled.getReference());
            MarshallUnmarshallDataSourcesJUnitTestCase.assertTrue((String)("Marshalled and unmarshalled DataSources should have the same properties!\n\n[[[[cpds]]]:\n" + this.cpds + "\n\n[[[unpickled]]]:\n" + unpickled + "\n\n"), (boolean)BeansUtils.equalsByAccessibleProperties((Object)this.cpds, (Object)unpickled, (Collection)EXCLUDE_PROPS));
        }
        catch (Exception e) {
            e.printStackTrace();
            MarshallUnmarshallDataSourcesJUnitTestCase.fail((String)e.getMessage());
        }
    }

    private void compareReferences(Reference ref1, Reference ref2) throws Exception {
        ComboPooledDataSource cpds1 = (ComboPooledDataSource)ReferenceableUtils.referenceToObject((Reference)ref1, null, null, null);
        ComboPooledDataSource cpds2 = (ComboPooledDataSource)ReferenceableUtils.referenceToObject((Reference)ref2, null, null, null);
        MarshallUnmarshallDataSourcesJUnitTestCase.assertTrue((String)"Marshalled and unmarshalled DataSources references point to the equivalent DataSources", (boolean)BeansUtils.equalsByAccessibleProperties((Object)cpds1, (Object)cpds2, (Collection)EXCLUDE_PROPS));
    }

    private void sideBySidePrintReferences(Reference ref1, Reference ref2) throws Exception {
        System.err.println("SIDE BY SIDE:");
        int sz1 = ref1.size();
        int sz2 = ref2.size();
        if (sz1 != sz2) {
            System.err.println("Sizes differ! sz1: " + sz1 + "; sz2: " + sz2);
        }
        int i = 0;
        int len = Math.max(sz1, sz2);
        while (i < len) {
            RefAddr ra1 = i < sz1 ? ref1.get(i) : null;
            RefAddr ra2 = i < sz2 ? ref2.get(i) : null;
            String s1 = ra1 == null ? "XXXXX" : String.valueOf(ra1.getContent().toString()) + " [" + ra1.getType() + "]";
            String s2 = ra2 == null ? "XXXXX" : String.valueOf(ra2.getContent().toString()) + " [" + ra2.getType() + "]";
            System.err.println("\t" + s1 + "      " + s2 + "      " + (s1 != null && s1.equals(s2)));
            ++i;
        }
    }

    public void testRefDerefRoundTrip() {
        try {
            this.cpds.setIdentityToken("scoop");
            Reference ref = this.cpds.getReference();
            ComboPooledDataSource unpickled = (ComboPooledDataSource)ReferenceableUtils.referenceToObject((Reference)ref, null, null, null);
            MarshallUnmarshallDataSourcesJUnitTestCase.assertTrue((String)"Marshalled and unmarshalled DataSources should have the same properties!", (boolean)BeansUtils.equalsByAccessibleProperties((Object)this.cpds, (Object)unpickled, (Collection)EXCLUDE_PROPS));
        }
        catch (Exception e) {
            e.printStackTrace();
            MarshallUnmarshallDataSourcesJUnitTestCase.fail((String)e.getMessage());
        }
    }
}

