/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.rmi;

import com.mchange.io.UnsupportedVersionException;
import com.mchange.rmi.CallingCard;
import com.mchange.rmi.Checkable;
import com.mchange.rmi.ServiceUnavailableException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;

public class RMIRegistryCallingCard
implements CallingCard,
Serializable {
    transient Remote cached = null;
    transient String url;
    static final long serialVersionUID = 1L;
    private static final short VERSION = 1;

    public RMIRegistryCallingCard(String regHost, int reg_port, String name) {
        this.url = "//" + regHost.toLowerCase() + ':' + reg_port + '/' + name;
    }

    public RMIRegistryCallingCard(String regHost, String name) {
        this(regHost, 1099, name);
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof RMIRegistryCallingCard && this.url.equals(((RMIRegistryCallingCard)o).url);
    }

    @Override
    public int hashCode() {
        return this.url.hashCode();
    }

    @Override
    public Remote findRemote() throws ServiceUnavailableException, RemoteException {
        if (this.cached instanceof Checkable) {
            try {
                ((Checkable)this.cached).check();
                return this.cached;
            }
            catch (RemoteException remoteException) {
                this.cached = null;
                return this.findRemote();
            }
        }
        try {
            Remote r = Naming.lookup(this.url);
            if (r instanceof Checkable) {
                this.cached = r;
            }
            return r;
        }
        catch (NotBoundException notBoundException) {
            throw new ServiceUnavailableException("Object Not Bound: " + this.url);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ServiceUnavailableException("Uh oh. Bad url. It never will be available: " + this.url);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " [" + this.url + "];";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeShort(1);
        out.writeUTF(this.url);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        short version = in.readShort();
        switch (version) {
            case 1: {
                this.url = in.readUTF();
                break;
            }
            default: {
                throw new UnsupportedVersionException(String.valueOf(this.getClass().getName()) + "; Bad version: " + version);
            }
        }
    }
}

