/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.util.impl.CircularListEnumeration;
import com.mchange.util.impl.CircularListRecord;
import java.util.Enumeration;

public class CircularList
implements Cloneable {
    CircularListRecord firstRecord = null;
    int size = 0;

    private void addElement(Object object, boolean first) {
        if (this.firstRecord == null) {
            this.firstRecord = new CircularListRecord(object);
        } else {
            CircularListRecord newRecord;
            this.firstRecord.prev.next = newRecord = new CircularListRecord(object, this.firstRecord.prev, this.firstRecord);
            this.firstRecord.prev = newRecord;
            if (first) {
                this.firstRecord = newRecord;
            }
        }
        ++this.size;
    }

    private void removeElement(boolean first) {
        if (this.size == 1) {
            this.firstRecord = null;
        } else {
            if (first) {
                this.firstRecord = this.firstRecord.next;
            }
            this.zap(this.firstRecord.prev);
        }
        --this.size;
    }

    private void zap(CircularListRecord record) {
        record.next.prev = record.prev;
        record.prev.next = record.next;
    }

    public void appendElement(Object object) {
        this.addElement(object, false);
    }

    public void addElementToFront(Object object) {
        this.addElement(object, true);
    }

    public void removeFirstElement() {
        this.removeElement(true);
    }

    public void removeLastElement() {
        this.removeElement(false);
    }

    public void removeFromFront(int count) {
        if (count > this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(count) + ">" + this.size);
        }
        int i = 0;
        while (i < count) {
            this.removeElement(true);
            ++i;
        }
    }

    public void removeFromBack(int count) {
        if (count > this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(count) + ">" + this.size);
        }
        int i = 0;
        while (i < count) {
            this.removeElement(false);
            ++i;
        }
    }

    public void removeAllElements() {
        this.size = 0;
        this.firstRecord = null;
    }

    public Object getElementFromFront(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + ">=" + this.size);
        }
        CircularListRecord finger = this.firstRecord;
        int i = 0;
        while (i < index) {
            finger = finger.next;
            ++i;
        }
        return finger.object;
    }

    public Object getElementFromBack(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index) + ">=" + this.size);
        }
        CircularListRecord finger = this.firstRecord.prev;
        int i = 0;
        while (i < index) {
            finger = finger.prev;
            ++i;
        }
        return finger.object;
    }

    public Object getFirstElement() {
        try {
            return this.firstRecord.object;
        }
        catch (NullPointerException nullPointerException) {
            throw new IndexOutOfBoundsException("CircularList is empty.");
        }
    }

    public Object getLastElement() {
        try {
            return this.firstRecord.prev.object;
        }
        catch (NullPointerException nullPointerException) {
            throw new IndexOutOfBoundsException("CircularList is empty.");
        }
    }

    public Enumeration elements(boolean forward, boolean terminated) {
        return new CircularListEnumeration(this, forward, terminated);
    }

    public Enumeration elements(boolean forward) {
        return this.elements(forward, true);
    }

    public Enumeration elements() {
        return this.elements(true, true);
    }

    public int size() {
        return this.size;
    }

    public Object clone() {
        CircularList out = new CircularList();
        int len = this.size();
        int i = 0;
        while (i < len) {
            out.appendElement(this.getElementFromFront(i));
            ++i;
        }
        return out;
    }

    public static void main(String[] argv) {
        CircularList list = new CircularList();
        list.appendElement("Hello");
        list.appendElement("There");
        list.appendElement("Joe.");
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            System.out.println("x " + e.nextElement());
        }
    }
}

