/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.util.CommandLineParser;

public class CommandLineParserImpl
implements CommandLineParser {
    String[] argv;
    String[] validSwitches;
    String[] reqSwitches;
    String[] argSwitches;
    char switch_char;

    public CommandLineParserImpl(String[] argv, String[] validSwitches, String[] reqSwitches, String[] argSwitches, char switch_char) {
        this.argv = argv;
        this.validSwitches = validSwitches == null ? new String[]{} : validSwitches;
        this.reqSwitches = reqSwitches == null ? new String[]{} : reqSwitches;
        this.argSwitches = argSwitches == null ? new String[]{} : argSwitches;
        this.switch_char = switch_char;
    }

    public CommandLineParserImpl(String[] argv, String[] validSwitches, String[] reqSwitches, String[] argSwitches) {
        this(argv, validSwitches, reqSwitches, argSwitches, '-');
    }

    @Override
    public boolean checkSwitch(String sw) {
        int i = 0;
        while (i < this.argv.length) {
            if (this.argv[i].charAt(0) == this.switch_char && this.argv[i].equals(String.valueOf(this.switch_char) + sw)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String findSwitchArg(String sw) {
        int i = 0;
        while (i < this.argv.length - 1) {
            if (this.argv[i].charAt(0) == this.switch_char && this.argv[i].equals(String.valueOf(this.switch_char) + sw)) {
                return this.argv[i + 1].charAt(0) == this.switch_char ? null : this.argv[i + 1];
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean checkArgv() {
        return this.checkValidSwitches() && this.checkRequiredSwitches() && this.checkSwitchArgSyntax();
    }

    boolean checkValidSwitches() {
        int i = 0;
        while (i < this.argv.length) {
            block4: {
                if (this.argv[i].charAt(0) == this.switch_char) {
                    int j = 0;
                    while (j < this.validSwitches.length) {
                        if (!this.argv[i].equals(String.valueOf(this.switch_char) + this.validSwitches[j])) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    boolean checkRequiredSwitches() {
        int i = this.reqSwitches.length;
        while (--i >= 0) {
            if (this.checkSwitch(this.reqSwitches[i])) continue;
            return false;
        }
        return true;
    }

    boolean checkSwitchArgSyntax() {
        int i = this.argSwitches.length;
        while (--i >= 0) {
            String check;
            if (!this.checkSwitch(this.argSwitches[i]) || (check = this.findSwitchArg(this.argSwitches[i])) != null && check.charAt(0) != this.switch_char) continue;
            return false;
        }
        return true;
    }

    @Override
    public int findLastSwitched() {
        int i = this.argv.length;
        while (--i >= 0) {
            if (this.argv[i].charAt(0) != this.switch_char) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String[] findUnswitchedArgs() {
        String[] bigArray = new String[this.argv.length];
        int count = 0;
        int i = 0;
        while (i < this.argv.length) {
            if (this.argv[i].charAt(0) == this.switch_char) {
                if (CommandLineParserImpl.contains(this.argv[i].substring(1), this.argSwitches)) {
                    ++i;
                }
            } else {
                bigArray[count++] = this.argv[i];
            }
            ++i;
        }
        String[] out = new String[count];
        System.arraycopy(bigArray, 0, out, 0, count);
        return out;
    }

    private static boolean contains(String string, String[] list) {
        int i = list.length;
        while (--i >= 0) {
            if (!list[i].equals(string)) continue;
            return true;
        }
        return false;
    }
}

