/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.lang.ByteUtils;
import com.mchange.util.PasswordManager;
import com.mchange.util.impl.SyncedProperties;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class HexAsciiMD5PropertiesPasswordManager
implements PasswordManager {
    private static final String DIGEST_ALGORITHM = "MD5";
    private static final String PASSWORD_ENCODING = "8859_1";
    private static final String DEF_PASSWORD_PROP_PFX = "password";
    private static final String DEF_HEADER = "com.mchange.util.impl.HexAsciiMD5PropertiesPasswordManager data";
    private static final boolean DEBUG = true;
    SyncedProperties props;
    String pfx;
    MessageDigest md;

    public HexAsciiMD5PropertiesPasswordManager(File propsFile, String pfx, String[] header) throws IOException {
        this(new SyncedProperties(propsFile, header), pfx);
    }

    public HexAsciiMD5PropertiesPasswordManager(File propsFile, String pfx, String header) throws IOException {
        this(new SyncedProperties(propsFile, header), pfx);
    }

    public HexAsciiMD5PropertiesPasswordManager(File propsFile) throws IOException {
        this(propsFile, DEF_PASSWORD_PROP_PFX, DEF_HEADER);
    }

    private HexAsciiMD5PropertiesPasswordManager(SyncedProperties sp, String pfx) throws IOException {
        try {
            this.props = sp;
            this.pfx = pfx;
            this.md = MessageDigest.getInstance(DIGEST_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("MD5 is not supported???");
        }
    }

    @Override
    public synchronized boolean validate(String username, String password) throws IOException {
        try {
            String hStr = this.props.getProperty(this.pfx != null ? String.valueOf(this.pfx) + '.' + username : username);
            byte[] fileAuth = ByteUtils.fromHexAscii(hStr);
            byte[] incomingAuth = this.md.digest(password.getBytes(PASSWORD_ENCODING));
            return Arrays.equals(fileAuth, incomingAuth);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Password file corrupted! [contains invalid hex ascii string]");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new InternalError("8859_1is an unsupported encoding???");
        }
    }

    @Override
    public synchronized boolean updatePassword(String username, String oldPassword, String newPassword) throws IOException {
        if (!this.validate(username, oldPassword)) {
            return false;
        }
        this.props.put(String.valueOf(this.pfx) + '.' + username, ByteUtils.toHexAscii(this.md.digest(newPassword.getBytes(PASSWORD_ENCODING))));
        return true;
    }
}

