/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.io.InputStreamUtils;
import com.mchange.io.OutputStreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;

public class SyncedProperties {
    private static final String[] SA_TEMPLATE = new String[0];
    private static final byte H_START_BYTE = 35;
    private static final byte[] H_LF_BYTES;
    private static final String ASCII = "8859_1";
    Properties props;
    byte[] headerBytes;
    File file;
    long last_mod = -1L;

    static {
        try {
            H_LF_BYTES = System.getProperty("line.separator", "\r\n").getBytes(ASCII);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("Encoding 8859_1 not supported ?!?");
        }
    }

    public SyncedProperties(File file, String header) throws IOException {
        this(file, SyncedProperties.makeHeaderBytes(header));
    }

    public SyncedProperties(File file, String[] header) throws IOException {
        this(file, SyncedProperties.makeHeaderBytes(header));
    }

    public SyncedProperties(File file) throws IOException {
        this(file, (byte[])null);
    }

    private SyncedProperties(File file, byte[] headerBytes) throws IOException {
        if (file.exists()) {
            if (!file.isFile()) {
                throw new IOException(String.valueOf(file.getPath()) + ": Properties file can't be a directory or special file!");
            }
            if (headerBytes == null) {
                try (BufferedReader br = null;){
                    br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                    LinkedList<String> list = new LinkedList<String>();
                    String line = br.readLine();
                    while (line.trim().equals("")) {
                        line = br.readLine();
                    }
                    while (line.charAt(0) == '#') {
                        list.add(line.substring(1).trim());
                    }
                    headerBytes = SyncedProperties.makeHeaderBytes(list.toArray(SA_TEMPLATE));
                }
            }
        }
        if (!file.canWrite()) {
            throw new IOException("Can't write to file " + file.getPath());
        }
        this.props = new Properties();
        this.headerBytes = headerBytes;
        this.file = file;
        this.ensureUpToDate();
    }

    public synchronized String getProperty(String property) throws IOException {
        this.ensureUpToDate();
        return this.props.getProperty(property);
    }

    public synchronized String getProperty(String property, String defaultValue) throws IOException {
        String out = this.props.getProperty(property);
        return out == null ? defaultValue : out;
    }

    public synchronized void put(String property, String value) throws IOException {
        this.ensureUpToDate();
        this.props.put(property, value);
        this.rewritePropsFile();
    }

    public synchronized void remove(String property) throws IOException {
        this.ensureUpToDate();
        this.props.remove(property);
        this.rewritePropsFile();
    }

    public synchronized void clear() throws IOException {
        this.ensureUpToDate();
        this.props.clear();
        this.rewritePropsFile();
    }

    public synchronized boolean contains(String value) throws IOException {
        this.ensureUpToDate();
        return this.props.contains(value);
    }

    public synchronized boolean containsKey(String key) throws IOException {
        this.ensureUpToDate();
        return this.props.containsKey(key);
    }

    public synchronized Enumeration elements() throws IOException {
        this.ensureUpToDate();
        return this.props.elements();
    }

    public synchronized Enumeration keys() throws IOException {
        this.ensureUpToDate();
        return this.props.keys();
    }

    public synchronized int size() throws IOException {
        this.ensureUpToDate();
        return this.props.size();
    }

    public synchronized boolean isEmpty() throws IOException {
        this.ensureUpToDate();
        return this.props.isEmpty();
    }

    private synchronized void ensureUpToDate() throws IOException {
        long new_mod = this.file.lastModified();
        if (new_mod > this.last_mod) {
            BufferedInputStream is = null;
            try {
                is = new BufferedInputStream(new FileInputStream(this.file));
                this.props.clear();
                this.props.load(is);
                this.last_mod = new_mod;
            }
            catch (Throwable throwable) {
                InputStreamUtils.attemptClose(is);
                throw throwable;
            }
            InputStreamUtils.attemptClose(is);
        }
    }

    private synchronized void rewritePropsFile() throws IOException {
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(this.file));
            if (this.headerBytes != null) {
                ((OutputStream)os).write(this.headerBytes);
            }
            this.props.store(os, null);
            ((OutputStream)os).flush();
            this.last_mod = this.file.lastModified();
        }
        catch (Throwable throwable) {
            OutputStreamUtils.attemptClose(os);
            throw throwable;
        }
        OutputStreamUtils.attemptClose(os);
    }

    private static byte[] makeHeaderBytes(String[] header) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int i = 0;
            int len = header.length;
            while (i < len) {
                baos.write(35);
                baos.write(header[i].getBytes());
                baos.write(H_LF_BYTES);
                ++i;
            }
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            throw new InternalError("IOException working with ByteArrayOutputStream?!?");
        }
    }

    private static byte[] makeHeaderBytes(String header) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(35);
            baos.write(header.getBytes());
            baos.write(H_LF_BYTES);
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            throw new InternalError("IOException working with ByteArrayOutputStream?!?");
        }
    }
}

