/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.cachedstore;

import com.mchange.v1.cachedstore.Autoflushing;
import com.mchange.v1.cachedstore.CacheFlushException;
import com.mchange.v1.cachedstore.CachedStoreException;
import com.mchange.v1.cachedstore.CachedStoreUtils;
import com.mchange.v1.cachedstore.WritableCachedStore;
import java.util.Collections;
import java.util.Set;

class NoCacheWritableCachedStore
implements WritableCachedStore,
Autoflushing {
    WritableCachedStore.Manager mgr;

    NoCacheWritableCachedStore(WritableCachedStore.Manager mgr) {
        this.mgr = mgr;
    }

    @Override
    public Object find(Object key) throws CachedStoreException {
        try {
            return this.mgr.recreateFromKey(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw CachedStoreUtils.toCachedStoreException(e);
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void write(Object key, Object value) throws CachedStoreException {
        try {
            this.mgr.writeToStorage(key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw CachedStoreUtils.toCachedStoreException(e);
        }
    }

    @Override
    public void remove(Object key) throws CachedStoreException {
        try {
            this.mgr.removeFromStorage(key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw CachedStoreUtils.toCachedStoreException(e);
        }
    }

    @Override
    public void flushWrites() throws CacheFlushException {
    }

    @Override
    public Set getFailedWrites() throws CachedStoreException {
        return Collections.EMPTY_SET;
    }

    @Override
    public void clearPendingWrites() throws CachedStoreException {
    }

    @Override
    public void sync() throws CachedStoreException {
    }
}

