/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.db.sql;

import com.mchange.v1.db.sql.ConnectionUtils;
import com.mchange.v1.db.sql.Schema;
import com.mchange.v1.db.sql.StatementUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlSchema
implements Schema {
    private static final int CREATE = 0;
    private static final int DROP = 1;
    List createStmts;
    List dropStmts;
    Map appMap;

    public XmlSchema(URL xmlSchema) throws SAXException, IOException, ParserConfigurationException {
        this.parse(xmlSchema.openStream());
    }

    public XmlSchema(InputStream xmlStream) throws SAXException, IOException, ParserConfigurationException {
        this.parse(xmlStream);
    }

    public XmlSchema() {
    }

    public void parse(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        this.createStmts = new ArrayList();
        this.dropStmts = new ArrayList();
        this.appMap = new HashMap();
        InputSource isrc = new InputSource();
        isrc.setByteStream(is);
        isrc.setSystemId(XmlSchema.class.getResource("schema.dtd").toExternalForm());
        SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
        MySaxHandler testHandler = new MySaxHandler();
        sp.parse(isrc, (HandlerBase)testHandler);
    }

    private void doStatementList(List stmtList, Connection con) throws SQLException {
        if (stmtList != null) {
            Statement stmt = null;
            try {
                try {
                    stmt = con.createStatement();
                    Iterator ii = stmtList.iterator();
                    while (ii.hasNext()) {
                        stmt.executeUpdate((String)ii.next());
                    }
                    con.commit();
                }
                catch (SQLException e) {
                    ConnectionUtils.attemptRollback(con);
                    e.fillInStackTrace();
                    throw e;
                }
            }
            finally {
                StatementUtils.attemptClose(stmt);
            }
        }
    }

    @Override
    public String getStatementText(String appName, String stmtName) {
        SqlApp app = (SqlApp)this.appMap.get(appName);
        String out = null;
        if (app != null) {
            out = app.getStatementText(stmtName);
        }
        return out;
    }

    @Override
    public void createSchema(Connection con) throws SQLException {
        this.doStatementList(this.createStmts, con);
    }

    @Override
    public void dropSchema(Connection con) throws SQLException {
        this.doStatementList(this.dropStmts, con);
    }

    public static void main(String[] argv) {
        try {
            new XmlSchema(XmlSchema.class.getResource("/com/mchange/v1/hjug/hjugschema.xml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MySaxHandler
    extends HandlerBase {
        int state = -1;
        boolean in_statement = false;
        boolean in_comment = false;
        StringBuffer charBuff = null;
        SqlApp currentApp = null;
        String currentStmtName = null;

        MySaxHandler() {
        }

        @Override
        public void startElement(String name, AttributeList attributes) {
            block7: {
                block10: {
                    block9: {
                        block8: {
                            if (!name.equals("create")) break block8;
                            this.state = 0;
                            break block7;
                        }
                        if (!name.equals("drop")) break block9;
                        this.state = 1;
                        break block7;
                    }
                    if (!name.equals("statement")) break block10;
                    this.in_statement = true;
                    this.charBuff = new StringBuffer();
                    if (this.currentApp == null) break block7;
                    int i = 0;
                    int len = attributes.getLength();
                    while (i < len) {
                        String attr = attributes.getName(i);
                        if (attr.equals("name")) {
                            this.currentStmtName = attributes.getValue(i);
                            break block7;
                        }
                        ++i;
                    }
                    break block7;
                }
                if (name.equals("comment")) {
                    this.in_comment = true;
                } else if (name.equals("application")) {
                    int i = 0;
                    int len = attributes.getLength();
                    while (i < len) {
                        String attr = attributes.getName(i);
                        if (attr.equals("name")) {
                            String appName = attributes.getValue(i);
                            this.currentApp = (SqlApp)XmlSchema.this.appMap.get(appName);
                            if (this.currentApp != null) break;
                            this.currentApp = new SqlApp();
                            XmlSchema.this.appMap.put(appName.intern(), this.currentApp);
                            break;
                        }
                        ++i;
                    }
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.in_comment && this.in_statement) {
                this.charBuff.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String name) {
            if (name.equals("statement")) {
                String stmtStr = this.charBuff.toString().trim();
                if (this.state == 0) {
                    XmlSchema.this.createStmts.add(stmtStr);
                } else if (this.state == 1) {
                    XmlSchema.this.dropStmts.add(stmtStr);
                } else if (this.currentApp != null && this.currentStmtName != null) {
                    this.currentApp.setStatementText(this.currentStmtName, stmtStr);
                }
            } else if (name.equals("create") || name.equals("drop")) {
                this.state = -1;
            } else if (name.equals("comment")) {
                this.in_comment = false;
            } else if (name.equals("application")) {
                this.currentApp = null;
            }
        }

        @Override
        public void warning(SAXParseException ex) {
            System.err.println("[Warning] " + ex.getMessage());
        }

        @Override
        public void error(SAXParseException ex) {
            System.err.println("[Error] " + ex.getMessage());
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            System.err.println("[Fatal Error] " + ex.getMessage());
            throw ex;
        }
    }

    class SqlApp {
        Map stmtMap = new HashMap();

        SqlApp() {
        }

        public void setStatementText(String name, String sql) {
            this.stmtMap.put(name, sql);
        }

        public String getStatementText(String name) {
            return (String)this.stmtMap.get(name);
        }
    }
}

