/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.db.sql.schemarep;

import com.mchange.v1.db.sql.schemarep.ColumnRep;
import com.mchange.v1.db.sql.schemarep.TableRep;
import com.mchange.v1.util.ListUtils;
import com.mchange.v1.util.MapUtils;
import com.mchange.v1.util.SetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableRepImpl
implements TableRep {
    String tableName;
    List colNameList;
    Map namesToColReps;
    Set primaryKeyColNames;
    Set foreignKeyReps;
    Set uniqConstrReps;

    public TableRepImpl(String tableName, List colReps, Collection primaryKeyColNames, Collection foreignKeyReps, Collection uniqConstrReps) {
        this.tableName = tableName;
        ArrayList<String> tempColNameList = new ArrayList<String>();
        HashMap<String, ColumnRep> tempNamesToColReps = new HashMap<String, ColumnRep>();
        int i = 0;
        int len = colReps.size();
        while (i < len) {
            ColumnRep colRep = (ColumnRep)colReps.get(i);
            String colName = colRep.getColumnName();
            tempColNameList.add(colName);
            tempNamesToColReps.put(colName, colRep);
            ++i;
        }
        this.colNameList = Collections.unmodifiableList(tempColNameList);
        this.namesToColReps = Collections.unmodifiableMap(tempNamesToColReps);
        this.primaryKeyColNames = primaryKeyColNames == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(primaryKeyColNames));
        this.foreignKeyReps = foreignKeyReps == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(foreignKeyReps));
        this.uniqConstrReps = uniqConstrReps == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(uniqConstrReps));
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Iterator getColumnNames() {
        return this.colNameList.iterator();
    }

    @Override
    public ColumnRep columnRepForName(String name) {
        return (ColumnRep)this.namesToColReps.get(name);
    }

    @Override
    public Set getPrimaryKeyColumnNames() {
        return this.primaryKeyColNames;
    }

    @Override
    public Set getForeignKeyReps() {
        return this.foreignKeyReps;
    }

    @Override
    public Set getUniquenessConstraintReps() {
        return this.uniqConstrReps;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableRepImpl other = (TableRepImpl)o;
        return this.tableName.equals(other.tableName) && ListUtils.equivalent(this.colNameList, other.colNameList) && MapUtils.equivalentDisregardingSort(this.namesToColReps, other.namesToColReps) && SetUtils.equivalentDisregardingSort(this.primaryKeyColNames, other.primaryKeyColNames) && SetUtils.equivalentDisregardingSort(this.foreignKeyReps, other.foreignKeyReps) && SetUtils.equivalentDisregardingSort(this.uniqConstrReps, other.uniqConstrReps);
    }

    public int hashCode() {
        return this.tableName.hashCode() ^ ListUtils.hashContents(this.colNameList) ^ MapUtils.hashContentsDisregardingSort(this.namesToColReps) ^ SetUtils.hashContentsDisregardingSort(this.primaryKeyColNames) ^ SetUtils.hashContentsDisregardingSort(this.foreignKeyReps) ^ SetUtils.hashContentsDisregardingSort(this.uniqConstrReps);
    }
}

