/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.identicator;

import com.mchange.v1.identicator.IdHashKey;
import com.mchange.v1.identicator.Identicator;
import com.mchange.v1.identicator.StrongIdHashKey;
import com.mchange.v1.util.IteratorUtils;
import com.mchange.v1.util.ListUtils;
import com.mchange.v1.util.WrapperIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class IdList
implements List {
    Identicator id;
    List inner;

    public IdList(Identicator id, List inner) {
        this.id = id;
        this.inner = inner;
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        new StrongIdHashKey(o, this.id);
        return this.inner.contains(o);
    }

    @Override
    public Iterator iterator() {
        return new WrapperIterator(this.inner.iterator(), true){

            @Override
            protected Object transformObject(Object o) {
                if (o instanceof IdHashKey) {
                    IdHashKey ik = (IdHashKey)o;
                    return ik.getKeyObj();
                }
                return o;
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public Object[] toArray(Object[] space) {
        return IteratorUtils.toArray(this.iterator(), this.size(), space);
    }

    @Override
    public boolean add(Object o) {
        return this.inner.add(new StrongIdHashKey(o, this.id));
    }

    @Override
    public boolean remove(Object o) {
        return this.inner.remove(new StrongIdHashKey(o, this.id));
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator ii = c.iterator();
        while (ii.hasNext()) {
            StrongIdHashKey test = new StrongIdHashKey(ii.next(), this.id);
            if (this.inner.contains(test)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        Iterator ii = c.iterator();
        boolean changed = false;
        while (ii.hasNext()) {
            StrongIdHashKey ik = new StrongIdHashKey(ii.next(), this.id);
            changed |= this.inner.add(ik);
        }
        return changed;
    }

    public boolean addAll(int i, Collection c) {
        Iterator ii = c.iterator();
        while (ii.hasNext()) {
            StrongIdHashKey ik = new StrongIdHashKey(ii.next(), this.id);
            this.inner.add(i, ik);
            ++i;
        }
        return c.size() > 0;
    }

    @Override
    public boolean removeAll(Collection c) {
        Iterator ii = c.iterator();
        boolean changed = false;
        while (ii.hasNext()) {
            StrongIdHashKey ik = new StrongIdHashKey(ii.next(), this.id);
            changed |= this.inner.remove(ik);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection c) {
        Iterator ii = this.inner.iterator();
        boolean changed = false;
        while (ii.hasNext()) {
            IdHashKey ours = (IdHashKey)ii.next();
            if (c.contains(ours.getKeyObj())) continue;
            this.inner.remove(ours);
            changed = true;
        }
        return changed;
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof List) {
            return ListUtils.equivalent(this, (List)o);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ListUtils.hashContents(this);
    }

    public Object get(int i) {
        return ((IdHashKey)this.inner.get(i)).getKeyObj();
    }

    public Object set(int i, Object o) {
        IdHashKey ik = this.inner.set(i, new StrongIdHashKey(o, this.id));
        return ik.getKeyObj();
    }

    public void add(int i, Object o) {
        this.inner.add(i, new StrongIdHashKey(o, this.id));
    }

    public Object remove(int i) {
        IdHashKey ik = (IdHashKey)this.inner.remove(i);
        return ik == null ? null : ik.getKeyObj();
    }

    @Override
    public int indexOf(Object o) {
        return this.inner.indexOf(new StrongIdHashKey(o, this.id));
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.inner.lastIndexOf(new StrongIdHashKey(o, this.id));
    }

    public ListIterator listIterator() {
        return new LinkedList(this).listIterator();
    }

    public ListIterator listIterator(int i) {
        return new LinkedList(this).listIterator(i);
    }

    public List subList(int a, int b) {
        return new IdList(this.id, this.inner.subList(a, b));
    }
}

