/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.jvm;

import com.mchange.v1.jvm.TypeFormatException;

public final class InternalNameUtils {
    public static String dottifySlashesAndDollarSigns(String str) {
        return InternalNameUtils._dottifySlashesAndDollarSigns(str).toString();
    }

    public static String decodeType(String internalrep) throws TypeFormatException {
        return InternalNameUtils._decodeType(internalrep).toString();
    }

    public static String decodeTypeList(String internalrep) throws TypeFormatException {
        StringBuffer sb = new StringBuffer(64);
        InternalNameUtils._decodeTypeList(internalrep, 0, sb);
        return sb.toString();
    }

    public static boolean isPrimitive(char rep) {
        return rep == 'Z' || rep == 'B' || rep == 'C' || rep == 'S' || rep == 'I' || rep == 'J' || rep == 'F' || rep == 'D' || rep == 'V';
    }

    private static void _decodeTypeList(String typeList, int start_pos, StringBuffer appendTo) throws TypeFormatException {
        char c;
        if (appendTo.length() != 0) {
            appendTo.append(' ');
        }
        if (InternalNameUtils.isPrimitive(c = typeList.charAt(start_pos))) {
            appendTo.append(InternalNameUtils._decodeType(typeList.substring(start_pos, start_pos + 1)));
            ++start_pos;
        } else {
            int stop_index;
            if (c == '[') {
                int finger = start_pos + 1;
                while (typeList.charAt(finger) == '[') {
                    ++finger;
                }
                if (typeList.charAt(finger) == 'L') {
                    ++finger;
                    while (typeList.charAt(finger) != ';') {
                        ++finger;
                    }
                }
                stop_index = finger;
            } else {
                stop_index = typeList.indexOf(59, start_pos);
                if (stop_index < 0) {
                    throw new TypeFormatException(String.valueOf(typeList.substring(start_pos)) + " is neither a primitive nor semicolon terminated!");
                }
            }
            int n = start_pos;
            start_pos = stop_index + 1;
            appendTo.append(InternalNameUtils._decodeType(typeList.substring(n, start_pos)));
        }
        if (start_pos < typeList.length()) {
            appendTo.append(',');
            InternalNameUtils._decodeTypeList(typeList, start_pos, appendTo);
        }
    }

    private static StringBuffer _decodeType(String type) throws TypeFormatException {
        int array_level = 0;
        char c = type.charAt(0);
        StringBuffer out = switch (c) {
            case 'Z' -> new StringBuffer("boolean");
            case 'B' -> new StringBuffer("byte");
            case 'C' -> new StringBuffer("char");
            case 'S' -> new StringBuffer("short");
            case 'I' -> new StringBuffer("int");
            case 'J' -> new StringBuffer("long");
            case 'F' -> new StringBuffer("float");
            case 'D' -> new StringBuffer("double");
            case 'V' -> new StringBuffer("void");
            case '[' -> {
                ++array_level;
                yield InternalNameUtils._decodeType(type.substring(1));
            }
            case 'L' -> InternalNameUtils._decodeSimpleClassType(type);
            default -> throw new TypeFormatException(String.valueOf(type) + " is not a valid inernal type name.");
        };
        int i = 0;
        while (i < array_level) {
            out.append("[]");
            ++i;
        }
        return out;
    }

    private static StringBuffer _decodeSimpleClassType(String type) throws TypeFormatException {
        int len = type.length();
        if (type.charAt(0) != 'L' || type.charAt(len - 1) != ';') {
            throw new TypeFormatException(String.valueOf(type) + " is not a valid representation of a simple class type.");
        }
        return InternalNameUtils._dottifySlashesAndDollarSigns(type.substring(1, len - 1));
    }

    private static StringBuffer _dottifySlashesAndDollarSigns(String s) {
        StringBuffer sb = new StringBuffer(s);
        int i = 0;
        int len = sb.length();
        while (i < len) {
            char c = sb.charAt(i);
            if (c == '/' || c == '$') {
                sb.setCharAt(i, '.');
            }
            ++i;
        }
        return sb;
    }

    private InternalNameUtils() {
    }

    public static void main(String[] argv) {
        try {
            System.out.println(InternalNameUtils.decodeTypeList(argv[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

