/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.lang;

import com.mchange.v1.lang.AmbiguousClassNameException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ClassUtils {
    static final String[] EMPTY_SA = new String[0];
    static Map primitivesToClasses;

    static {
        HashMap<String, Class<Object>> tmp = new HashMap<String, Class<Object>>();
        tmp.put("boolean", Boolean.TYPE);
        tmp.put("int", Integer.TYPE);
        tmp.put("char", Character.TYPE);
        tmp.put("short", Short.TYPE);
        tmp.put("int", Integer.TYPE);
        tmp.put("long", Long.TYPE);
        tmp.put("float", Float.TYPE);
        tmp.put("double", Double.TYPE);
        tmp.put("void", Void.TYPE);
        primitivesToClasses = Collections.unmodifiableMap(tmp);
    }

    public static Set publicSupertypesForMethods(Class cl, Method[] methods) {
        Set testClasses = ClassUtils.allAssignableFrom(cl);
        HashSet<Class> out = new HashSet<Class>();
        for (Class check : testClasses) {
            if (!ClassUtils.isPublic(check) || !ClassUtils.hasAllMethodsAsSupertype(check, methods)) continue;
            out.add(check);
        }
        return Collections.unmodifiableSet(out);
    }

    public static boolean isPublic(Class cl) {
        return (cl.getModifiers() & 1) != 0;
    }

    public static boolean hasAllMethodsAsSupertype(Class cl, Method[] methods) {
        return ClassUtils.hasAllMethods(cl, methods, true);
    }

    public static boolean hasAllMethodsAsSubtype(Class cl, Method[] methods) {
        return ClassUtils.hasAllMethods(cl, methods, false);
    }

    private static boolean hasAllMethods(Class cl, Method[] methods, boolean cl_as_supertype) {
        int i = 0;
        int len = methods.length;
        while (i < len) {
            if (!ClassUtils.containsMethod(cl, methods[i], cl_as_supertype)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsMethodAsSupertype(Class cl, Method m) {
        return ClassUtils.containsMethod(cl, m, true);
    }

    public static boolean containsMethodAsSubtype(Class cl, Method m) {
        return ClassUtils.containsMethod(cl, m, false);
    }

    private static boolean containsMethod(Class cl, Method m, boolean cl_as_supertype) {
        try {
            Method check = cl.getMethod(m.getName(), m.getParameterTypes());
            Class<?> mRetType = m.getReturnType();
            Class<?> clRetType = check.getReturnType();
            return mRetType.equals(clRetType) || cl_as_supertype && clRetType.isAssignableFrom(mRetType) || !cl_as_supertype && mRetType.isAssignableFrom(clRetType);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public static Set allAssignableFrom(Class type) {
        HashSet out = new HashSet();
        Class cl = type;
        while (cl != null) {
            out.add(cl);
            cl = cl.getSuperclass();
        }
        ClassUtils.addSuperInterfacesToSet(type, out);
        return out;
    }

    public static String simpleClassName(Class cl) {
        int array_level = 0;
        while (cl.isArray()) {
            ++array_level;
            cl = cl.getComponentType();
        }
        String scn = ClassUtils.simpleClassName(cl.getName());
        if (array_level > 0) {
            StringBuffer sb = new StringBuffer(16);
            sb.append(scn);
            int i = 0;
            while (i < array_level) {
                sb.append("[]");
                ++i;
            }
            return sb.toString();
        }
        return scn;
    }

    private static String simpleClassName(String fqcn) {
        int pkgdot = fqcn.lastIndexOf(46);
        if (pkgdot < 0) {
            return fqcn;
        }
        String scn = fqcn.substring(pkgdot + 1);
        if (scn.indexOf(36) >= 0) {
            StringBuffer sb = new StringBuffer(scn);
            int i = 0;
            int len = sb.length();
            while (i < len) {
                if (sb.charAt(i) == '$') {
                    sb.setCharAt(i, '.');
                }
                ++i;
            }
            return sb.toString();
        }
        return scn;
    }

    public static boolean isPrimitive(String typeStr) {
        return primitivesToClasses.get(typeStr) != null;
    }

    public static Class classForPrimitive(String typeStr) {
        return (Class)primitivesToClasses.get(typeStr);
    }

    public static Class forName(String fqcnOrPrimitive) throws ClassNotFoundException {
        Class<?> out = ClassUtils.classForPrimitive(fqcnOrPrimitive);
        if (out == null) {
            out = Class.forName(fqcnOrPrimitive);
        }
        return out;
    }

    public static Class forName(String fqOrSimple, String[] importPkgs, String[] importClasses) throws AmbiguousClassNameException, ClassNotFoundException {
        try {
            return Class.forName(fqOrSimple);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return ClassUtils.classForSimpleName(fqOrSimple, importPkgs, importClasses);
        }
    }

    public static Class classForSimpleName(String simpleName, String[] importPkgs, String[] importClasses) throws AmbiguousClassNameException, ClassNotFoundException {
        HashSet<String> checkSet = new HashSet<String>();
        Class<?> out = ClassUtils.classForPrimitive(simpleName);
        if (out == null) {
            if (importPkgs == null) {
                importPkgs = EMPTY_SA;
            }
            if (importClasses == null) {
                importClasses = EMPTY_SA;
            }
            int i = 0;
            int len = importClasses.length;
            while (i < len) {
                String importSimpleName = ClassUtils.fqcnLastElement(importClasses[i]);
                if (!checkSet.add(importSimpleName)) {
                    throw new IllegalArgumentException("Duplicate imported classes: " + importSimpleName);
                }
                if (simpleName.equals(importSimpleName)) {
                    out = Class.forName(importClasses[i]);
                }
                ++i;
            }
            if (out == null) {
                try {
                    out = Class.forName("java.lang." + simpleName);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                i = 0;
                len = importPkgs.length;
                while (i < len) {
                    block14: {
                        try {
                            String tryClass = String.valueOf(importPkgs[i]) + '.' + simpleName;
                            Class<?> test = Class.forName(tryClass);
                            if (out == null) {
                                out = test;
                                break block14;
                            }
                            throw new AmbiguousClassNameException(simpleName, out, test);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    ++i;
                }
            }
        }
        if (out == null) {
            throw new ClassNotFoundException("Could not find a class whose unqualified name is \"" + simpleName + "\" with the imports supplied. Import packages are " + Arrays.asList(importPkgs) + "; class imports are " + Arrays.asList(importClasses));
        }
        return out;
    }

    public static String resolvableTypeName(Class type, String[] importPkgs, String[] importClasses) throws ClassNotFoundException {
        String simpleName = ClassUtils.simpleClassName(type);
        try {
            ClassUtils.classForSimpleName(simpleName, importPkgs, importClasses);
        }
        catch (AmbiguousClassNameException ambiguousClassNameException) {
            return type.getName();
        }
        return simpleName;
    }

    public static String fqcnLastElement(String fqcn) {
        int pkgdot = fqcn.lastIndexOf(46);
        if (pkgdot < 0) {
            return fqcn;
        }
        return fqcn.substring(pkgdot + 1);
    }

    private static void addSuperInterfacesToSet(Class type, Set set) {
        Class<?>[] ifaces = type.getInterfaces();
        int i = 0;
        int len = ifaces.length;
        while (i < len) {
            set.add(ifaces[i]);
            ClassUtils.addSuperInterfacesToSet(ifaces[i], set);
            ++i;
        }
    }

    private ClassUtils() {
    }
}

