/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.util;

import com.mchange.v1.util.BrokenObjectException;
import com.mchange.v1.util.RunnableQueue;
import com.mchange.v1.util.SimpleRunnableQueue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class AbstractResourcePool {
    private static final boolean TRACE = true;
    private static final boolean DEBUG = true;
    private static RunnableQueue sharedQueue = new SimpleRunnableQueue();
    Set managed = new HashSet();
    List unused = new LinkedList();
    int start;
    int max;
    int inc;
    int num_acq_attempts = Integer.MAX_VALUE;
    int acq_attempt_delay = 50;
    RunnableQueue rq;
    boolean initted = false;
    boolean broken = false;

    protected AbstractResourcePool(int start, int max, int inc) {
        this(start, max, inc, sharedQueue);
    }

    protected AbstractResourcePool(int start, int max, int inc, RunnableQueue rq) {
        this.start = start;
        this.max = max;
        this.inc = inc;
        this.rq = rq;
    }

    protected abstract Object acquireResource() throws Exception;

    protected abstract void refurbishResource(Object var1) throws BrokenObjectException;

    protected abstract void destroyResource(Object var1) throws Exception;

    protected synchronized void init() throws Exception {
        int i = 0;
        while (i < this.start) {
            this.assimilateResource();
            ++i;
        }
        this.initted = true;
    }

    protected Object checkoutResource() throws BrokenObjectException, InterruptedException, Exception {
        return this.checkoutResource(0L);
    }

    protected synchronized Object checkoutResource(long timeout) throws BrokenObjectException, InterruptedException, TimeoutException, Exception {
        if (!this.initted) {
            this.init();
        }
        this.ensureNotBroken();
        int sz = this.unused.size();
        if (sz == 0) {
            int msz = this.managed.size();
            if (msz < this.max) {
                this.postAcquireMore();
            }
            this.awaitAvailable(timeout);
        }
        Object resc = this.unused.get(0);
        this.unused.remove(0);
        try {
            this.refurbishResource(resc);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.removeResource(resc);
            return this.checkoutResource(timeout);
        }
        this.trace();
        return resc;
    }

    protected synchronized void checkinResource(Object resc) throws BrokenObjectException {
        if (!this.managed.contains(resc)) {
            throw new IllegalArgumentException("ResourcePool: Tried to check-in a foreign resource!");
        }
        this.unused.add(resc);
        this.notifyAll();
        this.trace();
    }

    protected synchronized void markBad(Object resc) throws Exception {
        this.removeResource(resc);
    }

    protected synchronized void close() throws Exception {
        this.broken = true;
        Iterator ii = this.managed.iterator();
        while (ii.hasNext()) {
            try {
                this.removeResource(ii.next());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void postAcquireMore() throws InterruptedException {
        this.rq.postRunnable(new AcquireTask());
    }

    private void awaitAvailable(long timeout) throws InterruptedException, TimeoutException {
        int avail;
        while ((avail = this.unused.size()) == 0) {
            this.wait(timeout);
        }
        if (avail == 0) {
            throw new TimeoutException();
        }
    }

    private void acquireMore() throws Exception {
        int msz = this.managed.size();
        int i = 0;
        while (i < Math.min(this.inc, this.max - msz)) {
            this.assimilateResource();
            ++i;
        }
    }

    private void assimilateResource() throws Exception {
        Object resc = this.acquireResource();
        this.managed.add(resc);
        this.unused.add(resc);
        this.notifyAll();
        this.trace();
    }

    private void removeResource(Object resc) throws Exception {
        this.managed.remove(resc);
        this.unused.remove(resc);
        this.destroyResource(resc);
        this.trace();
    }

    private void ensureNotBroken() throws BrokenObjectException {
        if (this.broken) {
            throw new BrokenObjectException(this);
        }
    }

    private synchronized void unexpectedBreak() {
        this.broken = true;
        Iterator ii = this.unused.iterator();
        while (ii.hasNext()) {
            try {
                this.removeResource(ii.next());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void trace() {
        System.err.println(this + "  [managed: " + this.managed.size() + ", " + "unused: " + this.unused.size() + ']');
    }

    class AcquireTask
    implements Runnable {
        boolean success = false;

        AcquireTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int i = 0;
            while (!this.success && i < AbstractResourcePool.this.num_acq_attempts) {
                try {
                    if (i > 0) {
                        Thread.sleep(AbstractResourcePool.this.acq_attempt_delay);
                    }
                    AbstractResourcePool abstractResourcePool = AbstractResourcePool.this;
                    synchronized (abstractResourcePool) {
                        AbstractResourcePool.this.acquireMore();
                    }
                    this.success = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            if (!this.success) {
                AbstractResourcePool.this.unexpectedBreak();
            }
        }
    }

    protected class TimeoutException
    extends Exception {
        protected TimeoutException() {
        }
    }
}

