/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.util;

import com.mchange.v2.lang.ObjectUtils;

public final class ArrayUtils {
    public static int indexOf(Object[] array, Object o) {
        int i = 0;
        int len = array.length;
        while (i < len) {
            if (o.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int identityIndexOf(Object[] array, Object o) {
        int i = 0;
        int len = array.length;
        while (i < len) {
            if (o == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean startsWith(byte[] checkMe, byte[] maybePrefix) {
        int cm_len = checkMe.length;
        int mp_len = maybePrefix.length;
        if (cm_len < mp_len) {
            return false;
        }
        int i = 0;
        while (i < mp_len) {
            if (checkMe[i] != maybePrefix[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int hashArray(Object[] oo) {
        int len;
        int out = len = oo.length;
        int i = 0;
        while (i < len) {
            int elem_hash = ObjectUtils.hashOrZero(oo[i]);
            int rot = i % 32;
            int rot_hash = elem_hash >>> rot;
            out ^= (rot_hash |= elem_hash << 32 - rot);
            ++i;
        }
        return out;
    }

    public static int hashArray(int[] ii) {
        int len;
        int out = len = ii.length;
        int i = 0;
        while (i < len) {
            int elem_hash = ii[i];
            int rot = i % 32;
            int rot_hash = elem_hash >>> rot;
            out ^= (rot_hash |= elem_hash << 32 - rot);
            ++i;
        }
        return out;
    }

    public static int hashOrZeroArray(Object[] oo) {
        return oo == null ? 0 : ArrayUtils.hashArray(oo);
    }

    public static int hashOrZeroArray(int[] ii) {
        return ii == null ? 0 : ArrayUtils.hashArray(ii);
    }

    public static String stringifyContents(Object[] array) {
        StringBuffer sb = new StringBuffer();
        sb.append("[ ");
        int i = 0;
        int len = array.length;
        while (i < len) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(array[i].toString());
            ++i;
        }
        sb.append(" ]");
        return sb.toString();
    }

    private static String toString(String[] strings, int guessed_len) {
        StringBuffer sb = new StringBuffer(guessed_len);
        boolean first = true;
        sb.append('[');
        int i = 0;
        int len = strings.length;
        while (i < len) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(strings[i]);
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(boolean[] arr) {
        String[] strings = new String[arr.length];
        int chars = 0;
        int i = 0;
        int len = arr.length;
        while (i < len) {
            String str = String.valueOf(arr[i]);
            chars += str.length();
            strings[i] = str;
            ++i;
        }
        return ArrayUtils.toString(strings, chars + arr.length + 1);
    }

    public static String toString(byte[] arr) {
        String[] strings = new String[arr.length];
        int chars = 0;
        int i = 0;
        int len = arr.length;
        while (i < len) {
            String str = String.valueOf(arr[i]);
            chars += str.length();
            strings[i] = str;
            ++i;
        }
        return ArrayUtils.toString(strings, chars + arr.length + 1);
    }

    public static String toString(char[] arr) {
        String[] strings = new String[arr.length];
        int chars = 0;
        int i = 0;
        int len = arr.length;
        while (i < len) {
            String str = String.valueOf(arr[i]);
            chars += str.length();
            strings[i] = str;
            ++i;
        }
        return ArrayUtils.toString(strings, chars + arr.length + 1);
    }

    public static String toString(short[] arr) {
        String[] strings = new String[arr.length];
        int chars = 0;
        int i = 0;
        int len = arr.length;
        while (i < len) {
            String str = String.valueOf(arr[i]);
            chars += str.length();
            strings[i] = str;
            ++i;
        }
        return ArrayUtils.toString(strings, chars + arr.length + 1);
    }

    public static String toString(int[] arr) {
        String[] strings = new String[arr.length];
        int chars = 0;
        int i = 0;
        int len = arr.length;
        while (i < len) {
            String str = String.valueOf(arr[i]);
            chars += str.length();
            strings[i] = str;
            ++i;
        }
        return ArrayUtils.toString(strings, chars + arr.length + 1);
    }

    public static String toString(long[] arr) {
        String[] strings = new String[arr.length];
        int chars = 0;
        int i = 0;
        int len = arr.length;
        while (i < len) {
            String str = String.valueOf(arr[i]);
            chars += str.length();
            strings[i] = str;
            ++i;
        }
        return ArrayUtils.toString(strings, chars + arr.length + 1);
    }

    public static String toString(float[] arr) {
        String[] strings = new String[arr.length];
        int chars = 0;
        int i = 0;
        int len = arr.length;
        while (i < len) {
            String str = String.valueOf(arr[i]);
            chars += str.length();
            strings[i] = str;
            ++i;
        }
        return ArrayUtils.toString(strings, chars + arr.length + 1);
    }

    public static String toString(double[] arr) {
        String[] strings = new String[arr.length];
        int chars = 0;
        int i = 0;
        int len = arr.length;
        while (i < len) {
            String str = String.valueOf(arr[i]);
            chars += str.length();
            strings[i] = str;
            ++i;
        }
        return ArrayUtils.toString(strings, chars + arr.length + 1);
    }

    public static String toString(Object[] arr) {
        String[] strings = new String[arr.length];
        int chars = 0;
        int i = 0;
        int len = arr.length;
        while (i < len) {
            Object o = arr[i];
            String str = o instanceof Object[] ? ArrayUtils.toString((Object[])o) : (o instanceof double[] ? ArrayUtils.toString((double[])o) : (o instanceof float[] ? ArrayUtils.toString((float[])o) : (o instanceof long[] ? ArrayUtils.toString((long[])o) : (o instanceof int[] ? ArrayUtils.toString((int[])o) : (o instanceof short[] ? ArrayUtils.toString((short[])o) : (o instanceof char[] ? ArrayUtils.toString((char[])o) : (o instanceof byte[] ? ArrayUtils.toString((byte[])o) : (o instanceof boolean[] ? ArrayUtils.toString((boolean[])o) : String.valueOf(arr[i])))))))));
            chars += str.length();
            strings[i] = str;
            ++i;
        }
        return ArrayUtils.toString(strings, chars + arr.length + 1);
    }

    private ArrayUtils() {
    }
}

