/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IteratorUtils {
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };

    public static Iterator oneElementUnmodifiableIterator(final Object elem) {
        return new Iterator(){
            boolean shot = false;

            @Override
            public boolean hasNext() {
                return !this.shot;
            }

            public Object next() {
                if (this.shot) {
                    throw new NoSuchElementException();
                }
                this.shot = true;
                return elem;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported.");
            }
        };
    }

    public static boolean equivalent(Iterator ii, Iterator jj) {
        block3: {
            while (true) {
                Object jjNext;
                boolean jj_hasnext;
                boolean ii_hasnext;
                if ((ii_hasnext = ii.hasNext()) ^ (jj_hasnext = jj.hasNext())) {
                    return false;
                }
                if (!ii_hasnext) break block3;
                Object iiNext = ii.next();
                if (iiNext == (jjNext = jj.next())) continue;
                if (iiNext == null) {
                    return false;
                }
                if (!iiNext.equals(jjNext)) break;
            }
            return false;
        }
        return true;
    }

    public static ArrayList toArrayList(Iterator ii, int initial_capacity) {
        ArrayList out = new ArrayList(initial_capacity);
        while (ii.hasNext()) {
            out.add(ii.next());
        }
        return out;
    }

    public static void fillArray(Iterator ii, Object[] fillMe, boolean null_terminate) {
        int i = 0;
        int len = fillMe.length;
        while (i < len && ii.hasNext()) {
            fillMe[i++] = ii.next();
        }
        if (null_terminate && i < len) {
            fillMe[i] = null;
        }
    }

    public static void fillArray(Iterator ii, Object[] fillMe) {
        IteratorUtils.fillArray(ii, fillMe, false);
    }

    public static Object[] toArray(Iterator ii, int array_size, Class componentClass, boolean null_terminate) {
        Object[] out = (Object[])Array.newInstance(componentClass, array_size);
        IteratorUtils.fillArray(ii, out, null_terminate);
        return out;
    }

    public static Object[] toArray(Iterator ii, int array_size, Class componentClass) {
        return IteratorUtils.toArray(ii, array_size, componentClass, false);
    }

    public static Object[] toArray(Iterator ii, int ii_size, Object[] maybeFillMe) {
        if (maybeFillMe.length >= ii_size) {
            IteratorUtils.fillArray(ii, maybeFillMe, true);
            return maybeFillMe;
        }
        Class<?> componentType = maybeFillMe.getClass().getComponentType();
        return IteratorUtils.toArray(ii, ii_size, componentType);
    }

    private IteratorUtils() {
    }
}

