/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.util;

import com.mchange.v1.util.IteratorUtils;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

public final class ListUtils {
    public static List oneElementUnmodifiableList(final Object elem) {
        return new AbstractList(){

            @Override
            public Iterator iterator() {
                return IteratorUtils.oneElementUnmodifiableIterator(elem);
            }

            @Override
            public int size() {
                return 1;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object o) {
                return o == elem;
            }

            @Override
            public Object get(int index) {
                if (index != 0) {
                    throw new IndexOutOfBoundsException("One element list has no element index " + index);
                }
                return elem;
            }
        };
    }

    public static boolean equivalent(List a, List b) {
        if (a.size() != b.size()) {
            return false;
        }
        Iterator ii = a.iterator();
        Iterator jj = b.iterator();
        return IteratorUtils.equivalent(ii, jj);
    }

    public static int hashContents(List l) {
        int out = 0;
        int count = 0;
        for (Object o : l) {
            if (o != null) {
                out ^= o.hashCode() ^ count;
            }
            ++count;
        }
        return out;
    }
}

