/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.util;

import com.mchange.v1.util.IteratorUtils;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class SetUtils {
    public static Set oneElementUnmodifiableSet(final Object elem) {
        return new AbstractSet(){

            @Override
            public Iterator iterator() {
                return IteratorUtils.oneElementUnmodifiableIterator(elem);
            }

            @Override
            public int size() {
                return 1;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean contains(Object o) {
                return o == elem;
            }
        };
    }

    public static Set setFromArray(Object[] array) {
        HashSet<Object> out = new HashSet<Object>();
        int i = 0;
        int len = array.length;
        while (i < len) {
            out.add(array[i]);
            ++i;
        }
        return out;
    }

    public static boolean equivalentDisregardingSort(Set a, Set b) {
        return a.containsAll(b) && b.containsAll(a);
    }

    public static int hashContentsDisregardingSort(Set s) {
        int out = 0;
        for (Object o : s) {
            if (o == null) continue;
            out ^= o.hashCode();
        }
        return out;
    }
}

