/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.xml;

import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ResourceEntityResolver
implements EntityResolver {
    ClassLoader cl;
    String prefix;

    public ResourceEntityResolver(ClassLoader cl, String rsrcPrefix) {
        this.cl = cl;
        this.prefix = rsrcPrefix;
    }

    public ResourceEntityResolver(Class loadSibling) {
        this(loadSibling.getClassLoader(), ResourceEntityResolver.classToPrefix(loadSibling));
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId == null) {
            return null;
        }
        int last_slash = systemId.lastIndexOf(47);
        String systemIdFilePart = last_slash >= 0 ? systemId.substring(last_slash + 1) : systemId;
        InputStream is = this.cl.getResourceAsStream(String.valueOf(this.prefix) + systemIdFilePart);
        return is == null ? null : new InputSource(is);
    }

    private static String classToPrefix(Class c) {
        String className = c.getName();
        int last_dot = className.lastIndexOf(46);
        String pkgName = last_dot > 0 ? className.substring(0, last_dot) : null;
        StringBuffer sb = new StringBuffer(256);
        if (pkgName != null) {
            sb.append(pkgName);
            int i = 0;
            int len = sb.length();
            while (i < len) {
                if (sb.charAt(i) == '.') {
                    sb.setCharAt(i, '/');
                }
                ++i;
            }
            sb.append('/');
        }
        return sb.toString();
    }
}

