/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.xmlprops;

import com.mchange.v1.xml.StdErrErrorHandler;
import com.mchange.v1.xmlprops.XmlPropsException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SaxXmlPropsParser {
    static final String DEFAULT_XML_READER = "org.apache.xerces.parsers.SAXParser";
    static final String XMLPROPS_NAMESPACE_URI = "http://www.mchange.com/namespaces/xmlprops";

    public static Properties parseXmlProps(InputStream istr) throws XmlPropsException {
        try {
            String readerClass = DEFAULT_XML_READER;
            XMLReader reader = (XMLReader)Class.forName(readerClass).newInstance();
            InputSource is = new InputSource(istr);
            return SaxXmlPropsParser.parseXmlProps(is, reader, null, null);
        }
        catch (XmlPropsException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XmlPropsException("Exception while instantiating XMLReader.", e);
        }
    }

    private static Properties parseXmlProps(InputSource is, XMLReader saxy, EntityResolver eresolv, ErrorHandler grrr) throws XmlPropsException {
        try {
            if (eresolv != null) {
                saxy.setEntityResolver(eresolv);
            }
            if (grrr == null) {
                grrr = new StdErrErrorHandler();
            }
            saxy.setErrorHandler(grrr);
            XmlPropsContentHandler fsch = new XmlPropsContentHandler();
            saxy.setContentHandler(fsch);
            saxy.parse(is);
            return fsch.getLastProperties();
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                ((SAXException)e).getException().printStackTrace();
            }
            e.printStackTrace();
            throw new XmlPropsException(e);
        }
    }

    public static void main(String[] argv) {
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(argv[0]));
            SaxXmlPropsParser parser = new SaxXmlPropsParser();
            Properties props = SaxXmlPropsParser.parseXmlProps(is);
            for (String string : props.keySet()) {
                String value = props.getProperty(string);
                System.err.println(String.valueOf(string) + '=' + value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class XmlPropsContentHandler
    implements ContentHandler {
        Locator locator;
        Properties props;
        String name;
        StringBuffer valueBuf;

        XmlPropsContentHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startDocument() throws SAXException {
            this.props = new Properties();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            System.err.println("--> startElement( " + namespaceURI + ", " + localName + ", " + atts + ")");
            if (!namespaceURI.equals("") && !namespaceURI.equals(SaxXmlPropsParser.XMLPROPS_NAMESPACE_URI)) {
                return;
            }
            if (localName.equals("property")) {
                this.name = atts.getValue(namespaceURI, "name");
                this.valueBuf = new StringBuffer();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.valueBuf != null) {
                this.valueBuf.append(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.valueBuf != null) {
                this.valueBuf.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (!namespaceURI.equals("") && !namespaceURI.equals(SaxXmlPropsParser.XMLPROPS_NAMESPACE_URI)) {
                return;
            }
            if (localName.equals("property")) {
                System.err.println("NAME: " + this.name);
                this.props.put(this.name, this.valueBuf.toString());
                this.valueBuf = null;
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        public Properties getLastProperties() {
            return this.props;
        }
    }
}

