/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.async;

import com.mchange.v2.async.Queuable;
import com.mchange.v2.async.RunnableQueue;
import java.util.LinkedList;
import java.util.List;

public class SimpleRunnableQueue
implements RunnableQueue,
Queuable {
    private List taskList = new LinkedList();
    private Thread t = new TaskThread();
    boolean gentle_close_requested = false;

    public SimpleRunnableQueue(boolean daemon) {
        this.t.setDaemon(daemon);
        this.t.start();
    }

    public SimpleRunnableQueue() {
        this(true);
    }

    @Override
    public RunnableQueue asRunnableQueue() {
        return this;
    }

    @Override
    public synchronized void postRunnable(Runnable r) {
        if (this.gentle_close_requested) {
            throw new IllegalStateException("Attempted to post a task to a closed AsynchronousRunner.");
        }
        this.taskList.add(r);
        this.notifyAll();
    }

    @Override
    public synchronized void close(boolean skip_remaining_tasks) {
        if (skip_remaining_tasks) {
            this.t.interrupt();
        } else {
            this.gentle_close_requested = true;
        }
    }

    @Override
    public synchronized void close() {
        this.close(true);
    }

    private synchronized Runnable dequeueRunnable() {
        Runnable r = (Runnable)this.taskList.get(0);
        this.taskList.remove(0);
        return r;
    }

    private synchronized void awaitTask() throws InterruptedException {
        while (this.taskList.size() == 0) {
            if (this.gentle_close_requested) {
                this.t.interrupt();
            }
            this.wait();
        }
    }

    class TaskThread
    extends Thread {
        TaskThread() {
            super("SimpleRunnableQueue.TaskThread");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        if (this.isInterrupted()) {
                            return;
                        }
                        SimpleRunnableQueue.this.awaitTask();
                        Runnable r = SimpleRunnableQueue.this.dequeueRunnable();
                        try {
                            r.run();
                        }
                        catch (Exception e) {
                            System.err.println(String.valueOf(this.getClass().getName()) + " -- Unexpected exception in task!");
                            e.printStackTrace();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    SimpleRunnableQueue.this.taskList = null;
                    SimpleRunnableQueue.this.t = null;
                    return;
                }
            }
            finally {
                SimpleRunnableQueue.this.taskList = null;
                SimpleRunnableQueue.this.t = null;
            }
        }
    }
}

