/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.beans;

import com.mchange.v2.lang.Coerce;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class BeansUtils {
    static final MLogger logger = MLog.getLogger(BeansUtils.class);
    static final Object[] EMPTY_ARGS = new Object[0];

    public static PropertyEditor findPropertyEditor(PropertyDescriptor pd) {
        PropertyEditor out;
        block4: {
            out = null;
            Class<?> editorClass = null;
            try {
                editorClass = pd.getPropertyEditorClass();
                if (editorClass != null) {
                    out = (PropertyEditor)editorClass.newInstance();
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(MLevel.WARNING)) break block4;
                logger.log(MLevel.WARNING, "Bad property editor class " + editorClass.getName() + " registered for property " + pd.getName(), e);
            }
        }
        if (out == null) {
            out = PropertyEditorManager.findEditor(pd.getPropertyType());
        }
        return out;
    }

    public static boolean equalsByAccessibleProperties(Object bean0, Object bean1) throws IntrospectionException {
        return BeansUtils.equalsByAccessibleProperties(bean0, bean1, Collections.EMPTY_SET);
    }

    public static boolean equalsByAccessibleProperties(Object bean0, Object bean1, Collection ignoreProps) throws IntrospectionException {
        HashMap m0 = new HashMap();
        HashMap m1 = new HashMap();
        BeansUtils.extractAccessiblePropertiesToMap(m0, bean0, ignoreProps);
        BeansUtils.extractAccessiblePropertiesToMap(m1, bean1, ignoreProps);
        return m0.equals(m1);
    }

    public static boolean equalsByAccessiblePropertiesVerbose(Object bean0, Object bean1, Collection ignoreProps) throws IntrospectionException {
        HashMap m0 = new HashMap();
        HashMap m1 = new HashMap();
        BeansUtils.extractAccessiblePropertiesToMap(m0, bean0, ignoreProps);
        BeansUtils.extractAccessiblePropertiesToMap(m1, bean1, ignoreProps);
        boolean out = true;
        if (m0.size() != m1.size()) {
            Iterator ii;
            System.err.println("Unequal sizes --> Map0: " + m0.size() + "; m1: " + m1.size());
            Set s0extras = m0.keySet();
            s0extras.removeAll(m1.keySet());
            Set s1extras = m1.keySet();
            s1extras.removeAll(m0.keySet());
            if (s0extras.size() > 0) {
                System.err.println("Map0 extras:");
                ii = s0extras.iterator();
                while (ii.hasNext()) {
                    System.err.println(String.valueOf('\t') + ii.next().toString());
                }
            }
            if (s1extras.size() > 0) {
                System.err.println("Map1 extras:");
                ii = s1extras.iterator();
                while (ii.hasNext()) {
                    System.err.println(String.valueOf('\t') + ii.next().toString());
                }
            }
            out = false;
        }
        for (String key : m0.keySet()) {
            Object val0 = m0.get(key);
            Object val1 = m1.get(key);
            if ((val0 != null || val1 == null) && (val0 == null || val0.equals(val1))) continue;
            System.err.println(String.valueOf('\t') + key + ": " + val0 + " != " + val1);
            out = false;
        }
        return out;
    }

    public static void overwriteAccessibleProperties(Object sourceBean, Object destBean) throws IntrospectionException {
        BeansUtils.overwriteAccessibleProperties(sourceBean, destBean, Collections.EMPTY_SET);
    }

    public static void overwriteAccessibleProperties(Object sourceBean, Object destBean, Collection ignoreProps) throws IntrospectionException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(sourceBean.getClass(), Object.class);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            int i = 0;
            int len = pds.length;
            while (i < len) {
                PropertyDescriptor pd = pds[i];
                if (!ignoreProps.contains(pd.getName())) {
                    Method getter = pd.getReadMethod();
                    Method setter = pd.getWriteMethod();
                    if (getter == null || setter == null) {
                        if (pd instanceof IndexedPropertyDescriptor && logger.isLoggable(MLevel.WARNING)) {
                            logger.warning("BeansUtils.overwriteAccessibleProperties() does not support indexed properties that do not provide single-valued array getters and setters! [The indexed methods provide no means of modifying the size of the array in the destination bean if it does not match the source.]");
                        }
                        if (logger.isLoggable(MLevel.INFO)) {
                            logger.info("Property inaccessible for overwriting: " + pd.getName());
                        }
                    } else {
                        Object value = getter.invoke(sourceBean, EMPTY_ARGS);
                        setter.invoke(destBean, value);
                    }
                }
                ++i;
            }
        }
        catch (IntrospectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "Converting exception to throwable IntrospectionException");
            }
            throw new IntrospectionException(e.getMessage());
        }
    }

    public static void overwriteAccessiblePropertiesFromMap(Map sourceMap, Object destBean, boolean skip_nulls) throws IntrospectionException {
        BeansUtils.overwriteAccessiblePropertiesFromMap(sourceMap, destBean, skip_nulls, Collections.EMPTY_SET);
    }

    public static void overwriteAccessiblePropertiesFromMap(Map sourceMap, Object destBean, boolean skip_nulls, Collection ignoreProps) throws IntrospectionException {
        BeansUtils.overwriteAccessiblePropertiesFromMap(sourceMap, destBean, skip_nulls, ignoreProps, false, MLevel.WARNING, MLevel.WARNING, true);
    }

    /*
     * Unable to fully structure code
     */
    public static void overwriteAccessiblePropertiesFromMap(Map sourceMap, Object destBean, boolean skip_nulls, Collection ignoreProps, boolean coerce_strings, MLevel cantWriteLevel, MLevel cantCoerceLevel, boolean die_on_one_prop_failure) throws IntrospectionException {
        if (cantWriteLevel == null) {
            cantWriteLevel = MLevel.WARNING;
        }
        if (cantCoerceLevel == null) {
            cantCoerceLevel = MLevel.WARNING;
        }
        sourceMapProps = sourceMap.keySet();
        propName = null;
        beanInfo = Introspector.getBeanInfo(destBean.getClass(), Object.class);
        pds = beanInfo.getPropertyDescriptors();
        i = 0;
        len = pds.length;
        while (i < len) {
            block19: {
                pd = pds[i];
                propName = pd.getName();
                if (!(!sourceMapProps.contains(propName) || ignoreProps != null && ignoreProps.contains(propName) || (propVal = sourceMap.get(propName)) == null && skip_nulls)) {
                    setter = pd.getWriteMethod();
                    propType = pd.getPropertyType();
                    if (setter == null) {
                        if (pd instanceof IndexedPropertyDescriptor && BeansUtils.logger.isLoggable(MLevel.FINER)) {
                            BeansUtils.logger.finer("BeansUtils.overwriteAccessiblePropertiesFromMap() does not support indexed properties that do not provide single-valued array getters and setters! [The indexed methods provide no means of modifying the size of the array in the destination bean if it does not match the source.]");
                        }
                        if (BeansUtils.logger.isLoggable(cantWriteLevel)) {
                            msg = "Property inaccessible for overwriting: " + propName;
                            BeansUtils.logger.log(cantWriteLevel, msg);
                            if (die_on_one_prop_failure) {
                                throw new IntrospectionException(msg);
                            }
                        }
                    } else if (coerce_strings && propVal != null && propVal.getClass() == String.class && (propType = pd.getPropertyType()) != String.class && Coerce.canCoerce(propType)) {
                        try {
                            coercedPropVal = Coerce.toObject((String)propVal, propType);
                            setter.invoke(destBean, new Object[]{coercedPropVal});
                        }
                        catch (IllegalArgumentException e) {
                            msg = "Failed to coerce property: " + propName + " [propVal: " + propVal + "; propType: " + propType + "]";
                            if (BeansUtils.logger.isLoggable(cantCoerceLevel)) {
                                BeansUtils.logger.log(cantCoerceLevel, msg, e);
                            }
                            if (!die_on_one_prop_failure) ** GOTO lbl54
                            throw new IntrospectionException(msg);
                        }
                        catch (Exception e) {
                            msg = "Failed to set property: " + propName + " [propVal: " + propVal + "; propType: " + propType + "]";
                            if (BeansUtils.logger.isLoggable(cantWriteLevel)) {
                                BeansUtils.logger.log(cantWriteLevel, msg, e);
                            }
                            if (!die_on_one_prop_failure) ** GOTO lbl54
                            throw new IntrospectionException(msg);
                        }
                    } else {
                        try {
                            setter.invoke(destBean, new Object[]{propVal});
                        }
                        catch (Exception e) {
                            msg = "Failed to set property: " + propName + " [propVal: " + propVal + "; propType: " + propType + "]";
                            if (BeansUtils.logger.isLoggable(cantWriteLevel)) {
                                BeansUtils.logger.log(cantWriteLevel, msg, e);
                            }
                            if (!die_on_one_prop_failure) break block19;
                            throw new IntrospectionException(msg);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public static void appendPropNamesAndValues(StringBuffer appendIntoMe, Object bean, Collection ignoreProps) throws IntrospectionException {
        TreeMap tmp = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        BeansUtils.extractAccessiblePropertiesToMap(tmp, bean, ignoreProps);
        boolean first = true;
        for (String key : tmp.keySet()) {
            Object val = tmp.get(key);
            if (first) {
                first = false;
            } else {
                appendIntoMe.append(", ");
            }
            appendIntoMe.append(key);
            appendIntoMe.append(" -> ");
            appendIntoMe.append(val);
        }
    }

    public static void extractAccessiblePropertiesToMap(Map fillMe, Object bean) throws IntrospectionException {
        BeansUtils.extractAccessiblePropertiesToMap(fillMe, bean, Collections.EMPTY_SET);
    }

    public static void extractAccessiblePropertiesToMap(Map fillMe, Object bean, Collection ignoreProps) throws IntrospectionException {
        String propName = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(bean.getClass(), Object.class);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            int i = 0;
            int len = pds.length;
            while (i < len) {
                PropertyDescriptor pd = pds[i];
                propName = pd.getName();
                if (!ignoreProps.contains(propName)) {
                    Method readMethod = pd.getReadMethod();
                    Object propVal = readMethod.invoke(bean, EMPTY_ARGS);
                    fillMe.put(propName, propVal);
                }
                ++i;
            }
        }
        catch (IntrospectionException e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("Problem occurred while overwriting property: " + propName);
            }
            if (logger.isLoggable(MLevel.FINE)) {
                logger.logp(MLevel.FINE, BeansUtils.class.getName(), "extractAccessiblePropertiesToMap( Map fillMe, Object bean, Collection ignoreProps )", String.valueOf(propName != null ? "Problem occurred while overwriting property: " + propName : "") + " throwing...", e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.logp(MLevel.FINE, BeansUtils.class.getName(), "extractAccessiblePropertiesToMap( Map fillMe, Object bean, Collection ignoreProps )", "Caught unexpected Exception; Converting to IntrospectionException.", e);
            }
            throw new IntrospectionException(String.valueOf(e.toString()) + (propName == null ? "" : " [" + propName + ']'));
        }
    }

    private static void overwriteProperty(String propName, Object value, Method putativeSetter, Object target) throws Exception {
        if (putativeSetter.getDeclaringClass().isAssignableFrom(target.getClass())) {
            putativeSetter.invoke(target, value);
        } else {
            BeanInfo beanInfo = Introspector.getBeanInfo(target.getClass(), Object.class);
            PropertyDescriptor pd = null;
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            int i = 0;
            int len = pds.length;
            while (i < len) {
                if (propName.equals(pds[i].getName())) {
                    pd = pds[i];
                    break;
                }
                ++i;
            }
            Method targetSetter = pd.getWriteMethod();
            targetSetter.invoke(target, value);
        }
    }

    public static void overwriteSpecificAccessibleProperties(Object sourceBean, Object destBean, Collection props) throws IntrospectionException {
        try {
            HashSet _props = new HashSet(props);
            BeanInfo beanInfo = Introspector.getBeanInfo(sourceBean.getClass(), Object.class);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            int i = 0;
            int len = pds.length;
            while (i < len) {
                PropertyDescriptor pd = pds[i];
                String name = pd.getName();
                if (_props.remove(name)) {
                    Method getter = pd.getReadMethod();
                    Method setter = pd.getWriteMethod();
                    if (getter == null || setter == null) {
                        if (pd instanceof IndexedPropertyDescriptor && logger.isLoggable(MLevel.WARNING)) {
                            logger.warning("BeansUtils.overwriteAccessibleProperties() does not support indexed properties that do not provide single-valued array getters and setters! [The indexed methods provide no means of modifying the size of the array in the destination bean if it does not match the source.]");
                        }
                        if (logger.isLoggable(MLevel.INFO)) {
                            logger.info("Property inaccessible for overwriting: " + pd.getName());
                        }
                    } else {
                        Object value = getter.invoke(sourceBean, EMPTY_ARGS);
                        BeansUtils.overwriteProperty(name, value, setter, destBean);
                    }
                }
                ++i;
            }
            if (logger.isLoggable(MLevel.WARNING)) {
                Iterator ii = _props.iterator();
                while (ii.hasNext()) {
                    logger.warning("failed to find expected property: " + ii.next());
                }
            }
        }
        catch (IntrospectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.logp(MLevel.FINE, BeansUtils.class.getName(), "overwriteSpecificAccessibleProperties( Object sourceBean, Object destBean, Collection props )", "Caught unexpected Exception; Converting to IntrospectionException.", e);
            }
            throw new IntrospectionException(e.getMessage());
        }
    }

    public static void debugShowPropertyChange(PropertyChangeEvent evt) {
        System.err.println("PropertyChangeEvent: [ propertyName -> " + evt.getPropertyName() + ", oldValue -> " + evt.getOldValue() + ", newValue -> " + evt.getNewValue() + " ]");
    }

    private BeansUtils() {
    }
}

