/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.beans.swing;

import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.beans.swing.HostBindingInterface;
import com.mchange.v2.beans.swing.PropertyBoundTextField;
import com.mchange.v2.beans.swing.PropertyComponentBindingUtility;
import com.mchange.v2.beans.swing.TestBean;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class PropertyBoundComboBox
extends JComboBox {
    PropertyComponentBindingUtility pcbu;
    MyHbi myHbi = new MyHbi();
    Object itemsSrc = null;
    Object nullObject = null;

    public PropertyBoundComboBox(Object bean, String propName, Object itemsSrc, Object nullObject) throws IntrospectionException {
        this.pcbu = new PropertyComponentBindingUtility(this.myHbi, bean, propName, false);
        this.nullObject = nullObject;
        this.setItemsSrc(itemsSrc);
    }

    public Object getItemsSrc() {
        return this.itemsSrc;
    }

    public void setItemsSrc(Object itemsSrc) {
        this.myHbi.suspendNotifications();
        this.removeAllItems();
        if (itemsSrc instanceof Object[]) {
            Object[] oa = (Object[])itemsSrc;
            int i = 0;
            int len = oa.length;
            while (i < len) {
                this.addItem(oa[i]);
                ++i;
            }
        } else if (itemsSrc instanceof Collection) {
            Collection c = (Collection)itemsSrc;
            Iterator ii = c.iterator();
            while (ii.hasNext()) {
                this.addItem(ii.next());
            }
        } else if (itemsSrc instanceof ComboBoxModel) {
            this.setModel((ComboBoxModel)itemsSrc);
        } else {
            throw new IllegalArgumentException("itemsSrc must be an Object[], a Collection, or a ComboBoxModel");
        }
        this.itemsSrc = itemsSrc;
        this.pcbu.resync();
        this.myHbi.resumeNotifications();
    }

    public void setNullObject(Object o) {
        this.nullObject = null;
        this.pcbu.resync();
    }

    public Object getNullObject() {
        return this.nullObject;
    }

    public static void main(String[] argv) {
        try {
            TestBean tb = new TestBean();
            PropertyChangeListener pcl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BeansUtils.debugShowPropertyChange(evt);
                }
            };
            tb.addPropertyChangeListener(pcl);
            PropertyBoundComboBox jcb1 = new PropertyBoundComboBox(tb, "theString", new String[]{"SELECT", "Frog", "Fish", "Puppy"}, "SELECT");
            PropertyBoundTextField jt2 = new PropertyBoundTextField(tb, "theInt", 5);
            PropertyBoundTextField jt3 = new PropertyBoundTextField(tb, "theFloat", 5);
            JFrame frame = new JFrame();
            BoxLayout bl = new BoxLayout(frame.getContentPane(), 1);
            frame.getContentPane().setLayout(bl);
            frame.getContentPane().add(jcb1);
            frame.getContentPane().add(jt2);
            frame.getContentPane().add(jt3);
            frame.pack();
            frame.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MyHbi
    implements HostBindingInterface {
        boolean suspend_notice = false;

        MyHbi() {
        }

        public void suspendNotifications() {
            this.suspend_notice = true;
        }

        public void resumeNotifications() {
            this.suspend_notice = false;
        }

        @Override
        public void syncToValue(PropertyEditor editor, Object newVal) {
            if (newVal == null) {
                PropertyBoundComboBox.this.setSelectedItem(PropertyBoundComboBox.this.nullObject);
            } else {
                PropertyBoundComboBox.this.setSelectedItem(newVal);
            }
        }

        @Override
        public void addUserModificationListeners() {
            ItemListener isl = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (!MyHbi.this.suspend_notice) {
                        ((MyHbi)MyHbi.this).PropertyBoundComboBox.this.pcbu.userModification();
                    }
                }
            };
            PropertyBoundComboBox.this.addItemListener(isl);
        }

        @Override
        public Object fetchUserModification(PropertyEditor editor, Object oldValue) {
            Object out = PropertyBoundComboBox.this.getSelectedItem();
            if (PropertyBoundComboBox.this.nullObject != null && PropertyBoundComboBox.this.nullObject.equals(out)) {
                out = null;
            }
            return out;
        }

        @Override
        public void alertErroneousInput() {
            PropertyBoundComboBox.this.getToolkit().beep();
        }
    }
}

