/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.beans.swing;

import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.beans.swing.HostBindingInterface;
import com.mchange.v2.beans.swing.PropertyComponentBindingUtility;
import com.mchange.v2.beans.swing.TestBean;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class PropertyBoundTextField
extends JTextField {
    PropertyComponentBindingUtility pcbu;
    HostBindingInterface myHbi = new MyHbi();

    public PropertyBoundTextField(Object bean, String propName, int columns) throws IntrospectionException {
        super(columns);
        this.pcbu = new PropertyComponentBindingUtility(this.myHbi, bean, propName, true);
        this.pcbu.resync();
    }

    public static void main(String[] argv) {
        try {
            TestBean tb = new TestBean();
            PropertyChangeListener pcl = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BeansUtils.debugShowPropertyChange(evt);
                }
            };
            tb.addPropertyChangeListener(pcl);
            PropertyBoundTextField jt1 = new PropertyBoundTextField(tb, "theString", 20);
            PropertyBoundTextField jt2 = new PropertyBoundTextField(tb, "theInt", 5);
            PropertyBoundTextField jt3 = new PropertyBoundTextField(tb, "theFloat", 5);
            JFrame frame = new JFrame();
            BoxLayout bl = new BoxLayout(frame.getContentPane(), 1);
            frame.getContentPane().setLayout(bl);
            frame.getContentPane().add(jt1);
            frame.getContentPane().add(jt2);
            frame.getContentPane().add(jt3);
            frame.pack();
            frame.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MyHbi
    implements HostBindingInterface {
        MyHbi() {
        }

        @Override
        public void syncToValue(PropertyEditor editor, Object newVal) {
            if (newVal == null) {
                PropertyBoundTextField.this.setText("");
            } else {
                editor.setValue(newVal);
                String newValStr = editor.getAsText();
                PropertyBoundTextField.this.setText(newValStr);
            }
        }

        @Override
        public void addUserModificationListeners() {
            WeChangedListener wcl = new WeChangedListener();
            PropertyBoundTextField.this.addActionListener(wcl);
            PropertyBoundTextField.this.addFocusListener(wcl);
        }

        @Override
        public Object fetchUserModification(PropertyEditor editor, Object oldValue) {
            String valAsStr = PropertyBoundTextField.this.getText().trim();
            if ("".equals(valAsStr)) {
                return null;
            }
            editor.setAsText(valAsStr);
            return editor.getValue();
        }

        @Override
        public void alertErroneousInput() {
            PropertyBoundTextField.this.getToolkit().beep();
        }
    }

    class WeChangedListener
    implements ActionListener,
    FocusListener {
        WeChangedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PropertyBoundTextField.this.pcbu.userModification();
        }

        @Override
        public void focusGained(FocusEvent evt) {
        }

        @Override
        public void focusLost(FocusEvent evt) {
            PropertyBoundTextField.this.pcbu.userModification();
        }
    }
}

