/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.DelayedLogItem;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.cfg.PropertiesConfigSource;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Properties;

public final class BasicPropertiesConfigSource
implements PropertiesConfigSource {
    @Override
    public PropertiesConfigSource.Parse propertiesFromSource(String identifier) throws FileNotFoundException, Exception {
        InputStream rawStream = MultiPropertiesConfig.class.getResourceAsStream(identifier);
        if (rawStream != null) {
            BufferedInputStream pis = new BufferedInputStream(rawStream);
            Properties p = new Properties();
            LinkedList<DelayedLogItem> messages = new LinkedList<DelayedLogItem>();
            try {
                p.load(pis);
            }
            finally {
                try {
                    if (pis != null) {
                        ((InputStream)pis).close();
                    }
                }
                catch (IOException e) {
                    messages.add(new DelayedLogItem(DelayedLogItem.Level.WARNING, "An IOException occurred while closing InputStream from resource path '" + identifier + "'.", e));
                }
            }
            return new PropertiesConfigSource.Parse(p, messages);
        }
        throw new FileNotFoundException(String.format("Resource not found at path '%s'.", identifier));
    }
}

