/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.cfg;

import com.mchange.v2.cfg.BasicMultiPropertiesConfig;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class CombinedMultiPropertiesConfig
extends MultiPropertiesConfig {
    MultiPropertiesConfig[] configs;
    String[] resourcePaths;
    List parseMessages;

    CombinedMultiPropertiesConfig(MultiPropertiesConfig[] configs) {
        this.configs = configs;
        LinkedList<String> allPaths = new LinkedList<String>();
        int i = configs.length - 1;
        while (i >= 0) {
            String[] rps = configs[i].getPropertiesResourcePaths();
            int j = rps.length - 1;
            while (j >= 0) {
                String rp = rps[j];
                if (!allPaths.contains(rp)) {
                    allPaths.add(0, rp);
                }
                --j;
            }
            --i;
        }
        this.resourcePaths = allPaths.toArray(new String[allPaths.size()]);
        LinkedList pms = new LinkedList();
        int i2 = 0;
        int len = configs.length;
        while (i2 < len) {
            pms.addAll(configs[i2].getDelayedLogItems());
            ++i2;
        }
        this.parseMessages = Collections.unmodifiableList(pms);
    }

    private Map getPropsByResourcePaths() {
        HashMap<String, Properties> out = new HashMap<String, Properties>();
        int i = 0;
        int len = this.resourcePaths.length;
        while (i < len) {
            String rp = this.resourcePaths[i];
            out.put(rp, this.getPropertiesByResourcePath(rp));
            ++i;
        }
        return Collections.unmodifiableMap(out);
    }

    public BasicMultiPropertiesConfig toBasic() {
        String[] rps = this.getPropertiesResourcePaths();
        Map pbrm = this.getPropsByResourcePaths();
        List pms = this.getDelayedLogItems();
        return new BasicMultiPropertiesConfig(rps, pbrm, pms);
    }

    @Override
    public String[] getPropertiesResourcePaths() {
        return (String[])this.resourcePaths.clone();
    }

    @Override
    public Properties getPropertiesByResourcePath(String path) {
        Properties out = new Properties();
        int i = 0;
        int len = this.configs.length;
        while (i < len) {
            MultiPropertiesConfig config = this.configs[i];
            Properties check = config.getPropertiesByResourcePath(path);
            if (check != null) {
                out.putAll((Map<?, ?>)check);
            }
            ++i;
        }
        return out.size() > 0 ? out : null;
    }

    @Override
    public Properties getPropertiesByPrefix(String pfx) {
        LinkedList<Map.Entry<Object, Object>> entries = new LinkedList<Map.Entry<Object, Object>>();
        int i = this.configs.length - 1;
        while (i >= 0) {
            MultiPropertiesConfig config = this.configs[i];
            Properties properties = config.getPropertiesByPrefix(pfx);
            if (properties != null) {
                entries.addAll(0, properties.entrySet());
            }
            --i;
        }
        if (entries.size() == 0) {
            return null;
        }
        Properties out = new Properties();
        for (Map.Entry entry : entries) {
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }

    @Override
    public String getProperty(String key) {
        int i = this.configs.length - 1;
        while (i >= 0) {
            MultiPropertiesConfig config = this.configs[i];
            String check = config.getProperty(key);
            if (check != null) {
                return check;
            }
            --i;
        }
        return null;
    }

    @Override
    public List getDelayedLogItems() {
        return this.parseMessages;
    }
}

